/**
 * @author bhanu ps
 */
Ext.define('Academia.view.applicationreport.ApplicationReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.applicationreportgrid',
	store: 'reports.applicationreport.ApplicationReportListStore',
	title: getAdmissionTranslation('APPLICANTION_REPORT_GRID'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store :  'reports.applicationreport.ApplicationReportListStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar : ['->',{
		xtype : 'button',
		itemId : 'exportReportsId',
		tooltip : getCommonTranslation('EXPORTREPORTS'),
		text : getCommonTranslation('EXPORTREPORTS'),
		formBind:true,
		disabled:true,
	}],
	columns: [{
		header : getAdmissionTranslation('APPLICATION_CODE'),
		dataIndex : 'applicationCode',
		flex : 1
	},{
		header : getAdmissionTranslation('STUDENT_ID'),
		dataIndex : 'candidateId',
		flex : 1
	},{
		header : getAdmissionTranslation('FORM_NO'),
		dataIndex : 'formNo',
		flex : 1
	},{
		header : getAdmissionTranslation('STUDENT_NAME'),
		dataIndex : 'name',
		flex : 1
	},{
		header : getAdmissionTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden:true
	},{
		header : getAdmissionTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden:true
	},{
		header : getAdmissionTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1,
		hidden:true
	},{
		header : getAdmissionTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex : 1
	},{
		header :getAdmissionTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1
	},{
		header :getAdmissionTranslation('BATCH'),
		dataIndex : 'batch',
		flex : 1
	},{
		header : getAdmissionTranslation('CANDIDATE_GENDER'),
		dataIndex : 'genderCSM',
		flex : 1
	},{
		header : getAdmissionTranslation('DOB'),
		dataIndex : 'dob',
		flex : 1,
		renderer:function(value) {
			return dateRender(value);
		}
	},{
		header : getAdmissionTranslation('EMAIL_ID'),
		dataIndex : 'emailId',
		flex : 1
	},{
		header :getAdmissionTranslation('MOBILE_NO'),
		dataIndex : 'mobileNumber',
		flex : 1
	},{
		header :getAdmissionTranslation('PHONE_NO'),
		dataIndex : 'phoneNo',
		flex : 1
	},{
		header :getAdmissionTranslation('APPLICATION_DATE'),
		dataIndex : 'applicationDate',
		flex : 1,
		renderer:function(value) {
			return dateRender(value);
		}
	},{
		header :getAdmissionTranslation('MARITAL_STATUS'),
		dataIndex : 'maritalStatus',
		flex : 1
	},{
		header :getAdmissionTranslation('CITY'),
		dataIndex : 'city',
		flex : 1
	},{
		header :getAdmissionTranslation('STATE'),
		dataIndex : 'state',
		flex : 1
	},{
		header :getAdmissionTranslation('COUNTRY'),
		dataIndex : 'country',
		flex : 1
	},{
		header :getAdmissionTranslation('POSTAL'),
		dataIndex : 'postal',
		flex : 1
	},{
		header :getAdmissionTranslation('ADDRESS'),
		dataIndex : 'address',
		flex : 1
	}]
});
