/**
 * @author Manas
 * @description Exam Block Add Form (OLD UI TYPE)
 */
Ext.define('Academia.view.assessmentSchedule.ExamBlockAddForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.examblockaddform',
	style: {
	        marginLeft: '20px',
	        marginTop: '10px'
	    },
    autoScroll: true,
    border: true, 
    method: 'POST',
    layout: {
        type: 'vbox'
    },
    standardSubmit: false,
    plugins: 'formlabelrequired',

    defaults: {
        labelAlign: 'top'
    },

    items: [{
        xtype: 'hidden',
        name: 'id'
    },

    /* ========= Row 1 ========= */
    {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: { type: 'hbox' },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'textfield',
            name: 'code',
            fieldLabel: getExaminationTranslation('EXAM_BLOCK_CODE'),
            allowBlank: false
        }, {
            xtype: 'textfield',
            name: 'name',
            fieldLabel: getExaminationTranslation('EXAM_BLOCK_NAME'),
            allowBlank: false
        }]
    },

    /* ========= Row 2 ========= */
    {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: { type: 'hbox' },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'examCenterId',
            fieldLabel: getExaminationTranslation('EXAM_CENTRE'),
            store:'examinationcenters.evaluationgrouplisting.centerallocation.CenterNameStoreForBlock', 
			//store:Ext.create('examinationcenters.evaluationgrouplisting.centerallocation.EGListingCenterName'),
            displayField: 'value',
            valueField: 'id',
            allowBlank: false,
            forceSelection: true,
            typeAhead: true,
            minChars: 3
        }]
    },

    /* ========= Row 3 ========= */
    {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: { type: 'hbox' },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
            fieldLabel: getExaminationTranslation('FROM_DATE'),
            format: 'd/m/Y',
            allowBlank: false
        }, {
            xtype: 'datefield',
            name: 'tillDate',
            fieldLabel: getExaminationTranslation('TILL_DATE'),
            format: 'd/m/Y',
            allowBlank: false
        }]
    },

    /* ========= Row 4 ========= */
    {
        xtype: 'fieldcontainer',
        width: '100%',
        layout: { type: 'hbox' },
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'radiogroup',
            fieldLabel: getExaminationTranslation('STUDENT_CAN_SELECT_CENTRE'),
            layout: 'hbox',
            items: [{
                boxLabel: getCommonTranslation('YES'),
                name: 'studentCanSelectCenter',
                inputValue: true
            }, {
                boxLabel: getCommonTranslation('NO'),
                name: 'studentCanSelectCenter',
                inputValue: false,
                checked: true
            }]
        }, {
            xtype: 'radiogroup',
            fieldLabel: getExaminationTranslation('ONLINE_EXAM_APPLICABLE'),
            layout: 'hbox',
            items: [{
                boxLabel: getCommonTranslation('YES'),
                name: 'onlineExamApplicable',
                inputValue: true
            }, {
                boxLabel: getCommonTranslation('NO'),
                name: 'onlineExamApplicable',
                inputValue: false,
                checked: true
            }]
        }]
    },

    /* ========= Buttons ========= */
    {
        layout: { type: 'hbox' },
        items: [{
            xtype: 'button',
            text: getExaminationTranslation('SAVE'),
            itemId: 'examBlockSaveBtn',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getExaminationTranslation('RESET'),
            itemId: 'examBlockResetBtn',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE,
            handler: function () {
                this.up('form').getForm().reset();
            }
        }]
    }]
});