/**
 *  @author Rajkumar.patidar
 */

var AttendanceForCompleteDayList = Ext.create('Academia.store.attendance.attendancereport.AttendanceForCompleteDayList');
Ext.define('Academia.view.attendance.AttendanceForComplateDayList', {
	 extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.attendanceforcomplatedaylist',
	store : AttendanceForCompleteDayList,
	title: getCommonTranslation('STUDENT_ATTENDANCE_REPORT'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'attendancemainstructure':1
		}
	},
	tbar : [{
		xtype: 'button',
		itemId: 'btnDeleteAttendance',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype : 'button',
		itemId : 'btnEditAttendance',
		tooltip : getProgramandcourseTranslation('UPDATE_ATTENDANCE'),
		text : getProgramandcourseTranslation('UPDATE_ATTENDANCE')
	},	
	'->'],
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			itemId:'custompagingtoolbar',
			plugins:['pagesize'],
			store : AttendanceForCompleteDayList,
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
         var grid=this;    
         grid.addExportToolBarItems(grid,true);
         this.callParent(arguments); 
  },
	columns: [{
		header : getCommonTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_CODE'),
		dataIndex : 'studentCode',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('GENDER'),
		dataIndex : 'gender',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	},{
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1
	},{
		header :getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'groupName',
		hidden:true,
		flex : 1
	},{
		header : getCommonTranslation('PROGRAM_CODE'),
//		translationKey:'PROGRAM_CODE',
		dataIndex : 'programCode',
		flex:1
	},{
		header : getCommonTranslation('BATCH_NAME'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCommonTranslation('PROGRAM_PERIOD'),
//		translationKey:'PROGRAM_PERIOD',
		dataIndex : 'periodName',
		flex:1
	},{
		header : getCommonTranslation('SECTION_CODE'),
		dataIndex : 'sectionCode',
		flex : 1
	},{
		header : getCommonTranslation('ATTENDANCE_DATE'),
		dataIndex : 'dateOfAttendance',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {   
		header : getCommonTranslation('SESSION_NO'),
		dataIndex : 'sessionNo',
		flex : 1,
		//V2D-73383
		/*renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)){
				var a =view.up().up().up();
				var form = a.down('attendancesearchstrucure');
				var alinfomodel = Academia.model.authentication.ALInfoModel;
				 var wheatherSchool = alinfomodel.get('wheatherSchool');
				 if(wheatherSchool){
					 var filter = form.down('#sessionNumberItemId');
				 }	else{
					 var filter = form.down('#sessionNumberItemId1');
				 }
				//var store = filter.getStore();
				//for(var i =0;i<store.data.length;i++){
				//	if(store.data.items[0].data.code==val) {
				//		return store.data.items[0].data.val;
				//	} else  {
				//		return val;
				//	}
				//}
			}
		}*/
	},{
		header : getCommonTranslation('FACULTY_NAME'),
		dataIndex : 'facultyName',
		flex : 1
	},{
		header : getCommonTranslation('ATTENDANCE_STATUS'),
		dataIndex : 'attendanceStatus',
		flex : 1
	},{
		header : getCommonTranslation('WHETHER_ATTENDANCE_MARKED'),
		//dataIndex : 'lastUpdate',
		dataIndex : 'lastUpdate',
		sortable : true,
		renderer:function(timestamp) {
			return dateTimeRender1(timestamp);
		}
	},{
		header: getCommonTranslation('REMARKS'),
		dataIndex: 'attendanceComment',
		flex:1,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
	    		return "";
	    	} else {	    		
	    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;';
	    		return val;
    		}
		}
	}]
});