/**
 * Akshay Sharma
*/

var ConsolidateAttendanceGridStore = Ext.create('Academia.store.attendance.ConsolidateAttendanceGridStore');

Ext.define('Academia.view.attendance.ConsolidateAttendanceGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.consolidateattendancegrid',
	store : ConsolidateAttendanceGridStore ,
	title : getProgramandcourseTranslation('DAILY_ATTENDANCE_SUMMARY'),
	border: true,
	refreshStoreData:true,
	selType:'checkboxmodel',
	id:'consolidateattendancegridId',
	hidden:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'attendancemainstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	tbar : [{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		itemid:'dockedItemsItemId',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : ConsolidateAttendanceGridStore,
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}
	],
	initComponent: function() {

        var grid=this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     

 },
	columns : [{
		header :getCommonTranslation('PROGRAM_GROUP'),
		dataIndex : 'groupName',
		hidden:true,
		flex : 1,
		sortable : true
	},{
		header :getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true
	}, {
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('FACULTY'),
		dataIndex : 'facultyName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('DATE'),
		dataIndex : 'date',
		sortable : true,
		renderer:function(date) {
			return dateRender(date);
		}
	},
	{
		header : getProgramandcourseTranslation('SESSION_NO'),
		dataIndex : 'sessionNo',
		flex : 1,
		sortable : true,
		hidden : true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(!isNullOrEmpty(val)){
				try{
					var userModel=Academia.model.authentication.UserInfoModel;
					if(userModel.get("portalId")==2){
						var a =view.up().up().up();
						var form = a.down('sessionwisedailyattendancesearch');
					}else{
						var a =view.up().up();
						var form = a.down('consolidatesearchattendance');
					}
					var filter = form.down('#sessionItemId');
					var store = filter.getStore();
					for(var i =0;i<store.data.length;i++){
						if(store.data.items[i].data.code==val) {
							return store.data.items[i].data.val;
						} else  {
							return val;
						}
					}
				}catch(e){
					return val;
				}
				
			}
		}
	},{
		header : getCommonTranslation('TOTAL_STUDENTS'),
		dataIndex : 'totalStudents',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('PRESENT'),
		dataIndex : 'totalPresents',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('ABSENT'),
		dataIndex : 'totalAbsents',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('OTHERS'),
		dataIndex : 'totalLeaves',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('WHETHER_ATTENDANCE_MARKED'),
		dataIndex : 'lastUpdate',
		sortable : true,
		renderer:function(timestamp) {
			return dateTimeRender1(timestamp);
		}
	},{
		header : getCommonTranslation('PRESENT_PERCENTAGE_REPORT'),
		dataIndex : 'presentPercentage',
		flex : 1,
		sortable : true,
		renderer: function (value) {
		        if (value === null || value === undefined || value === '') {
		            return '';
		        }
		        value = parseFloat(value);
		        if (isNaN(value)) {
		            return '';
		        }
		        return Ext.util.Format.number(value, '0.00') + ' %';
		    }
	},{
		header : getCommonTranslation('ABSENT_PERCENTAGE_REPORT'),
		dataIndex : 'absentPercentage',
		flex : 1,
		sortable : true,
		renderer: function (value) {
	        if (value === null || value === undefined || value === '') {
	            return '';
	        }
	        value = parseFloat(value);
	        if (isNaN(value)) {
	            return '';
	        }
	        return Ext.util.Format.number(value, '0.00') + ' %';
	    }
	}]
});
