/**
 * Akshay Sharma
 */
Ext.define('Academia.view.attendance.EditStudentAttendanceGrid', {
	extend : 'Ext.form.FormPanel',
	alias: 'widget.editstudentattendancegrid',
	modal : true,
	autoScroll: false,
	frame: false,
	margin: 0,
	temp :[],
	items:[{
		 xtype : 'panel',
		 width: 'auto',
		 layout : {
			 type : 'hbox'
		 },
		 style: {
			 marginBottom:'0px',
			 marginTop:'0px'
		 },
		 items : [{
			 xtype : 'radiogroup',
			 itemId:'markOnlyAttendance_Id',
			 items : []
		 },{
			 xtype: 'customcombobox',
			 itemId:'editOtherStatusId',
			 store:'attendance.AttendanceMarkingTypeStore',
			 valueField : 'value',
			 displayField : 'value',
			 typeAhead:false,
			 forceSelection : true,
			 hidden:true

		 }]
	 },{
		xtype: 'grid',
		autoScroll: false,
		title:getProgramandcourseTranslation('DAILY_ATTENDANCE_SUMMARY'),
		border:true,
		store : 'attendance.EditStudentAttendanceListStore',
		viewConfig: {
			emptyText: getCommonTranslation('EMPTY_MESSAGE')
		},
		columns : [{
			xtype: 'rownumberer',
			header: getCommonTranslation('SNO'),
			align :'left',
			flex:.5
		},/*{
			 header : 'ID',
			 hidden : true,
			 dataIndex:'id'
		 },*/{
			header :getProgramandcourseTranslation('ADMISSION_CODE'),
			dataIndex : 'admissionCode',
			flex:1
		},{
			header :getProgramandcourseTranslation('STUDENT_CODE'),
			dataIndex : 'studentCode',
			flex:1
		},{
			header : getProgramandcourseTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			flex:1
		},{
			header : getCommonTranslation('STUDENT_FIRST_NAME'),
			dataIndex : 'firstName',
			flex:1,
			hidden :true
		},{
			header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
			dataIndex : 'middleName',
			flex:1,
			hidden :true
		},{
			header : getCommonTranslation('STUDENT_LAST_NAME'),
			dataIndex : 'lastName',
			flex:1
		},{
			xtype : 'checkcolumn', 
			flex:.75,
			itemId:'presentId',
			text : getProgramandcourseTranslation('PRESENT'), 
			dataIndex : 'present',
			editor: false,
			listeners: {
				beforecheckchange: function(checkcolumn, rowIndex, checked, eOpts){
					var eType = "";
					try{
						var eType = this.up('editstudentattendancegrid').eType;
					}
					catch(e){}
					if(eType=="view"){
						return false;
					}
					else{
						return true;
					}
				}
			}
		},{
			xtype : 'checkcolumn',
			text : getProgramandcourseTranslation('ABSENT'),
			dataIndex :  'absent',
			flex : .75,
			editor: false,
			listeners: {
				beforecheckchange: function(checkcolumn, rowIndex, checked, eOpts){
					var eType = "";
					try{
						var eType = this.up('editstudentattendancegrid').eType;
					}
					catch(e){}
					if(eType=="view"){
						return false;
					}
					else{
						return true;
					}
				}
			}
		},{
			header : getProgramandcourseTranslation('OTHERS'),
			dataIndex : 'attendanceStatus',
			flex : .75,
			editor : {
				xtype: 'customcombobox',
				itemId:'StudentAttendanceStatus_Id',
				store:'attendance.AttendanceMarkingTypeStore',
				valueField : 'value',
				displayField : 'value',
				typeAhead:false,
				forceSelection : true
			},
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				var eType = "";
				try{
					var eType = this.up('editstudentattendancegrid').eType;
				}
				catch(e){}
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle';
					if(eType!="view"){
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}else{
					return val;
				}
			}
		},{
			header: getProgramandcourseTranslation('REMARKS'),
			dataIndex: 'comment',
			flex:.75,
			sortable:true,
			editor : {
				xtype: 'textfield',
				name: 'attendanceComment',
				maxLength:255
			},
			renderer:function(val,rec,record,rowIndex,colIndex,store,view){
				var eType = "";
				try{
					var eType = this.up('editstudentattendancegrid').eType;
				}
				catch(e){}
				if(isNullOrEmpty(val)){
					rec.tdCls = 'gridInputCustomStyle'; 
					if(eType!="view"){
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}else{
					return val;
				}
			}
		}],
		plugins: [{
			ptype : 'cellediting',
			clicksToEdit: 1,
			listeners: {
				beforeedit: function(obj, editor){
					var eType = "";
					try{
						var eType = editor.grid.up('editstudentattendancegrid').eType;
					}
					catch(e){}
					if(eType=="view"){
						return false;
					}
				},
				edit: function(obj, editor, context){
					var this$= this;
					var grid = obj.grid;
					var store = grid.getStore();
					var models = grid.getStore().getRange();
					var gridCount = Ext.getCmp('editStudentAttendancecountGridId');
					var field = grid.down('#StudentAttendanceStatus_Id');
					if(obj.context.column.field.name != 'attendanceComment'){
						if(!isNullOrEmpty(field.getValue())){
							for(var i =0; i<store.data.length;i++){
								if(editor.rowIdx==i){
									models[i].set('present', false);
									models[i].set('absent', false);
									Ext.defer(function() {
										var preCount=0,absCount=0, other=0, presentSummaryCount = 0, absentSummaryCount= 0;
										for(var i =0; i<store.data.length;i++){
										if(models[i].data.present){
											preCount++;
											presentSummaryCount++;
										}
										if(models[i].data.absent){
											absCount++;
											absentSummaryCount++;
										}
										if(models[i].data.attendanceStatus){
											other++;
											for(var z = 0; z<this.grid.columnManager.columns.length;z++){
												if(this.grid.columnManager.columns[z].dataIndex == "attendanceStatus") {
													var data  = this.grid.columnManager.columns[z].field.getStore().data.items;
													for(var j= 0; j<data.length;j++){
														if(data[j].data.value == models[i].data.attendanceStatus){
															if(data[j].data.code == 'PRESENT')
																presentSummaryCount++;
															if(data[j].data.code == 'ABSENT')
																absentSummaryCount++;
															models[i].set("attendanceMarkingType", data[j].data.id);
															models[i].set('attendanceMarkStatus' ,data[j].data.code);
														}
													}
												}
											}
										}
										}
										var  data = {
												totalStudent:store.data.length,
												totalPresent:preCount,
												totalAbsent:absCount,
												otherCount:other,
												presentPercent:parseFloat((presentSummaryCount/store.data.length)*100).toFixed(2)+"%",
												absentPercent:parseFloat((absentSummaryCount/store.data.length)*100).toFixed(2)+"%",
										};
										var gridStore =  gridCount.getStore();
										gridStore.removeAll();
										gridStore.loadRawData(data, true);

									}, 50, this);
									break;
								}
							}
						}
					}
				}
			}
		}]
	} ]
});
