/**
 * @author prathamesh.sheth
 *  
 * Activity Feeds Type screen.
 * 
 */
Ext.define('Academia.view.baselayout.header.ActivityFeedTypePanel', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.activityfeedtypepanel',
    title: getCommonTranslation('ACTIVITY_FEEDS'), //Activity Feeds	    
    border: true,
    hideHeaders : true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },    
    initComponent: function() {    	          	
     	var store=Ext.create('Academia.store.authentication.ActivityFeedType');
     	Ext.apply(this, {
             store: store        
         });
         this.callParent(arguments);         
     },
    columns: [{    	
        dataIndex: 'icon',
        flex: .2,
        renderer:function(val,metaData,record){
        	var value="";
        	if(!isEmpty(record.data) && !isNullOrEmpty(record.get('type'))){
        		var type=record.get('type');
        		if(type==CONSTANTS.ALERTS){
        			value="<img src='resources/images/alert_icon.png'>";
        		}else if(type==CONSTANTS.NOTIFICATIONS){
        			value="<img src='resources/images/bell_icon.png'>";
        		}else if(type==CONSTANTS.NEW_TASKS){
        			value="<img src='resources/images/task_icon.png'>";
        		}        		
        	}
        	return value;        	
        }
    }, {    	
        dataIndex: 'type',
        flex: .3
    }, {            	
        dataIndex: 'unreadCount',
        flex: .2        
    }]
});