/**
 * @author Akshay.Kalbhor
 * refers to the center north portion of the header which contains the notifications alerts and new Tasks button.
 */
Ext.define('Academia.view.baselayout.header.UserInfo', {
    extend: 'Ext.Container',
    alias: 'widget.userinfo',
    bodyCls :'navbar navbar-default',
    baseCls:'x-plain',
    initComponent: function() {
	this.layout = {
	               type: 'hbox',
	               pack: 'center',
	               align: 'center'
	           };

        this.items = [ {
        	/*xtype : 'component',        	
        	renderTpl : new Ext.Template([ '<div class="dropdown left profile"> <a class="dropdown-toggle" data-toggle="dropdown" href="#"><div class="profile-avatar"><img src="~/../resources/images/avatar1.png" alt=""></div><div class="profile-username">{username}</div><div class="profile-caret"> <span class="caret-img"></span></div></a></div>' ]),
        	renderData : {
        		username : ''
        	},
        	childEls : [ "username" ]
        	
        }, {*/
        	//TODO: refine the component
        	xtype: 'button',
        	iconCls: 'profile-avatar',
        	//icon: '~/../resources/images/avatar1.png',
        	itemId: 'userInfoButton',
        	cls:'headerUserinfoBtn',
        	style: {
        		marginTop:'4px',
        		backgroundImage: 'none'
        	},
            menu: Ext.menu.Menu({
            	 width: 225,
            	 //height:282,
            	 cls:'userInfoPanelCLS',
            	items: [{
            		itemId: 'myDashboard',
            		cls:'headerUserinfoOption',
            		iconCls :'icon-my_dashboard',
                    text: getCommonTranslation('MY_DASHBOARD')
             	},{
            		itemId: 'changePasswordLink',
            		cls:'headerUserinfoOption',
            		iconCls :'icon-change_password',
                    text: getCommonTranslation('CHANGE_PASSWORD')
            		//renderTpl:['<div class="dropdown left" style="height: 60"> <a href="#"><span class="notice-tag">Change Password</span> </a></div>']
            	},{
                    // Adding "Translate with Google" Option with Icon
                    text: getCommonTranslation('TRANSLATE_WITH_GOOGLE'),
                    itemId: 'translateWithGoogle',
                    iconCls: 'icon-google-translate', // Add an appropriate icon for translation
                    cls: 'headerUserinfoOption'
                 },{
            		itemId: 'changeStudentLink',
            		cls:'headerUserinfoOption',
            		iconCls :'icon-change_student',
                    text: getCommonTranslation('CHANGE_STUDENT')
            	},{
            		text: getCommonTranslation('CHANGE_ACADEMY_LOCATION'),
            		itemId: 'changeAcademyLocOption',
            		cls:'headerUserinfoOption',
            		iconCls :'icon-change_academy_location',
            		
            	},{
            		text: getCommonTranslation('CHANGE_PORTAL'),
            		itemId: 'changePortal',
            		iconCls :'icon-change_portal',
            		cls:'headerUserinfoOption'
            	},{
            		text: getCommonTranslation('SOCIAL_MAPPING'),
            		itemId: 'socialMapping',
            		iconCls :'icon-social_mapping',
            		cls:'headerUserinfoOption',
            		hidden: true
            	},{
            		text: getCommonTranslation('CHANGE_LANGUAGE'),
            		itemId: 'changeLanguage',
            		iconCls :'icon-change_language',
            		cls:'headerUserinfoOption',       //bottomlineCls
            		listeners: {
            			beforerender: function(item){
            				if(Ext.getStore('common.ChangeLanguageStore').count()<2){
            					item.hide();
            				}
            			}
            		}
            	},{
            		cls:'bottomlineCls',
            		itemId : 'bottomLineFirstId',
            	},{
            		text: getCommonTranslation('RELEASE_NOTES'),
            		itemId : 'releaseNote',
            		cls:'headerUserinfoOption',
            		iconCls :'icon-releaseNote',
            		handler: function(btn){
            			window.open('https://releases.academiaerp.com/release-notes/', '_blank');
    				}
                },{
            		cls:'bottomlineCls'
            	},{
            		text: getCommonTranslation('LOGOUT'),
            		itemId : 'logoutButton',
            		cls:'headerUserinfoOption logoutBtnCls',
            		iconCls :'icon-logout',
            		
                }]
            })
        }, 
        /*{
            xtype: 'container', // New div added here
            itemId: 'additionalDiv',
            cls: 'additionalDivCls',           
            style: {
                marginLeft: '5px 0 0 6px',
                padding: '5px',
//                backgroundColor: 'red',
                borderRadius: '50px',
                width: '42px',
            	height: '42px'
            }
        }*/
        ];
        
        this.callParent();
    }
});