/**
 * @author Saket.Puranik
 
 * This component is used for to show Faculty details.
 */
Ext.define('Academia.view.calendar.entitylist.FacultyGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.facultygrid',
			/* requires : [ ], */
			store : 'calendar.entitylist.FacultyStore',
			title : getCommonTranslation('FACULTY'),//Faculties
			collapsible:false,
			border: true,
			autoScroll: false,
		    viewConfig: {
		        stripeRows: CONSTANTS.STRIPEROWS
		    },
			columns : [ {
				header : getCommonTranslation('FACULTY_ID_HEADER'),//Faculty Id	
				dataIndex : 'id',
				align: 'center',
				sortable : false,	
			    flex : .2
			}, {
				header : getCommonTranslation('FACULTY_NAME_HEADER'),//Faculty Name
				dataIndex : 'printName',	
				align: 'center',
				sortable : false,	
				flex : .4/*,
				renderer: function(value, metaData, record, row, col, store, gridView){
					if(!isEmpty(record)){
						var firstName = record.get("firstName");
						var lastName = record.get("lastName")
						value = firstName.concat(" ",lastName);
					}
				    return value;
				}*/
			}, {
				header : getCommonTranslation('DEPARTMENT_HEADER'),//Status
				dataIndex : 'department',
				align: 'center',
				sortable : false,	
				flex : .4,
				renderer : function(obj){
					return columnObjRender(obj,"value");
				}
			}, {
				header : getCommonTranslation('SUB_DEPARTMENT_HEADER'),//Academy Location
				dataIndex : 'subDepartment',	
				align: 'center',
				sortable : false,	
				flex : .4,
				renderer : function(obj){
					return columnObjRender(obj,"value");
				}			
			}],
						
			tbar : [

					{
						xtype : 'textfield',
						itemId : 'facultyNameId',
						name : 'facultyName',
						emptyText:'--Faculty Name--'	
					},
			        {
			        	xtype:'customcombobox',
			        	store:'department.ParentDepartmentByAccesibleStore',
			        	displayField:'name',
			        	valueField:'id',
			        	itemId:'comboDepartment',
			    		editable:false,
			        	emptyText:'All Departments'	
			        },{
			        	xtype:'customcombobox',
			        	store:'calendar.entitylist.filters.SubDepartmentFilterStore',
			        	displayField:'name',
			        	valueField:'id',
			        	itemId:'comboSubDepartment',
			        	emptyText:'--Select--',
			    		editable:false
			        }
						        
			        ],
			dockedItems : [ {
				xtype : 'toolbar',
				dock : 'bottom',
				items : [ {
					xtype: 'custompagingtoolbar',
		            plugins:['pagesize'],
					store : 'calendar.entitylist.FacultyStore',
					emptyMsg : '<span id="facultyGridId" style="margin-top: 60px !important">'+getCommonTranslation('EMPTY_FACULTY_MESSAGE')+'</span>',//No faculty to display
					displayInfo : true
				} ]
			} ,  {
				 xtype : 'toolbar',
				 dock : 'top',
				 items : [ {  xtype: 'label',
					 text: getCommonTranslation('CALENDAR_FACULTY_GRID_TITLE'),
					 style: 'font-weight:bold;'} ]
			 }]
		});
