/**
 * @author Samarth.ashturkar
 * 
 * This component is used for to show Work Timing Configuration Details Grid
 */
Ext.define('Academia.view.calendar.holidaysandspecialdaystabs.SpecialDayBreaksGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.specialdaybreaksgrid',
			title : getCommonTranslation('CALENDAR_SPECIAL_DAY_BREAKS_DETAILS'),//Special Day Breaks Detils
			collapsible:false,
			border: true,
			initComponent: function() {
				var me = this;
		        me.specialDayBreaksGridStore = Ext.create('Academia.store.calendar.SpecialDayBreaksGridStore', {});
		        Ext.apply(me, {
		        	store : me.specialDayBreaksGridStore,
					viewConfig : {
						stripeRows : CONSTANTS.STRIPEROWS
					},
					columns : [{
						header :getCommonTranslation('CALENDAR_BREAK_NAME'),//breakName
						dataIndex : 'breakName',	
						align: 'center',
						sortable : true,	
						flex : .3
					}, {
						header : getCommonTranslation('CALENDAR_START_TIME'),//'Start Time',
						dataIndex : 'startTime',
						align: 'center',
						sortable : true,	
					    flex : .2,
				        renderer: function(time) {
				            return timeRender(time);
				        }
					}, {
						header : getCommonTranslation('CALENDAR_END_TIME'),//'End Time',
						dataIndex : 'endTime',	
						align: 'center',
						sortable : true,	
						flex : .2,
				        renderer: function(time) {
				            return timeRender(time);
				        }
					}],
					tbar : [{
						xtype : 'button',				
						itemId : 'btnAddSpecialDayBreaks',
						tooltip : getCommonTranslation('ADD'),//Add
						glyph: ICONGLYPH.ADDGLYPH
						//text : getCommonTranslation('ADD')
					},{
						xtype : 'button',				
						itemId : 'btnEditSpecialDayBreaks',
						tooltip : getCommonTranslation('EDIT'),//Edit
						glyph: ICONGLYPH.EDITGLYPH
						//text : getCommonTranslation('EDIT')
					},{
						xtype : 'button',				
						itemId : 'btnViewSpecialDayBreaks',
						tooltip : getCommonTranslation('VIEW'),//View
						iconCls: 'view-icon'
						//text : getCommonTranslation('VIEW')
					},{
						xtype : 'button',				
						itemId : 'btnDeleteSpecialDayBreaks',
						cls: 'CustomToolbarBtnReject',
						tooltip :getCommonTranslation('DELETE'),//Delete
						glyph: ICONGLYPH.DELETEGLYPH
						//text : getCommonTranslation('DELETE')
					}],
					dockedItems :[{
						xtype : 'toolbar',
						dock : 'bottom',
						items : [{
							xtype: 'custompagingtoolbar',
				            plugins:['pagesize'],
							store : me.specialDayBreaksGridStore,
				            emptyMsg: getCommonTranslation('CALENDAR_EMPTY_SPECIAL_DAY_BREAKS_DETAILS_MESSAGE'),//'No Special day breaks list to display',
							displayInfo : true
						}]
					}]
		        });
		                
		        me.callParent(arguments);
		    },
			showSpecialDayBreaksForm: function() {				
				var winSpecialDayBreaksForm=Ext.widget('specialDayBreaksFormWindow');
				winSpecialDayBreaksForm.show();					
			}
		});