/**
 * @author Samarth.Ashturkar
 * This component is used for to Work Timing configuration Grid Details Window 
 */
Ext.define('Academia.view.calendar.holidaysandspecialdaystabs.SpecialDaysFormWindow',
		{
			extend : 'Ext.window.Window',
			alias : 'widget.specialDaysFormWindow',			
			modal : true,
			resizable:false,
			title : 'Special Days Details',//getCommonTranslation('ACADEMY_LOCATION_DETAILS'),//'Academy Location Details'						
			items : [{
				xtype: 'form',
				itemId:'specialDaysForm',
			    method : 'POST',
			    margin:0,
			    bodyPadding:'10 10 10 10',
			    plugins : "formlabelrequired",
				defaults:{
					labelAlign:'top'
				},
//			    /standardSubmit : true,
			    items :[{
						xtype : 'hidden',
						itemId:'hidden_id_field',
						name : 'id'
					},{
						xtype : 'hidden',
						itemId:'hidden_calendarId_field',
						name : 'calendarId'
					},{
						xtype : 'hidden',
						itemId:'version',
						name : 'version'
					},{
						xtype : 'datefield',
						name : 'startDate',			
						itemId : 'startDate',			
						fieldLabel : 'Start Date',// getCommonTranslation('LOCATION'),//Location
						editable: false,
						vtype: 'daterange',
						endDateField: 'endDate',
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						allowBlank:false,
	    				listeners: {
	    					render: function(field) {
	    						return dateFormatRender(field);
	    					}
	    				}
					},{
						xtype : 'datefield',
						name : 'endDate',			
						itemId : 'endDate',//'academy_location',			
						fieldLabel : 'End Date',// getCommonTranslation('LOCATION'),//Location
						editable: false,
						vtype: 'daterange',
						startDateField: 'startDate',
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						allowBlank:false,
	    				listeners: {
	    					render: function(field) {
	    						return dateFormatRender(field);
	    					}
	    				}
					},{
						xtype : 'textfield',
						name : 'description',						
						fieldLabel : 'Occasion',//getCommonTranslation('ACADEMY'),//Academy
						itemId:'description',
						allowBlank:false
					},{
						xtype : 'timefield',
						name : 'startTime',			
						itemId : 'startTime',			
						fieldLabel : 'Start Time',// getCommonTranslation('LOCATION'),//Location
						format:'g:i A',
						vtype: 'timerange',
						endTimeField : 'endTime',
			            submitFormat: 'g:i A',
						allowBlank:false
					},{
						xtype : 'timefield',
						name : 'endTime',			
						itemId : 'endTime',//'academy_location',			
						fieldLabel : 'End Time',// getCommonTranslation('LOCATION'),//Location
						format:'g:i A',
						vtype: 'timerange',
						startTimeField : 'startTime',
			            submitFormat: 'g:i A',
						allowBlank:false
					},{
						xtype : 'numberfield',
						name : 'slot',	
						itemId : 'slot',//'academy_location',			
						fieldLabel : 'Time Slot (In mins)',// getCommonTranslation('LOCATION'),//Location
						allowBlank:false,
						minValue: 1,
						maxValue: 1440
					},
					{
		        	xtype:'fieldcontainer',
		        	width:'100%',
		        	cls:'windowBtnPos',
		            items: [{
						xtype : 'button',				
						itemId:'btnSaveSpecialDaysForm',
						text : getCommonTranslation('SAVE'), //Submit
						ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		                formBind : true
					},{
						xtype : 'button',
						itemId:'btnCancelSpecialDaysForm',
						text : getCommonTranslation('CANCEL'), //Cancel
						ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
					}]
			    }]
			}]			
		});
