/**
 * This grid is used for work time slot
 */
Ext.define('Academia.view.calendar.worktimingconfiguration.WorkTimeSlotEditorGrid',
		{
			extend : 'Ext.grid.Panel',
			alias : 'widget.worktimesloteditorgrid',
			title : getCommonTranslation('CALENDAR_WORK_TIMING_SLOT_DETAILS'),
			collapsible: true,
			cls:'centerAlignTitle',
			collapsed:true,
			border: true,
			viewConfig : {
				stripeRows : CONSTANTS.STRIPROWS
			},
			columns : [ {
				header : getCommonTranslation('SLOT_PURPOSE'),
				dataIndex : 'slotPurpose',
				align: 'center',
				sortable : false,	
			    flex : .3,
		        renderer: function(value) {        	
		            return getCommonTranslation(value);
		        }
			}, {
				header : getCommonTranslation('CALENDAR_START_TIME'),
				dataIndex : 'startTime',
				align: 'center',
				sortable : false,	
				flex : .2
			}, {
				header : getCommonTranslation('CALENDAR_END_TIME'),
				dataIndex : 'endTime',	
				align: 'center',
				sortable : false,	
				flex : .2
			}],
			tbar : [{
				xtype : 'button',				
				itemId : 'btnAddSlotOnSelectedDay',
				tooltip : getCommonTranslation('ADD'),
				glyph: ICONGLYPH.ADDGLYPH
			},{
				xtype : 'button',				
				itemId : 'btnEditSlotOnSelectedDay',
				tooltip : getCommonTranslation('EDIT'),
				glyph: ICONGLYPH.EDITGLYPH
			},{
				xtype : 'button',				
				itemId : 'btnViewSlotOnSelectedDay',
				tooltip : getCommonTranslation('VIEW'),
				iconCls: 'view-icon'
			},{
				xtype : 'button',				
				itemId : 'btnDeleteSlotOnSelectedDay',
				cls: 'CustomToolbarBtnReject',
				tooltip :getCommonTranslation('DELETE'),
				glyph: ICONGLYPH.DELETEGLYPH
			}],
			initComponent: function() {
				var this$ = this;
		        var store = this$.buildStore();
		        Ext.apply(this$, {
		        	store : store
		        });
		        this$.callParent(arguments);
			},
			buildStore: function() {
		        return Ext.create('Academia.store.calendar.WorkTimeSlotStore');
		    }
		});
/*

Ext.define('Academia.view.calendar.worktimingconfiguration.WorkTimeSlotEditorGrid', {
    extend: 'Ext.grid.Panel',
    alias : 'widget.worktimesloteditorgrid',
	title : getCommonTranslation('CALENDAR_WORK_TIMING_SLOT_DETAILS'),//'Work Timing Configuration Grid'
	collapsible:false,
	border: true,
    selModel: {
        selType: 'cellmodel'
    },
    plugins: [this.cellEditing],
    columns: [{
        header: getCommonTranslation('CALENDAR_BREAK_NAME'),
        dataIndex: 'breakName',
        flex: 0.3,
        sortable: false,
        editor: {
            name: 'breakName',
            maxLength: 15,
            itemId: 'breakName',
            allowBlank: false
        }
    }, {
    	xtype: 'datecolumn',
        header: getCommonTranslation('CALENDAR_START_TIME'),
        dataIndex: 'startTime',
        flex: 0.2,
        format: CONSTANTS.DISPLAY_TIME_FORMAT,
        submitFormat: CONSTANTS.SUBMIT_TIME_FORMAT,
        sortable: false,
        editor: {
            xtype: 'timefield',
            name: 'startTime',
            itemId: 'startTime',
            format: CONSTANTS.DISPLAY_TIME_FORMAT,
            submitFormat: CONSTANTS.SUBMIT_TIME_FORMAT,
            //vtype: 'timerange',
            endTimeField: 'endTime',
            allowBlank: false
        }
    }, {
    	xtype: 'datecolumn',
        header: getCommonTranslation('CALENDAR_END_TIME'),
        dataIndex: 'endTime',
        flex: 0.2,
        format: CONSTANTS.DISPLAY_TIME_FORMAT,
        submitFormat: CONSTANTS.SUBMIT_TIME_FORMAT,
        sortable: false,
        editor: {
            xtype: 'timefield',
            name: 'endTime',
            itemId: 'endTime',
            format: CONSTANTS.DISPLAY_TIME_FORMAT,
            submitFormat: CONSTANTS.SUBMIT_TIME_FORMAT,
            //vtype: 'timerange',
            startTimeField: 'startTime',
            allowBlank: false
        }
        
    }, {
        xtype: 'checkcolumn',
        header: getCommonTranslation('IS_BREAK'),
        dataIndex: 'isBreak',
        flex: 0.2,
        sortable: false,
        editor: {
            xtype: 'checkbox',
            cls: 'x-grid-checkheader-editor'
        }
    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAddWorkTimingConfiguration',
        tooltip: getCommonTranslation('ADD'), //Add
        glyph: ICONGLYPH.ADDGLYPH
    }, {
    	xtype : 'button',				
		itemId : 'btnDeleteWorkTimingConfiguration',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),//Delete
		glyph: ICONGLYPH.DELETEGLYPH,
		disabled: true
	}],

    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.calendar.WorkTimeSlotStore');
    }
});*/
