/**
 * @author Harshit patidar
 * 
 */
Ext.define('Academia.view.committee.committee.StudentApplyForCommitteeFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.studentapplyforcommitteefilter',
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	layout: 'vbox',
	method: 'POST',
	standardSubmit: false,
	plugins:"formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('REQUEST_ID'),
			name : 'request',
			itemId : 'requestId',
			displayField:'value',
			valueField:'id',
			width:226,
			editable: false,
			forceSelection:true,
			store: 'committee.committee.CommitteeRequestIdStore',
		},{
			xtype: 'customcombobox',
			name: 'requestStatus',
			itemId:'requestStatusId',
			store:'common.ApplyForCommitteeStatusComboStore',
			displayField:'name',
			valueField:'id',
			forceSelection:true,
			editable:false,
			typeAhead:true,
			fieldLabel:getCommonTranslation('REQUEST_STATUS'),
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('COMMITTEE_NAME'),
			name : 'committee',
			itemId : 'committeeItemId',
			displayField:'value',
			valueField:'id',
			width:226,
			editable: false,
			forceSelection:true,
			store:'committee.committee.StudentApplyForCommitteeStore',
		},
		]
	},{
        xtype: 'fieldcontainer',
        width: '100%',
        layout: 'hbox',
        defaults: {
            width: 226,
            labelAlign: 'top'
        },
        items: [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('MEMBERSHIP_TYPE'),
			name : 'membershipType',
			itemId : 'membershipTypeId',
			displayField:'value',
			valueField:'id',
			width:226,
			editable: false,
			forceSelection:true,
			disabled:true,
			store:'committee.committee.MembershipTypeByCommitteeStore',
		},{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('FROM_DATE'),
            name: 'startDate',
            itemId :'startDate',
            vtype: 'daterange',
			endDateField: 'endDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
        },{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('TO_DATE'),
            name: 'endDate',
            itemId: 'endDate',
            vtype: 'daterange',
			startDateField: 'startDate',
            listeners: {
        	  render: function(field) {
        		  return dateFormatRender(field);
        	  }
          }
        },
         ]
    	},{
		xtype: 'fieldcontainer',
		width: 'auto',

		items: [{
			xtype: 'button',
			text: getCommonTranslation("SEARCH"),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]
	}]

});
