var completionCheckListStore = Ext.create('Academia.store.completion.completionform.CompletionCheckListDataStore');
var completionCertificateListStore = Ext.create('Academia.store.completion.completionform.CompletionCertificateDataStore');
Ext.define('Academia.view.completion.completionlist.CompletionDetailWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.completiondetailwindow',
	modal : true,
	resizable: true,
	overflowX: 'hidden',
	overflowY: 'auto',
	frame: true,
    height: 250,
	width: '43%',
	title: getCommonTranslation('COMPLETION'),
	layout: 'vbox',
	defaults: {
		width: '100%'
	},
	items:[{
		xtype:'grid',
	    border: true,
	    refreshStoreData:true,
	    autoScroll: true,
		itemId:'completionCheckListDetailGrid',
	    store: completionCheckListStore,
		dockedItems: [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [ {
				xtype : 'custompagingtoolbar',
				plugins:['pagesize'],
				store : completionCheckListStore,
				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
				displayInfo : true
			} ]
		}],
	    columns: [{
	        header: getCompletionModuleTranslation('CHECKLIST_ITEMS'),
	        dataIndex: 'value',
	        flex: 1,
	        sortable: true
	    }, {
	        header: getCommonTranslation('Status'),
	        dataIndex: 'code',
	        flex: 1,
	        sortable: true,
	        renderer : function(value){
	        	if(value === 'true'){
	        		return  getCompletionModuleTranslation('COMPLETED');
	        	}else {
	        		return  getCompletionModuleTranslation('PENDING');
	        	}
	        }
	    }]
	},{
		xtype:'grid',
	    border: true,
	    refreshStoreData:true,
	    autoScroll: true,
		itemId:'completionCertificateDetailGrid',
	    store: completionCertificateListStore,
		dockedItems: [{
			xtype : 'toolbar',
			dock : 'bottom',
			items : [ {
				xtype : 'custompagingtoolbar',
				plugins:['pagesize'],
				store : completionCertificateListStore,
				emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
				displayInfo : true
			} ]
		}],
	    columns: [{
	        header: getCompletionModuleTranslation('CERTIFICATE'),
	        dataIndex: 'certificate',
	        flex: 1,
	        sortable: true
	    }, {
	        header: getCommonTranslation('Status'),
	        dataIndex: 'status',
	        flex: 1,
	        sortable: true,
	        renderer : function(value){
	        	if(value === 'PENDING'){
	        		return  getCompletionModuleTranslation('PENDING');
	        	}else if(value === 'IN_PROGRESS'){
	        		return  getCompletionModuleTranslation('IN_PROGRESS');
	        	}else if (value === 'COMPLETED'){
	        		return  getCompletionModuleTranslation('COMPLETED');
	        	}
	        }
	    }]
	},{
		xtype:'completiondetailwindowform',
		itemId : "markCompletionComplete",
	}]
});