/**
 * @author pritam.patil
 *  PassingOut Panel with passing out quick search form & search result grid
 */
Ext.define('Academia.view.completion.completionlist.PassingOutGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.passingoutgrid',
	store : 'completion.completionform.PassingOutGridStore',
	title : getProgramandcourseTranslation('PASSING_OUT_GRID'),
	border: true,
	isGridConfigurable: true,
	enableColumnHide: false,
	refreshStoreData:true,
	deferEmptyText: false,
	selType:'checkboxmodel',
	headerFix: {
		headerFix: true,
		portalIdsWithStructure: {
			'passingoutpanel': 1
		}
	},
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		itemId:'dockedItemsItemId',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'completion.completionform.PassingOutGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'updateButtonId',
		text: getCompletionModuleTranslation('UPDATE')
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCourseTxCommonTranslation('MOREACTIONS'),
		menu:[{
			text:getProgramandcourseTranslation('CHECK_ELIGIBILITY'),
			itemId:'checkEligibilityButtonId'
		},{
			text:getProgramandcourseTranslation('MARK_COMPLETE'),
			itemId:'markCompleteButtonId'
		},{
			text:getProgramandcourseTranslation('PRINT_CERTIFICATE'),
			itemId:'printCertificateButtonId'
		},{
			text:getProgramandcourseTranslation('EMAIL_CERTIFICATE'),
			itemId:'emailCertificateButtonId'
		}]
	},{
		xtype: 'button',
		itemId: 'certificateBtnId',
		text: getExaminationTranslation('PRINT_GRADUATION_CERTIFICATE')
	},{
		xtype: 'button',
		itemId: 'publishGraduationCertificate',
		text: getCommonTranslation('PUBLISH_GRADUATION_CERTIFICATE'),
		disabled:true
	},{
		xtype: 'button',
		itemId: 'rejectBtnId',
		disabled:true,
		text: getExaminationTranslation('REJECT')
	}],
	columns : [{
		header :getProgramandcourseTranslation('ADMISSION_CODE'),
		dataIndex : 'admissionCode',
		flex : 1,
		sortable : true
	},{
		header :getProgramandcourseTranslation('STUDENT_CODE'),
		dataIndex : 'studentCodeStr',
		flex : 1,
		sortable : true
	}, {
		header : getProgramandcourseTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex : 2,
		sortable : true
	}, {
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'studentLastName',
		flex : 2,
		sortable : true
	}, {
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex : 2,
		sortable : true
	},{
		header : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'sectionName',
		flex : 1,
		sortable : true
	},{
		header : getCommonTranslation('PPROGRAM_COORDINATOR'),
		dataIndex : 'coordinatorName',
		flex : 1,
		sortable : true
	},{
		header : getProgramandcourseTranslation('EFFECTIVE_PASSOUT_DATE'),
		dataIndex : 'effectionTransferDate',
		sortable : true,
		flex : 1
	},{
		header : getCommonTranslation('EFFECTIVE_PASSOUT_COMMUNICATION_DATE'),
		dataIndex : 'effectivePassoutCommunicationDate',
		sortable : true,
		flex : 2
	},{
		header : getProgramandcourseTranslation('DECISION_NUMBER'),
		dataIndex : 'decisionNumber',
		sortable : true,
		hidden:true,
		flex : 1
	},{
		header : getProgramandcourseTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		sortable : true,
		renderer: function(value) {
			return getCompletionModuleTranslation(value);
		}
	},{
		header : getProgramandcourseTranslation('ELIGIBILITY'),
		dataIndex : 'passoutEligibility',
		flex : 1,
		sortable : true,
		renderer: function(value) {
			if(isNullOrEmpty(value)){
				return "";
			} else if (!isNullOrEmpty(value) && (value == "true" || value)) {
				return "<span style=\'color:green\'>Yes</span>"
			} else {
				return "<span style=\'color:red\'>No</span>"
			}
		}
	},{
		header : getProgramandcourseTranslation('FEE_DUES'),
		dataIndex : 'feeDues',
		flex : 1,
		sortable : true,
		renderer: function(value) {
			value="<a href='#'>View</a>"; 
			return value;
		}
	},
	{
		header : getExaminationTranslation('REJECT_APPROVER_NAME'),
		dataIndex : 'rejectedById',
		flex : 1,
		sortable : true,
				
	},
	{
		header : getProgramandcourseTranslation('CERTIFICATES'),
		dataIndex : 'certificate',
		flex : 1,
		sortable : true,
		renderer:function(value){
			if(value!=null && value > 0){
				return '<a  href="#">'+value+'</a>';
			}else{
				return '';
			}
		}
	},{
		header : getProgramandcourseTranslation('CHECKLIST'),
		dataIndex : 'checkList',
		flex : 1,
		sortable : true,
		renderer:function(value){
			if(value!=null && value >0){
				return '<a  href="#">'+value+'</a>';
			}else{
				return '';
			}
		}
	},
	{
		header : getExaminationTranslation('REJECT_REMARK'),
		dataIndex : 'rejectedRemark',
		flex : 1,
		sortable : true,
		hidden: true,
		
	}]
});