/**
 * Grid to display the completion checklist on the manage completion checklist tab.
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.completion.setup.CompletionChecklistGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.completionchecklistgrid',
	border: true,
	margin:'25 0 0 0',
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	store : 'Academia.store.completion.setup.CompletionChecklists',
	title:'Manage Completion Checklist',
	columns : [ /*{
		dataIndex : 'transactionTypeId',
		hidden: true
	}, {
		dataIndex : 'completionChecklistId',
		hidden: true
	}, */{
		text : getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		sortable : true,
		flex: 1
	}, {
		text : getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		sortable : true,
		flex: 1
	}, {
		text : getCommonTranslation('SEAT_TYPE'),
		dataIndex : 'seatTypeName',
		sortable : true,
		flex: 1
	}, {
		text : getCompletionModuleTranslation('TRANSACTION_TYPE'),
		dataIndex : 'transactionTypeTranslation',
		sortable : true,
		flex: 1
	}, {
		xtype: 'templatecolumn',
		text : getCompletionModuleTranslation('CHECKLIST'),
		itemId: 'checklistItemCount',
		dataIndex: 'checklistItemCount',
		tpl: '<a>{checklistItemCount}</a>',
		renderer: function(value) {
			 if(isNullOrEmpty(value)) {
				 value = "";
			 } else if (value == 0) {
				 return value;
			 } else {
				 value="<a href='#'>"+value+"</a>"; 
			 }
             return value;
        },
		sortable : true,
		flex: 1
	}, {
		xtype: 'templatecolumn',
		text : getCompletionModuleTranslation('CERTIFICATE'),
		itemId: 'certificateCount',
		dataIndex: 'certificateCount',
		tpl: '<a>{certificateCount}</a>',
		renderer: function(value) {
			 if(isNullOrEmpty(value)) {
				 value = "";
			 } else if (value == 0) {
				 return value;
			 } else {
				 value="<a href='#'>"+value+"</a>"; 
			 }
             return value;
        },
		sortable : true,
		flex: 1
	}],
	dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true,
            store : 'Academia.store.completion.setup.CompletionChecklists'
        }]
    }],
    tbar : [{
    	xtype: 'splitbutton',			
		itemId : 'mapChecklistItems',
		text : getCompletionModuleTranslation('ADD'),
		tooltip : getCompletionModuleTranslation('ADD'),
		menu: [{
	            text: getCompletionModuleTranslation('CHECKLIST_ITEMS'),
	            itemId: 'add_checklist'
	        }, {
	            text: getCompletionModuleTranslation('CERTIFICATES'),
	            itemId: 'add_certificates'
	        }]
	},{
		xtype: 'splitbutton',			
		itemId : 'mapCertificateItems',
		text : getCompletionModuleTranslation('EDIT'),
		tooltip : getCompletionModuleTranslation('EDIT'),
		menu: [{
	            text: getCompletionModuleTranslation('CHECKLIST_ITEMS'),
	            itemId: 'edit_checklist'
	        }, {
	            text: getCompletionModuleTranslation('CERTIFICATES'),
	            itemId: 'edit_certificates'
	        } ]
	},{
			xtype: 'button',			
			itemId : 'deleteTransactionType',
			cls: 'CustomToolbarBtnReject',
			tooltip : getCommonTranslation('DELETE'),
			glyph: ICONGLYPH.DELETEGLYPH
	}]
});