/**
 * Ankur Jaiswal
 */
Ext.define('Academia.view.configureloader.ConfigureLoaderGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.configureloadergrid',
    store: 'configureloader.ConfigureLoaderGridStore',
    title: getCommonTranslation('CONFIGURE_LOADER'),
    border: true,
    autoScroll: false,
    selType: 'checkboxmodel',
    multiSelect: true,
    refreshStoreData:true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'configureloaderstructure':1
        },
    },
    selModel: {
        mode: 'multi',
        showHeaderCheckbox: true,
        allowDeselect: false,
        checkOnly: true,
    },
    tbar: [{
        xtype: 'button',
        itemId: 'saveBtnItemId',
        text: getCommonTranslation('SAVE')
    }],
    columns: [{
        header: getCommonTranslation('DEFAULT_NAME'),
        dataIndex: 'defaultHeaderLabel',
        flex: 1
    }, {
        header: getCommonTranslation('NEW_NAME'),
        dataIndex: 'headerLabel',
        flex: 1,
        editor: {
            xtype: 'textfield',
            itemId: 'newNameId',
            name: 'newName',
            maxLength: 70,
        }
    }, {
        header: getCommonTranslation('TYPE'),
        dataIndex: 'isMandatory',
        hidden : false,
        flex: 1,
        editor: {
            xtype: 'customcombobox',
            name: 'type',
            store: 'configureloader.CLMandatoryOptionalStore',
            valueField: 'name',
            displayField: 'value',
            editable: false,
            listeners:{
            	select: function(obj, record){
            		var rec = obj.up('grid').getSelectionModel().getSelection()[0];
            		var isVisible = rec.get('isVisible');
            		var val = record[0].get('value');
            		if((val == "Mandatory" || val == "MANDATORY") && isVisible == "No"){
            			obj.setValue('Optional');
            			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('VISIBILITY_OF_MANDATORY_FIELD_MSG'));
            			return false;
            		}
            	}
            }
        }
    }, {
        header: getCommonTranslation('CL_LOADER_FIELD_VISIBILITY'),
        dataIndex: 'isVisible',
        hidden : false,
        flex: 1,
        editor: {
            xtype: 'customcombobox',
            name: 'fieldVisibility',
            store: 'common.YesNoDynamicFormCombo',
            valueField: 'name',
            displayField: 'value',
            editable: false,
            listeners:{
            	select: function(obj, record){
            		var rec = obj.up('grid').getSelectionModel().getSelection()[0];
            		var isMandatory = rec.get('isMandatory');
            		var val = record[0].get('value');
            		if((isMandatory == "Mandatory" || isMandatory == "MANDATORY") && val == "No"){
            			obj.setValue('Yes');
            			showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('VISIBILITY_OF_MANDATORY_FIELD_MSG'));
            			return false;
            		}
            	}
            }
        },
    }, {
        header: getCommonTranslation('DEF_VALUE'),
        dataIndex: 'defaultValue',
        hidden : true,
        flex: 1,
        editor: {
            xtype: 'textfield',
            itemId: 'defaultValueId',
            name: 'defaultValue',
        }
    }],
    plugins:[{
    	ptype : 'cellediting',
    	clicksToEdit: 1,
    	listeners:{
    		edit:function(editor, context){
    			context.column.field.setValue('true');
    		},
    		beforeedit: function(editor, context){
    			var rowData = context.record.data;
    			if (context.field == 'isMandatory' || context.field == 'isVisible') {
    				if (context.record.raw.isNonEditable) {
    					return false;
    				}
    			}
    			if (context.field == 'defaultValue') {
    				if (context.record.raw.isNonEditable) {
    					return false;
    				}
    				return true; 
    			}
    		}         
    	}
    }]
});