/**
 * @author seshagiri.k
 */
Ext.define('Academia.view.course.coursegroup.assigncourses.AssignCoursesStructureGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.assignCoursesStructureGrid',
    store: 'course.coursegroup.AssignCoursesStructureStore',
    title: getCommonTranslation('LIST_OF_ASSIGN_COURSES'),
//	translationKey: 'LIST_OF_ASSIGN_COURSES',
    border: false,
    autoScroll: false,
    frame:false,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            store: 'course.coursegroup.AssignCoursesStructureStore',
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('COURSE_CODE'),
        dataIndex: 'courseCode',
        sortable:true,
        flex:1
    },{
        header: getCommonTranslation('COURSE_NAME'),
        dataIndex: 'courseName',
        sortable:true,
        flex:1
    }, {
        header: getCommonTranslation('OPTIONAL_OR_MANDATORY'),
        dataIndex: 'whetherMandatory',
        sortable: true,
        flex:1,
        renderer:function(v){
        	if(v){
        return getCommonTranslation('MANDATORY');
        	}else{
        return getCommonTranslation('OPTIONAL');
        	}
        		
        }
        
    }, {
    	header: getCommonTranslation('CREDITS_ASSOCIATED'),
        dataIndex: 'courseCredits',
        sortable:true,
        flex:1
    },{
    	header: getCommonTranslation('COURSE_CLUSTER_ID'),
        dataIndex: 'courseClusterId',
        sortable:true,
        hidden:true,
        flex:1
    },{
        header: getCommonTranslation('WHETHER_MAJOR'),
        dataIndex: 'whetherMajor',
        sortable: true,
        hidden:true,
        flex:1,
        renderer:function(v){
        	if(v){
        return getCommonTranslation('YES');
        	}else{
        return getCommonTranslation('NO');
        	}
        		
        }
        
    }]
});