
Ext.define('Academia.view.course.topic.ManageCourseTopicView', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.managecoursetopicview',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	layout : {
		type: 'anchor',
		layout: 'hbox'
	},
	standardSubmit : false,
	defaults: {
		labelAlign:'top',
		width:226
	},
	plugins : "formlabelrequired",
	bodyStyle:{ margin:CONSTANTS.LEFT_MARGIN_FOR_SEARCH_PANEL},
	items: [{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width:226
		},
		items:[{
			xtype : 'customcombobox',
			name : 'courseDepartment',
			itemId : 'courseDepartmentId',
			fieldLabel : getCommonTranslation('COURSE_DEPARTMENT'),
			store:Ext.create('Academia.store.course.AccessibleCourseDepartmentStore'),
			valueField : 'id',
			displayField : 'value',
			minChars:3,
			forceSelection:true,
			style:{
				marginLeft:'05px'
			},
			queryParam:'name',
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name:'course',
			itemId: 'courseId',
			width:460,
			store:Ext.create('Academia.store.course.AccessibleChildCourseStore'),
			displayField: 'valueCode',
			valueField: 'id',
			fieldLabel:getCommonTranslation('COURSE_CODE_NAME'),
			allowBlank:false,
			minChars:3,
			forceSelection:true,
			style:{
				marginLeft:'05px'
			},
			queryParam:'courseName',
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{	
		xtype:'fieldcontainer',
		width: '100%',
		 
		items:[{  
			xtype: 'button',
			itemId: 'searchBtn',
			formBind:true,
			text: getCourseTxCommonTranslation('SEARCH'),
			ui:'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			disabled : true
	     },{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCourseTxCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});