/**
 * By Utsav
 */
var topicGridStore = Ext.create('Academia.store.course.coursetopic.CourseTopicStore');
Ext.define('Academia.view.course.topic.TopicGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.topicgrid',
	store : topicGridStore,
	border: true,
	title: getCommonTranslation('COURSE_TOPICS_LIST'),
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			itemId : 'custompagingtoolbarId',
			plugins:['pagesize'],
			store : topicGridStore,
			emptyMsg :getCourseTxCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},
	tbar : [ {
		xtype : 'button',
		itemId : 'btnAdd',
		tooltip : getCommonTranslation('ADD'),
		disabled : true,
		glyph : ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH	
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		text:getProgramandcourseTranslation('UPLOAD_DOCUMENT'),
		itemId:'topicUploadDocument',
		tooltip :getProgramandcourseTranslation('UPLOAD_DOCUMENT'),
	}],
	columns : [{
		header : getCommonTranslation('TOPIC_SEQUENCE'),
		dataIndex : 'topicSequence',
		flex : 0.1
	},{
		header : getCommonTranslation('TOPIC_NAME'),
		dataIndex : 'topicName',
		flex : 0.2
	},{
		header : getCommonTranslation('TOPIC_DESCRIPTION'),
		dataIndex : 'topicDescription',
		flex : 0.3,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
	    		return "";
	    	} else {
	    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 43px;min-width: 30ch;max-width: 103ch;';
	    		return val;
    		}
		}

	}, {
		header : getCommonTranslation('NO_OF_SESSIONS'),
		dataIndex : 'noOfSessions',
		flex : 0.1,
		hidden : true
	},{
		header : getCommonTranslation('MINUTES'),
		dataIndex : 'topicMinutes',
		flex : 0.1,
		hidden : true
	}, 
	/*{
		header : getCommonTranslation('COMPONENT'),
		dataIndex : 'courseComponent',
		flex : 0.2,
		renderer : function(value){
			if(value!=null){
				return value.value;
			}else{
				return value;
			}
		}

	}, {
		header : getCommonTranslation('TOPIC_DEPTH'),
		dataIndex : 'topicDepth',
		flex : 0.1,
		renderer : function(value){
			return value.value;
		}
	},{
		header : getCommonTranslation('COMPULSORY_OPTIONAL'),
		dataIndex : 'whetherCompulsory',
		flex : 0.2,
		renderer : function(value){
			if(value){
				return getCommonTranslation('COMPULSORY');
			}else{
				return getCommonTranslation('OPTIONAL');
			}
		}
	},
	 */ {
		header : getProgramandcourseTranslation('NO_OF_DOCUMENT'),
		dataIndex : 'noOfDocuments',
		flex : 0.1,
		renderer: function (value) {
			if(value>0){
				return '<a href="#">'+value+'</a>';
			}else{
				return "0";
			}
		}
	}]

});
