/**
 * 
 */
Ext.require([
    'Ext.ux.form.MultiSelect'
]);

Ext.define('Academia.view.coursetransaction.coursereading.AssingCourseForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.assingcourseform',
    modal: true,
    autoScroll:true,
    //resizable:true,
    title: getExaminationTranslation("MAP_CV"),
    maxHeight:600,
    //width: '70%',
    //margin:0,
    items: [{
        xtype: 'form',
        id: 'assingCourseForm_Id',
        method: 'POST',
        autoScroll:true,
        margin: 0,
        bodyPadding: '10 10 10 10',
        layout: {
            type: 'vbox'
        },
        layout: 'anchor',
        defaults: {
        	  labelAlign: 'top',
        	  width: 226,
            anchor: '100%'
        },
        standardSubmit: false,
        plugins:"formlabelrequired",
        items: [{  
        	    xtype: 'hidden',
                name: 'id'
            },{
        		xtype: 'multiselectcombofield',
        		width: 460,
        		//height: 'auto',
        		name: 'multiselectAcademyLocation',
        		cls: 'multiselectAcademyLocation',
        		itemId: 'multiselectAcademyLocationId',
        		allowBlank : false,
        		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
//        		translationKey: 'ACADEMY_LOCATION',
        		store:'common.AcademyLocationNameSeparated',
        		displayField:'value',
        		valueField:'id',
        		matchFieldWidth:true,
        		queryMode:'local',
        		listConfig: {
        			listeners: {
        				beforeshow: function(picker) {
        					picker.width = picker.up('combobox').getSize().width;
        				}
        			},
        			loadingText: getCommonTranslation('SEARCHING'),
        			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        			getInnerTpl: function() {
        				return '<div class="search-item">' +
        				'{code}' +
        				'</div>';
        			}
        		}
        	},{
				xtype: 'multiselectcombofield',
				name: 'multiCourseVariant',
				itemId: 'multiCourseVariantId',
				width: 460,
				fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
				store:'coursetransaction.coursereading.AssignCourseMultiSelect',
				displayField:'code',
				valueField:'id',
				typeAhead:true,
				forceSelection:true,
				allowBlank:false,
				listConfig: {
        			listeners: {
        				beforeshow: function(picker) {
        					picker.width = picker.up('combobox').getSize().width;
        				}
        			},
        			loadingText: getCommonTranslation('SEARCHING'),
        			emptyText: getCommonTranslation('NO_RECORDS_FOUND')
        		}
				
			}
            /*{
                xtype: 'multiselect',
                fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
                name: 'multiCourseVariant',
                id:'multiCourseVariant_Id',
                autoScroll:true,
                maxHeight:200,
                store:'coursetransaction.coursereading.AssignCourseMultiSelect' ,
                valueField:'id',
                displayField:'code',
                queryMode: 'local',
                maxHeight :'200', 
                typeAhead: true,
                editable: true,
                allowBlank:false
            }*/
            ,{
            layout: {
                type: 'hbox'
            },
            style:{
            	marginLeft:'0px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'assingCourseSubmit',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'assingCourseCancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});