
Ext.define('Academia.view.coursetransaction.homework.assignmentDetails.AssignDetailsAllGrid', {
    extend : 'Ext.grid.Panel',
    alias : 'widget.assigndetailsallgrid',
    store : 'coursetransaction.homework.assignmentdetails.AssignmentDetailGridStore',
    border: true,
    maxHeight: 400,
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'uploadDocument',
		text : getCommonTranslation('UPLOAD_DOCUMENT')
	}],
	columns : [{
		xtype: 'rownumberer',
		header: getCommonTranslation('SNO'),
		align :'left',
		flex:.5
	}, {
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	}, {
		header : getCourseTxCommonTranslation('HW_ADMISSION_ID'),
		dataIndex : 'admissionCode',
		flex:1,
		sortable : true
	}, {
		header : getCourseTxCommonTranslation('HW_STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1,
		sortable : true
	},{
		header : getCommonTranslation('FIRST_NAME'),
		dataIndex : 'firstName',
		flex : 1,
		hidden :true
	}, {
		header : getCommonTranslation('MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex : 1,
		hidden :true
	}, {
		header : getCommonTranslation('LAST_NAME'),
		dataIndex : 'lastName',
		flex : 1,
		hidden :true
	}, {
		header : getCourseTxCommonTranslation('HW_PROGRAM'),
		dataIndex : 'programName',
		flex:1,
		sortable : true,
	    hidden:true
	}, {
		header : getCourseTxCommonTranslation('HW_BATCH'),
		dataIndex : 'batchName',
		flex:1,
		sortable : true,
	    hidden:true
	}, {
		header : getCourseTxCommonTranslation('HW_PERIOD'),
		dataIndex : 'periodName',
		flex:1,
		sortable : true,
	    hidden:true
	}, {
		header : getProgramandcourseTranslation('DEENROLLED_AFTER_ENROLLMENT'),
		dataIndex : 'isWithDrawn',
		flex:1,
		sortable : true,
		hidden:true,
		renderer: function (value,rec) {
			if(rec.record.data.isWithDrawn){
				return 'No';
			}else{
				return 'Yes';
			}
		}
	}, {
		header : getCourseTxCommonTranslation('HW_FILE_NAME'),
		dataIndex : 'documentName',
		flex:1,
		sortable : true,
		renderer: function (value,rec) {
			if(rec.record.data.documentId !=undefined){
				return '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}]
});
