var myNewModel = Ext.define('MyNewModel', {
	extend : 'Ext.data.Model',
	fields : [ 'id','value','code','sequence','displayOtherLanguage','periodYear','name',{
		name: 'myId',
		convert : function (v, rec) {
           return randomString(10);
        }
	}],
	idProperty: 'myId'
});
var StudentPortalProgramPeriodEnrollGridStore = Ext.create('Academia.store.coursetransaction.manageperiodenrollment.StudentPortalProgramPeriodEnrollGridStore');
Ext.define('Academia.view.coursetransaction.manageperiodenrollment.ManageStudentEnrollmentList', {
	extend : 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managestudentenrollmentlist',
	store : StudentPortalProgramPeriodEnrollGridStore,
	title : getCommonTranslation('LIST_OF_PROGRAMS_PERIOD'),
	border : true,
	frame : false,
	//selType : 'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'managestudentenrollmentstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins : [ 'pagesize' ],
			store : StudentPortalProgramPeriodEnrollGridStore,
			emptyMsg : getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	} ],
	initComponent : function() {
		var grid = this;
		// grid.addExportToolBarItems(grid);
		this.callParent(arguments);
	},listeners:{
	 	beforeselect:function(selModel,record,index){
			if(!isNullOrEmpty(selModel.view.up())){
				var gridItemId = selModel.view.up().getItemId();
	    			if(!isNullOrEmpty(record.get('status')) && record.get('status') == "Pending"){
	    				return true;
	    			}else{
	    				selModel.view.up().down('#save').setDisabled(true);
	    				selModel.view.up().down('#showStudentEnrollmentMessageId').setVisible(false);
	    				return false
	    			}
			}
		}         
	},
	tbar : [ {
		xtype : 'button',
		text : getCommonTranslation('ENROLL'),
		itemId : 'save',
		disabled:true
	},{
        xtype: 'button',
        text: getCommonTranslation('CHANGE_PAYMENT_TERM'),
        itemId: 'changePaymentTerm',
        disabled: true
    },{
        xtype: 'button',
        text: getCommonTranslation('PERIOD_DE_ENROLL'),
        itemId: 'periodDeEnroll',
        disabled: true
    },{
		xtype:'displayfield',
		name : 'showStudentEnrollmentMessage',
		itemId : 'showStudentEnrollmentMessageId',
		//hidden:true
	} ],
	columns : [ {
		header : getCommonTranslation('PERIOD_NAME'),
		dataIndex : 'periodName',
		flex : 1
	},{ 
		header : getCommonTranslation('PAYMENT_GROUP'),
		dataIndex : 'paymentGroup',
		sortable: false,
		flex : 1.5,	  
		editor : {
			xtype: 'customcombobox',
			itemId: 'paymentGroup',
			name: 'paymentGroup',
			width: 135,
			labelAlign: 'top',
			store:Ext.create('Ext.data.ArrayStore',{
				model : 'MyNewModel'
			}),
			valueField: 'id',
			displayField: 'value',
		    forceSelection:true,
		    queryMode:'local',
		    listConfig: {
		    	listeners: {
		    		beforeshow: function(picker) {
		    			var combo = picker.up('combobox');
		    			var comboStore = combo.getStore();
		    			var grid = combo.up('grid');
		    			if(!isNullOrEmpty(grid.getSelectionModel().getSelection()) && grid.getSelectionModel().getSelection().length){
		    				var record = grid.getSelectionModel().getSelection()[0];
			    			var periodId = record.data.periodId;
			    			comboStore.clearFilter();
			    			comboStore.loadData(allPaymentGroupDataForStudentPeriodEnroll);
			    			comboStore.filterBy(function(storeRecord, id){
								return (storeRecord.get('displayOtherLanguage') == periodId);
							});
		    			}
		    			
		    			picker.minWidth = picker.up('combobox').getSize().width;
		    		},
		    		emptyText: getCommonTranslation('NO_RECORDS_FOUND')

		    	},
		    }
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					var periodId = record.data.periodId;
					rec.column.getEditor().getStore().clearFilter();
					rec.column.getEditor().getStore().loadData(allPaymentGroupDataForStudentPeriodEnroll);
					rec.column.getEditor().getStore().filterBy(function(storeRecord, id){
						return (storeRecord.get('displayOtherLanguage') == periodId);
					});
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
					}else{
						rec.column.getEditor().getStore().getProxy().extraParams={
							admissionId:null,
							periodId:null
						}
						rec.column.getEditor().store.load();
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{ 
		header : getCommonTranslation('PAYMENT_TERM'),
		dataIndex : 'paymentTerm',
		sortable: false,
		flex : 1.5,  
		editor : {
			xtype: 'customcombobox',
			itemId: 'paymentTerm',
			name: 'paymentTerm',
			width: 135,
			labelAlign: 'top',
			//store:Ext.create('Academia.store.feeandpayment.FeePaymentTerm'),
			valueField: 'id',
			displayField: 'value',
		    forceSelection:true,
		    queryMode:'local',
		    store:Ext.create('Ext.data.ArrayStore',{
				model : 'MyNewModel'
			}),
			listConfig: {
		    	listeners: {
		    		beforeshow: function(picker) {
		    			var combo = picker.up('combobox');
		    			var comboStore = combo.getStore();
		    			var grid = combo.up('grid');
		    			if(!isNullOrEmpty(grid.getSelectionModel().getSelection()) && grid.getSelectionModel().getSelection().length){
		    				var record = grid.getSelectionModel().getSelection()[0];
			    			var periodId = record.data.periodId;
			    			comboStore.clearFilter();
			    			comboStore.loadData(allPaymentTermsDataForStudentPeriodEnroll);
			    			comboStore.filterBy(function(storeRecord, id){
								return (storeRecord.get('displayOtherLanguage') == periodId);
							});
		    			}
		    			
		    			picker.minWidth = picker.up('combobox').getSize().width;
		    		},
		    		emptyText: getCommonTranslation('NO_RECORDS_FOUND')

		    	}
		    }
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					var periodId = record.data.periodId;
					rec.column.getEditor().getStore().clearFilter();
					rec.column.getEditor().getStore().loadData(allPaymentTermsDataForStudentPeriodEnroll);
					rec.column.getEditor().getStore().filterBy(function(storeRecord, id){
						return (storeRecord.get('displayOtherLanguage') == periodId);
					});
					var index = rec.column.getEditor().store.findExact('id',value);
					if(index !== -1){
						return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
					}else{
						rec.column.getEditor().getStore().getProxy().extraParams={
							admissionId:null,
							periodId:null
						}
						rec.column.getEditor().store.load();
						rec.tdCls = 'gridInputCustomStyle';
						return getExaminationTranslation('CLICK_TO_ENTER');
					}
				}
				catch(e){
					return null;
				}
			}
			else {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		dataIndex : 'whetherAutoApproved',
		flex : 1,
		hidden:true
	}, {
		header : getProgramandcourseTranslation('PERIOD_START_DATE'),
		dataIndex : 'periodStart',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getProgramandcourseTranslation('PERIOD_END_DATE'),
		dataIndex : 'periodEnd',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getProgramandcourseTranslation('REGISTRATION_START_DATE'),
		dataIndex : 'registrationStartDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getProgramandcourseTranslation('REGISTRATION_END_DATE'),
		dataIndex : 'registrationEndDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getCommonTranslation('LAST_DATE_OF_ENROLLMENT'),
		dataIndex : 'enrollmentLastDate',
		flex : 1,
		renderer:function(date) {
			return dateRender(date);
		}
	}, {
		header : getProgramandcourseTranslation('PERIOD_ENROLLMENT_STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
        	if(value=='Enrolled') {
        		return '<span style="color:green">'+value+'</span>'
        	}else if(value=='Passed'){
        		return '<span style="color:green">'+value+'</span>'
        	}else if(value=='Pending'){
        		return '<span style="color:red">'+value+'</span>'
        	}else if(value=='Request Received'){
        		return '<span style="color:#D2691E">'+value+'</span>'
        	}else {
        		return value;
        	}
        } 
	},{
		header : getCommonTranslation('REGISTRATION_STATUS'),
		dataIndex : 'registrationStatus',
		flex:1,
		renderer:function(value,meta,record){
			if(!isNullOrEmpty(value)) {
				if(value=="Not Started"){
					return "<font color='red'>" + getCommonTranslation(value)+"</font>";
				}else if(value=="In Progress"){
					return "<font color='#D2691E'>" + getCommonTranslation(value)+"</font>";
				}else if(value=="Open"){
					return "<font color='green'>" +  getCommonTranslation(value)+"</font>";
				}else if(value=="Closed"){
					return "<font color='red'>" + getCommonTranslation(value)+"</font>";
				}else {
					return "-";
				}
			} 
		}
	}],
	plugins: {
		ptype : 'cellediting',
		clicksToEdit: 1
	},
	listeners: {
		beforeedit: function(editor, context) {
			if(editor.context.field == 'paymentGroup'){
				var admissionId = context.record.data.admissionId;
				var periodId = context.record.data.periodId;
				context.grid.columns[1].getEditor().getStore().clearFilter();
				context.grid.columns[1].getEditor().getStore().loadData(allPaymentGroupDataForStudentPeriodEnroll);
				context.grid.columns[1].getEditor().getStore().filterBy(function(storeRecord, id){
					return (storeRecord.get('displayOtherLanguage') == periodId);
				});
				if(context.record.data.promotionEnrollmentStatus == 'ENROLLED' || context.record.data.promotionEnrollmentStatus == 'Enrolled' ||context.record.data.promotionEnrollmentStatus=="Request Received" || context.record.data.status=="In Progress" || context.record.data.promotionEnrollmentStatus=="Passed" ||
						context.record.data.promotionEnrollmentStatus=="REQUEST_RECEIVED"){
					context.grid.columns[1].getEditor().setReadOnly(true);
					
				}else{
					context.grid.columns[1].getEditor().setReadOnly(false);
					context.grid.columns[1].getEditor().enable(true);
					
				}
			}
			if(editor.context.field == 'paymentTerm'){
				var admissionId = context.record.data.admissionId;
				var periodId = context.record.data.periodId;
				context.grid.columns[2].getEditor().getStore().clearFilter();
				context.grid.columns[2].getEditor().getStore().loadData(allPaymentTermsDataForStudentPeriodEnroll);
				context.grid.columns[2].getEditor().getStore().filterBy(function(storeRecord, id){
					return (storeRecord.get('displayOtherLanguage') == periodId);
				});
				if(context.record.data.promotionEnrollmentStatus=="Enrolled" || context.record.data.promotionEnrollmentStatus=="Request Received" || context.record.data.status=="In Progress" || context.record.data.promotionEnrollmentStatus=="Passed" ||
						context.record.data.promotionEnrollmentStatus=="ENROLLED" || context.record.data.promotionEnrollmentStatus=="REQUEST_RECEIVED"){
					context.grid.columns[2].getEditor().setReadOnly(true);
					context.grid.columns[2].getEditor().setValue(context.record.data.paymentTerm)
					
				}else{
					context.grid.columns[2].getEditor().setReadOnly(false);
					context.grid.columns[2].getEditor().enable(true);
					
				}
			}
		}
	}
});
