var ExtendedTimeTableCBSGridStore = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ExtendedTimeTableCBSGridStore');
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.ExtendedTimeTableCBSGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.extendedtimetablecbsgrid',
	store: ExtendedTimeTableCBSGridStore,
	title: getCommonTranslation('LIST_OF_TIME_TABLE_SESSIONS'),
	border: true,
	autoScroll: false,
	frame:false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},

	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'timetablestructure':1
		}
	},
	style: 'margin-top: 0px !important',
	isGridConfigurable: true,
	enableColumnHide: false,
	listeners:{
    	beforeselect:function(selModel,record,index){
    		if(!isNullOrEmpty(selModel.view.up())){
    			var gridItemId = selModel.view.up().getItemId();
        			if(record.get('studentCourseAttendanceId') > 0){
        				return false;
        			}
        		}
    	}         
    },

	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : ExtendedTimeTableCBSGridStore,
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid, false);
		this.callParent(arguments);     
	},
	 tbar: [{
	        xtype: 'button',
	        itemId: 'btnAdd',
	        tooltip: getCommonTranslation('ADD'),
	        glyph: ICONGLYPH.ADDGLYPH
	    }, {
	        xtype: 'button',
	        itemId: 'btnEdit',
	        tooltip: getCommonTranslation('EDIT'),
	        glyph: ICONGLYPH.EDITGLYPH
	    },  {
	        xtype: 'button',
	        itemId: 'btnDelete',
	        cls: 'CustomToolbarBtnReject',
	        tooltip: getCommonTranslation('DELETE'),
	        glyph: ICONGLYPH.DELETEGLYPH,
			disabled : true
	    },{
	    	xtype : 'splitbutton',
	  	    itemId:'spBtnMoreActions',
	  	    text : getCourseTxCommonTranslation('MOREACTIONS'),
	  	    menu:[{
      		    text:getCourseTxCommonTranslation('SUBSTITUTE_SESSION'),
      		    itemId:'substituteSessionId'
      	    },{
      		    text:getMegaMenuTranslation('TS_DASHBOARDS_RESOURCE_AVAILABILITY_REPORT'),
      		    itemId:'ResourceAvailabilityId'
      	    },{
      		    text:getMegaMenuTranslation('TS_DASHBOARDS_RESOURCE_UTILIZATION_REPORT'),
      		    itemId:'ResourceUtilizationId'
      	    },{
      		    text:getProgramandcourseTranslation('ASSIGN_FACULTY'),
      		    itemId:'assignFacultyId'
      	    },{
      		    text:getProgramandcourseTranslation('REMOVE_FACULTY'),
      		    itemId:'deleteFacultyId'
      	    }]
	    },{
	    	xtype: 'tbspacer',
	    	flex:1
	    },{
			xtype: 'button',
			text:getCommonTranslation('EXPORT_REPORT'),
			itemId:'exportReport',
			tooltip :getCommonTranslation('EXPORT_REPORT'),
			disabled:true
		}],
	columns: [{
		header:getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.175,
		sortable:true
	},{
		header:getCommonTranslation('SECTION'),
		dataIndex:'sectionName',
		flex:.1,
		sortable:true
	},{
		header:getProgramandcourseTranslation('TOPIC_DETAILS'),
		dataIndex: 'assignedTopicCount',
		flex:.05,
		sortable:true,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view) {
    		if(record.data.assignedTopicCount > 0){
    			value="<a href='#'>View</a>"; 
        		return value;
    		} else {
        		return '';
    		}
    	}
	},{
		header:getCommonTranslation('SESSION_NUMBER'),
		dataIndex:'sessionNumber',
		flex:.05,
		sortable:true
	},{
		header:getCommonTranslation('SESSION_DATE'),
		dataIndex:'sessionDate',
		flex:.075,
		sortable:true,
		renderer:function(date) {
			return dateFormatRender(date);
		}
	},{
		header:getProgramandcourseTranslation('SESSION_TIME'),
		dataIndex:'sessionTime',
		flex:.075,
		sortable:true
	},
	{
		header:getCommonTranslation('FACULTY_CODE_TIMETABLEPROGRAMBATCHGRID'),
		dataIndex:'facultyCode',
		flex:.1,
		sortable:true
	},
	{
		header:getCommonTranslation('FACULTY'),
		dataIndex: 'faculty',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
		    if(!isNullOrEmpty(val)){
		    rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
		    rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 4;-webkit-box-orient: vertical;line-height: 15px;max-height: 68px;min-width: 16ch;max-width: 17ch;';
		    }
		    return val;
		    }
	},
	{
		header:getCommonTranslation('FACULTY_DEPARTMENT'),
		dataIndex:'facultyDepartment',
		flex:.15,
		sortable:true
	},
	{
		header:getCommonTranslation('ROOM'),
		dataIndex: 'roomName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('OPTIONAL_MANDATORY'),
		dataIndex: 'OptionalMandatory',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('WHETHER_ATTENDANCE_ENTERED'),
		dataIndex: 'whetherAttendanceToBeEntered',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('WHETHER_ATTENDANCE_MARKED'),
		dataIndex: 'studentCourseAttendanceId',
		flex:.075,
		sortable:true,
		renderer: function(value) { 
        	if(value > 0){
				return "<span style=\'color:green\'>Yes</span>";
			} else {
				return "<span style=\'color:red\'>No</span>";
			}
        }
	},{
		header:getCommonTranslation('LAST_UPDATED_BY'),
		dataIndex: 'attendanceMarkedBy',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('LAST_UPDATED'),
		dataIndex: 'lastupdatedOn',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('WHETHER_EVENT_TRIGGER'),
		dataIndex: 'weatherEventTrigger',
		flex:.075,
		sortable:true,
		renderer: function(value) { 
        	if(value > 0){
				return "<span style=\'color:green\'>Yes</span>";
			} else {
				return "<span style=\'color:red\'>No</span>";
			}
        }
	},{
		header:getCommonTranslation('CREATED_BY'),
		dataIndex: 'timeTableCreatedBy',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('CREATED_DATE'),
		dataIndex: 'timeTableCreationDate',
		flex:.1,
		sortable:true,
		hidden:true,
		
	}]
});
