var pbsCancelledSession= Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ExtendedTimeTablePBSGridStore');
Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.ExtendedTimeTablePBSCancelledSessionGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.extendedtimetablepbscancelledsessiongrid',
	store: pbsCancelledSession,
	title: getCommonTranslation('LIST_OF_TIME_TABLE_SESSIONS'),
	border: true,
	autoScroll: false,
	frame:false,
	refreshStoreData:true,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'timetablestructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : pbsCancelledSession,
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	listeners:{
    	beforeselect:function(selModel,record,index){
    		// not select the row on basis of some condition
    		if(!isNullOrEmpty(selModel.view.up())){
    			var gridItemId = selModel.view.up().getItemId();
        			if(record.get('studentCourseAttendanceId') > 0){
        				return false;
        			}
    		}
    	}         
    },
	columns: [{
		header:  getCommonTranslation('SELECT_RESOURCE_PROGRAM'),
		dataIndex: 'programName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('BATCH') ,
		dataIndex: 'batchName',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('COURSE_NAME'),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('SECTION'),
		dataIndex:'sectionName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('TOPIC_DETAILS'),
		dataIndex: 'assignedTopicCount',
		flex:.1,
		sortable:true,
		renderer: function(val,rec,record,rowIndex,colIndex,store,view) {
    		if(record.data.assignedTopicCount > 0){
    			value="<a href='#'>View</a>"; 
        		return value;
    		} else {
        		return '';
    		}
    	}
	},{
		header:getCommonTranslation('SESSION_NUMBER'),
		dataIndex:'sessionNumber',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('SESSION_DATE'),
		dataIndex:'sessionDate',
		flex:.1,
		sortable:true,
		renderer:function(date) {
			return dateFormatRender(date);
		}
	},{
		header:getProgramandcourseTranslation('SESSION_TIME'),
		dataIndex:'sessionTime',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('FACULTY'),
		dataIndex: 'faculty',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('ROOM'),
		dataIndex: 'roomName',
		flex:.1,
		sortable:true
	},{
		header:getCommonTranslation('OPTIONAL_MANDATORY'),
		dataIndex: 'OptionalMandatory',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('WHETHER_ATTENDANCE_ENTERED'),
		dataIndex: 'whetherAttendanceToBeEntered',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('CANCELLATION_REASON'),
		dataIndex: 'reasonForSubstituteSession',
		flex:.1,
		sortable:true,
		renderer:function(val,rec,record,rowIndex,colIndex,store,view){
			if(isNullOrEmpty(val)){
	    		return "";
	    	} else {
	    		rec.tdAttr = 'data-qtip="' + Ext.htmlEncode(val) + '"';
	    		rec.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;min-width: 16ch;max-width: 17ch;';
	    		return val;
    		}
		}
	},{
		header:getCommonTranslation('LAST_UPDATED_BY'),
		dataIndex: 'attendanceMarkedBy',
		flex:.1,
		sortable:true,
		hidden:true
	},{
		header:getCommonTranslation('LAST_UPDATED'),
		dataIndex: 'attendanceMarkedAt',
		flex:.1,
		sortable:true,
		hidden:true
	},]
});
