/**
 * @author Angad.Yadav
 * 
 */
 Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.ImportExtendedTimeTableDownloadPanel', {
	extend : 'Ext.form.FormPanel',
	alias : 'widget.importExtendedTimeTableDownloadPanel',
	autoScroll:false,
	frame:false,
	cls: 'horizontalScrollingFixed',
	style: {
		margin: 0
	},
	defaults : {
		width : '100%'
	},
    plugins: "formlabelrequired",
	method : 'POST',
	standardSubmit : false,
	items : [{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTermExtendedTT',
			itemId : 'academicTermIdExtendedTT',
			displayField : 'value',
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			typeAhead : true,
			editable : false,
			allowBlank: false
		}, {
			xtype: 'customcombobox',
			name: 'batchExtendedTT',
			width:446,
			itemId: 'batchIdExtendedTT',
			fieldLabel: getProgramandcourseTranslation('PROGRAM_BATCH'),
			store: Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.ProgramBatchStoreForCBSSessionTopicMapping'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'programName',
			typeAhead : true,
			allowBlank:false,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			disabled:true,
			minChars:3,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PERIOD'),		
			name: 'periodIdExtendedTT',
			itemId:'periodIdExtendedTT',
			store: Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.mastertimetable.ParameterizedPeriodByBatch'),
			valueField: 'id',
			displayField: 'value',
			typeAhead : true,
			editable : false,
			disabled:true,
			allowBlank: true
		}]
	},{
		xtype: 'fieldcontainer',
		style:{
			marginTop:'20px !important'
		},
		items: [{
			xtype:'button',
			itemId:'importExtendedTTDownload',
			text:getCommonTranslation('DOWNLOAD_TEMPLATE'),
			ui: 'CustomBtnSubmit',
			style:{marginLeft:'0px !important'},
			formBind:true
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'importExtendedTTResetBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		}]	
	}]
});
