/**
 * Dharmendra.prajapati
 */
Ext.require([
    'Ext.ux.form.MultiSelect'
]);

Ext.define('Academia.view.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.UpdateCoverageDetail',{
	extend: 'Ext.window.Window',
	alias: 'widget.updatecoveragedetail',
	title:getCourseTxCommonTranslation('ADD_CVG_DETAILS'),
	modal:true,
	maxHeight:500,
	autoScroll:true,
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'updateCoverageDetails',
		margin: 0,
//		bodyPadding: '10 10 10 10',
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top'
//			 width:226
		},
		standardSubmit: false,
		plugins:"formlabelrequired",
		items: [{
			xtype: 'hidden',
			name: 'id'
		},{
			xtype: 'hidden',
			name: 'courseTopicId'
		},{
			xtype: 'hidden',
			name: 'batchId'
		},{
			xtype: 'hidden',
			name: 'periodId'
		},{
			xtype: 'hidden',
			name: 'courseId'
		},{
			xtype: 'hidden',
			name: 'sectionId'
		},{
			xtype: 'hidden',
			name: 'courseVariant'
		},{
			xtype: 'hidden',
			name: 'roomId'
		},{
			xtype: 'hidden',
			name: 'calendarEventId'
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				 labelAlign : 'top',
				 width:223
	       	 },
			items:[{
				xtype:'hidden',
				name : 'batch',
				fieldLabel: '<b>'+getCourseTxCommonTranslation('BATCH')+'</b>',
				//labelWidth:50,
				hidden:true
			},{
				xtype:'hidden',
				name : 'period',
				fieldLabel:'<b>'+ getCourseTxCommonTranslation('PERIOD')+'</b>',
				//labelWidth:50,
				hidden:true
			}]
		},	{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			 defaults : {
				 labelAlign : 'top',
				 width:223
	       	 },
			items:[{
				xtype:'displayfield',
				name : 'course',
				fieldLabel: '<b>'+getCommonTranslation('COURSE_CODE_NAME')+'</b>',
				//labelWidth:50,
				//hidden:false
			},{
				xtype:'displayfield',
				name : 'section',
				fieldLabel: '<b>'+getCourseTxCommonTranslation('SECTION')+'</b>',
				//labelWidth:50,
				//hidden:false
			}]
		},{
			 xtype : 'fieldcontainer',
	       	 layout : 'hbox',
	       	 defaults : {
	       		 labelAlign : 'top',
	       		 width:226
	       	 },
	       	 layout : {
	       		 type : 'hbox'
	       	 },
			 items:[
				{
				xtype: 'textfield',
				name: 'session',
				readOnly:true,
				itemId:'session_Id',
				fieldLabel: getProgramandcourseTranslation('SESSION_NO'),
				disabled:false
			 }, {
		        	xtype: 'datefield',
		        	itemId:'sessionDateId',
		        	name: 'sessionDate',
		        	fieldLabel: getCommonTranslation('SESSION_DATE'),
        	    	allowBlank : false,
					listeners: {
						render: function(obj) {
							obj = dateFormatRender(obj);
						}
					}
		        }]
		},{
			 xtype : 'fieldcontainer',
        	 layout : 'hbox',
        	 defaults : {
        		 labelAlign : 'top',
        		 width:226
        	 },
        	 layout : {
        		 type : 'hbox'
        	 },
			items:[]},{
			 xtype : 'fieldcontainer',
	       	 layout : 'hbox',
	       	 defaults : {
	       		 labelAlign : 'top',
	       			 width:226
	       	 },
	       	 layout : {
	       		 type : 'hbox'
	       	 },
			items:[{
				xtype : 'timefield',
				name : 'slotFrom',		
				itemId : 'slotFrom',			
				fieldLabel:getCourseTxCommonTranslation('CVG_TIME_FROM'),
				format:'g:i A',
				vtype: 'timerange',
				endTimeField : 'slotTo',
				allowBlank:false
			},{
				xtype : 'timefield',
				name : 'slotTo',
				itemId : 'slotTo',	
				fieldLabel : getCourseTxCommonTranslation('CVG_TIME_TO'),
				format:'g:i A',
				vtype: 'timerange',
				startTimeField : 'slotFrom',
				allowBlank:false
			}]
		},{
			 xtype : 'fieldcontainer',
	       	 layout : 'hbox',
	       	 defaults : {
	       		 labelAlign : 'top',
	       		 width:226
	       	 },
			items:[{
			xtype: 'customcombobox',
			name: 'classRoom',
			fieldLabel: getCourseTxCommonTranslation('CVG_ROOM'),
			itemId:'classRommId',
			store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.ClassRoomStore',
			//store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.NewClassRoomStore',
			displayField:'code',
			valueField:'id',
			queryMode:'local',
			typeAhead:true,
			allowBlank:false,
			forceSelection:true
		},{
			xtype: 'textfield',
			name: 'studentNum',
//			itemId:'studentNumId',
			readOnly:true,
			hidden:true,
			fieldLabel: getCourseTxCommonTranslation('NO_OF_STUDENT')
	    }]},
	  
		 {
			xtype: 'multiselectcombofield',
			name: 'courseTopic',
			itemId: 'newSessionTopic_Id',
			width: 460,
			//fieldLabel: getCourseTxCommonTranslation('CVG_TOPIC'),
			fieldLabel : getCommonTranslation('TOPICS'),
			store:Ext.create('Academia.store.coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.TopicByCourseId'),
			displayField:'value',
			valueField:'id',
			autoloadStore: false,
			typeAhead:true,
			allowBlank:true,
			forceSelection:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;

					},

				}
			}
		 },
		
		{
			xtype: 'multiselectcombofield',
			name: 'assignFaculty',
			itemId:'assignFacultyId',
			width: 460,
			fieldLabel: getCourseTxCommonTranslation('CVG_ASSIGN_FACULTY'),
			store:'coursetransaction.sectioncoursecoverageplan.coursecoverageplandetail.FacultyByTopicAndSection',
			displayField:'value',
			valueField:'id',
			queryMode:'local',
			allowBlank:false,
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			enableKeyEvents  : 'true',
			addAllSelector: false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = 'auto';
						setTimeout(function(){
							picker.el.dom.style.width='auto';
							picker.el.dom.style.minWidth = picker.up('combobox').getSize().width+'px';
						},10);
					},
					refresh: function( boundList, eOpts ){
						try{
							var combo = boundList.up('combo');
							var allItems = combo.listKeyNav.boundList.all.elements;
							var selectedDate = '';
							var comboStore = combo.getStore();
							if(typeof combo.getValue() != "string" && combo.getValue().length<6){
								Ext.each(allItems, function(currentItem){
									currentItem.classList.remove("disabledComboItem");
								});
							}
							else if(combo.getValue().length==6){
								var valueArray = [];
								Ext.each(combo.getValue(), function(currentValue){
									if(typeof currentValue=="object"){
										valueArray.push(currentValue.get('id'));
									}
									else{
										valueArray.push(currentValue);
									}
								});
								
								Ext.each(allItems, function(currentItem){
									var currentFacultyId = currentItem.viewRecordId;
									var currentFacultyRecord = comboStore.findRecord('id',currentFacultyId);
									if(valueArray.indexOf(currentFacultyRecord.get('id'))!="-1"){
										currentItem.classList.remove("disabledComboItem")
									}
									else{
										currentItem.classList.add("disabledComboItem");
									}
								});
								
							}
						}
						catch(e){}
					}
				}
			},
			listeners:{
				beforeselect:function(selModel,record,index){
					var combo = selModel.view.field;
					if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
						if(typeof combo.getValue()=="object" && combo.getValue().length==6){
							return false;
						}
					}
				},
				change: function(combo, newValue, oldValue, eOpt){
					var allItems = combo.listKeyNav.boundList.all.elements;
					var selectedDate = '';
					var comboStore = combo.getStore();
					if(typeof combo.getValue() != "string" && combo.getValue().length<6){
						Ext.each(allItems, function(currentItem){
							currentItem.classList.remove("disabledComboItem");
						});
					}
					else if(combo.getValue().length==6){
						var valueArray = [];
						Ext.each(combo.getValue(), function(currentValue){
							if(typeof currentValue=="object"){
								valueArray.push(currentValue.get('id'));
							}
							else{
								valueArray.push(currentValue);
							}
						});
						
						Ext.each(allItems, function(currentItem){
							var currentFacultyId = currentItem.viewRecordId;
							var currentFacultyRecord = comboStore.findRecord('id',currentFacultyId);
							if(valueArray.indexOf(currentFacultyRecord.get('id'))!="-1"){
								currentItem.classList.remove("disabledComboItem")
							}
							else{
								currentItem.classList.add("disabledComboItem");
							}
						});
						
					}
					
				}
			}
		},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			width:460,
			items:[{
			xtype: 'checkboxfield',
			width : 200,
            labelAlign: 'right',
            boxLabel: getCourseTxCommonTranslation('CVG_OPTIONAL_SESSION'),
            name: 'optionalSession',
            inputValue : true,
            uncheckedValue:false 
		},{
			xtype: 'checkboxfield',
			width : 260,
            labelAlign: 'right',
            boxLabel: getCourseTxCommonTranslation('CVG_SESSION_ATTENDANCE'),
            name: 'whetherAttendanceToBeEntered',
            inputValue : true,
            uncheckedValue: false,
            /*style:{
            	marginLeft:'100px'
            }*/
		}]},{
			xtype : 'fieldcontainer',
			layout : 'hbox',
			width:460,
			items:[{
			xtype: 'checkboxfield',
			width : 200,
            labelAlign: 'right',
            boxLabel: getCourseTxCommonTranslation('CVG_SESSION_PLANNED'),
            name: 'sessionPlanned',
            inputValue : true,
            uncheckedValue: false
		},{
			/*xtype:'displayfield',
		    width: 260,
		    labelAlign: 'left',
			name : 'sessionStatus',				
			labelAlign : 'top',
			fieldLabel: getCourseTxCommonTranslation('SESSION_STATUS'),
			value : getCourseTxCommonTranslation('HW_ACTIVE')*/
			
			
				xtype : 'fieldcontainer',
				layout : 'hbox',
				cls:'sessionStatus',
				items : [ {
					xtype : 'displayfield',
					name : 'sessionStatus',
					fieldLabel : getCourseTxCommonTranslation('SESSION_STATUS'),
					value : getCourseTxCommonTranslation('HW_ACTIVE')
				} ]
//		
	}]},
		/*]}
		]},*/
		{
			xtype:'fieldcontainer',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCourseTxCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCourseTxCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtn',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]     
});
