/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.sectionmanagement.CourseSectionGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.coursesectiongrid',
	store : 'coursetransaction.sectionmanagement.CoruseSectionGridStore',
	title: getCommonTranslation('LIST_OF_COURSE_SECTION'),
	border: true,
	viewConfig : {
		stripeRows :  CONSTANTS.STRIPEROWS
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.sectionmanagement.CoruseSectionGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    },{
    	xtype : 'splitbutton',
  	    itemId:'spBtnMoreActions',
  	    text : getCourseTxCommonTranslation('MOREACTIONS'),
  	    menu:[{
  		    text:getCourseTxCommonTranslation('VIEW_PAST_RECORD'),
  		    itemId:'viewPastRecordLink'
  	    }]
    }],
	columns: [/*{
		hidden : true,
		dataIndex : 'id'
	},*/{
		header : getCourseTxCommonTranslation('SECTION_NAME'),
		dataIndex : 'sectionCode',
		flex:1
	},{
		header : getCourseTxCommonTranslation('ALTERNATE_NAME'),
		dataIndex : 'alternateName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('RULE'),
		dataIndex : 'sectionRule',
		flex:1,
		hidden:true
	},{
		header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariant',
		flex:1
	},{
		header : getCourseTxCommonTranslation('HOME_ROOM'),
		dataIndex : 'homeRoom',
		flex:1
	},{
		header : getCommonTranslation('CALENDAR'),
		dataIndex : 'calendarName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('CAPACITY'),
		dataIndex : 'capacity',
		flex:1
	},{
		header : getProgramandcourseTranslation('ENROLLED_STUDENTS'),
		dataIndex : 'enrolled',
		flex:1,
		renderer:function(value){
			if(value!=null && value >0){
			  return '<a  href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},
	{
		header : getCommonTranslation('EXAM_DATE'),
		dataIndex : 'examDate',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('EXAM_START_TIME'),
		dataIndex : 'examStartTime',
		flex:1,
		hidden:true
	},{
		header : getCommonTranslation('EXAM_END_TIME'),
		dataIndex : 'examEndTime',
		flex:1,
		hidden:true
	}]
});