/**
 * @author Abhishek Chouhan
 */

 
Ext.define('Academia.view.coursetransaction.sectionmanagement.ManageCourseSectionStudentGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.managecoursesectionstudentgrid',
	store : 'coursetransaction.sectionmanagement.CourseSectionStudentStore',
	//id:'courseSection_editor',
	title: getProgramandcourseTranslation('ENROLLED_STUDENTS'),
	border: true,
	autoScroll: true,
	selType:'checkboxmodel',
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig : {
		stripeRows :  CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar: [{
		xtype: 'button',
		text:getCourseTxCommonTranslation('ASSIGN_SECTION'),
		itemId:'assignSectionforCourseLink',
		tooltip :getCourseTxCommonTranslation('ASSIGN_SECTION'),
		disabled:true
	}],
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.sectionmanagement.CourseSectionStudentStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [/*{
		hidden : true,
		dataIndex : 'id'
	},*/{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentId',
		flex:1
	},{
		header : getCourseTxCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex:1
	},{
		header : getCourseTxCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'firstName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'lastName',
		flex:1,
		hidden :true
	},{
		header : getCourseTxCommonTranslation('PROGRAM'),
		dataIndex : 'programCode',
		flex:1
	},{
		header : getCourseTxCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariantCode',
		flex:1	
	},{
		header : getCourseTxCommonTranslation('SECTION'),
		dataIndex : 'sectionCode',
		flex:1
	},{
		header : getProgramandcourseTranslation('DATE_OF_ENROLLMENT'),
		dataIndex : 'enrolledDate',
		flex:1,
		sortable:true,
		renderer:function(date) {
			return dateRender(date);
		}
	}]
	
});