/**
 * @author Rajkumar.patidar
 */
 
Ext.define('Academia.view.coursetransaction.sectionmanagement.ProgramBatchSectionStudentGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.programbatchsectionstudentgrid',
	requires:['Ext.selection.CellModel'],
	store : 'coursetransaction.sectionmanagement.ProgramBatchSectionStudentStore',
	selType:'checkboxmodel',
	isGridConfigurable: true,
	enableColumnHide: false,
	selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	viewConfig : {
		stripeRows :  CONSTANTS.STRIPEROWS
	},
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },
	tbar: [{
        xtype: 'button',
        itemId: 'assignSectionLink',
        text: getCourseTxCommonTranslation('ASSIGN_SECTION')
    },{
    	xtype: 'button',
        itemId: 'changeEnrollmentDateItemId',
        text:getProgramandcourseTranslation('CHANGE_ENROLLMENT_DATE')
    },{
    	xtype: 'displayfield',
        itemId: 'mesageItemId',
        hidden:true,
        value:getCourseTxCommonTranslation('ASSIGN_SECTION_BUTTON_MSG')
    }],
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.sectionmanagement.ProgramBatchSectionStudentStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns: [/*{
		hidden : true,
		dataIndex : 'id'
	},*/
	{
		header : getCommonTranslation('STUDENT_ID'),
		dataIndex : 'studentId',
		flex:1,
		renderer:function(value,meta,record){
			if(record.data.studentId == 0){
				return record.data.studentId ;
			} else {
				return '<a href=#>'+record.data.studentId +'</a>'
			}
		}
	},{
		header : getCommonTranslation('ADMISSION_ID'),
		dataIndex : 'admissionId',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_NAME'),
		dataIndex : 'studentName',
		flex:1
	},{
		header : getCommonTranslation('STUDENT_FIRST_NAME'),
		dataIndex : 'firstName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_MIDDLE_NAME'),
		dataIndex : 'middleName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('STUDENT_LAST_NAME'),
		dataIndex : 'lastName',
		flex:1,
		hidden :true
	},{
		header : getCommonTranslation('SECTION'),
		dataIndex : 'section',
		flex:1
			
	},
	{
		header : getCommonTranslation('EXAM_SCORE'),
		dataIndex : 'score',
		flex:1,
		hidden :true
			
	},{
		header : getCommonTranslation('DATE_OF_ENROLLMENT'),
		dataIndex : 'enrolledDate',
		flex:1,
		sortable:true,
		renderer:function(date,rec,e) {
			if(!isNullOrEmpty(e.data.section)){
				return dateRender(date);
			}else{
				return ' ';
			}
		}
	}]
});

