/**
 *  @author Rajkumar.patidar
 */
Ext.define('Academia.view.coursetransaction.studymaterialdistribution.CourseReadingGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.coursereadinggrid',
	store : 'coursetransaction.studymaterialdistribution.CourseReadingGrid',
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : false
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'coursetransaction.studymaterialdistribution.CourseReadingGrid',
			emptyMsg :getCourseTxCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCourseTxCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCourseTxCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCourseTxCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCourseTxCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
	columns: [{
		hidden : true,
		dataIndex : 'id'
	},{
		header : getCourseTxCommonTranslation('COURSE_VARIANT'),
		dataIndex : 'courseVariant',
		flex:0.3
	},{
		header : getCourseTxCommonTranslation('READING_TYPE'),
		dataIndex : 'readingType',
		flex:0.2
	},{
		header : getCourseTxCommonTranslation('READING_NAME'),
		dataIndex : 'readingName',
		flex: 1
		
	}]
});