/**
 * @author Rajkumar.Patidar
 */
Ext.define('Academia.view.coursetransaction.studymaterialdistribution.StudyMaterialSearchForStudent', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.studymaterialsearchforstudent',
    plugins: "formlabelrequired",
    frame: false,
	cls:'customSearchPanel',
    layout: 'vbox',
    method: 'POST',
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: 226
    },
    items: [{
    	 xtype: 'fieldcontainer',
         width: '100%',
         layout: 'hbox',
         defaults: {
             labelAlign: 'top',
             width: 226
         },
         items: [{
        	 xtype: 'customcombobox',
             itemId: 'programId',
             name: 'PROGRAM_ID',
             width: 460,
             fieldLabel: getCourseTxCommonTranslation('PROGRAM'),
             store:'common.ProgramStore',
             displayField: 'value',
             valueField: 'id',
             allowBlank: true,
             typeAhead: true,
             forceSelection: true
        },{
        	  xtype: 'customcombobox',
              itemId: 'batchId',
              name: 'BATCH_ID',
              fieldLabel: getCourseTxCommonTranslation('BATCH'),
              store: 'program.programDetails.programBatches.InheritFromBatchStore',
              valueField: 'id',
              displayField: 'value',
              allowBlank: true,
              typeAhead: true,
              forceSelection: true
        }]     
        },{	
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
	            	 xtype: 'customcombobox',
	                 itemId: 'topicNameId',
	                 name: 'TOPIC_NAME_ID',
	                 fieldLabel: getCourseTxCommonTranslation('PERIOD'),
	                 store: 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
	                 valueField: 'id',
	                 displayField: 'value',
	                 allowBlank: true,
	                 typeAhead: true,
	                 forceSelection: true
                  },{
                	  xtype: 'customcombobox',
	  	              itemId: 'studentAdmissionId',
	  	              name: 'STUDENT_ADMISSION_ID',
	  	              fieldLabel: getCourseTxCommonTranslation('STUDENT_ADMISSION'),
//	  	              store: 'coursetransaction.studymaterialdistribution.StudentAdmission',
	  	              valueField: 'id',
	  	              displayField: 'value',
	  	              allowBlank: true,
	  	              typeAhead: true,
	  	              forceSelection: true
	  	          },{
	  	               xtype: 'customcombobox',
		  	           itemId: 'studentNameId',
		  	           name: 'STUDENT_NAME_ID',
		  	           fieldLabel: getCourseTxCommonTranslation('STUDENT_NAME'),
		  	          // store: ' coursetransaction.studymaterialdistribution.StudentName ',
		  	           valueField: 'id',
		  	           displayField: 'value',
		  	           allowBlank: true,
		  	           typeAhead: true,
		  	           forceSelection: true 
                  }]
	        },{
	        	
	        	  xtype: 'fieldcontainer',
	              width: '100%',
	              layout: 'hbox',
	              defaults: {
	                  labelAlign: 'top',
	                  width: 226
	              },
	              items: [{
	  	            	 xtype: 'customcombobox',
	  	                 itemId: 'readingNameId',
	  	                 name: 'READING_NAME_ID',
	  	                 fieldLabel: getCourseTxCommonTranslation('READING_NAME'),
	  	                 store: 'coursetransaction.studymaterialdistribution.CourseReading',
	  	                 valueField: 'id',
	  	                 displayField: 'value',
	  	                 allowBlank: true,
	  	                 typeAhead: true,
	  	                 forceSelection: true
	                },{
	  	                xtype: 'customcombobox',
	  	                itemId: 'listNameId',
	  	                name: 'LIST_NAME_ID',
	  	                fieldLabel: getCourseTxCommonTranslation('LIST_NAME'),
	  	                store: 'coursetransaction.studymaterialdistribution.ListName',
	  	                valueField: 'id',
	  	                displayField: 'value',
	  	                allowBlank: true,
	  	                typeAhead: true,
	  	                forceSelection: true
	  	             },{
	  	            	 xtype: 'customcombobox',
	  	                 itemId: 'senderStatusId',
	  	                 name: 'SENDER_STATUS_ID',
	  	                 fieldLabel: getCourseTxCommonTranslation('SENDER_STATUS'),
	  	                 store: 'coursetransaction.studymaterialdistribution.SendingStatus',
	  	                 valueField: 'value',
	  	                 displayField: 'value',
	  	                 allowBlank: true,
	  	                 typeAhead: true,
	  	                 forceSelection: true      
	              }]
	        },{
	        	  xtype: 'fieldcontainer',
	              width: '100%',
	              layout: 'hbox',
	              defaults: {
	                  labelAlign: 'top',
	                  width: 226
	              },
	              items: [{
	            	    xtype: 'customcombobox',
	  	                itemId: 'receivingStatusId',
	  	                name: 'RECEIVING_STATUS',
	  	                fieldLabel: getCourseTxCommonTranslation('RECEIVING_STATUS'),
	  	                store: 'coursetransaction.studymaterialdistribution.ReceivingStatus',
	  	                valueField: 'value',
	  	                displayField: 'value',
	  	                allowBlank: true,
	  	                typeAhead: true,
	  	                forceSelection: true
	  	             },{
	  	            	 xtype: 'customcombobox',
	  	                 itemId: 'distributionModeId',
	  	                 name: 'DISTRIBUTION_MODE_ID',
	  	                 fieldLabel: getCourseTxCommonTranslation('DISTRIBUTION_MODE'),
	  	                 store: 'coursetransaction.studymaterialdistribution.DistributionModeStore',
	  	                 valueField: 'id',
	  	                 displayField: 'value',
	  	                 allowBlank: true,
	  	                 typeAhead: true,
	  	                 forceSelection: true
	                    },{
                    	 xtype: 'customcombobox',
 	  	                 itemId: 'listTypeId',
 	  	                 name: 'LIST_TYPE_ID',
 	  	                 fieldLabel: getCourseTxCommonTranslation('LIST_TYPE'),
 	  	                 store: 'coursetransaction.studymaterialdistribution.DistributionListType',
 	  	                 valueField: 'value',
 	  	                 displayField: 'value',
 	  	                 allowBlank: true,
 	  	                 typeAhead: true,
 	  	                 forceSelection: true	
	                    }]
	        },{
	        	 xtype: 'fieldcontainer',
	              width: '100%',
	              layout: 'hbox',
	              defaults: {
	                  labelAlign: 'top',
	                  width: 226
	              },
	              items: [{
		  	            	xtype: 'datefield',
		  					name:'FROM_DATE',
		  					itemId:'fromDate',
		  	                fieldLabel: getCourseTxCommonTranslation('FROM_DATE'),
		  	            //--submitFormat: CONSTANTS.DATE_FORMAT,
		  		            endDateField : 'toDate',
	         	            vtype : 'daterange',
	        				listeners: {
	        					render: function(field) {
	        						return dateFormatRender(field);
	        					}
	        				}
	                    },{
	                    	xtype: 'datefield',
	         				name:'TO_DATE',
	         				itemId:'toDate',
	                        fieldLabel: getCourseTxCommonTranslation('TO_DATE'),
	         	            format: CONSTANTS.DATE_FORMAT,
	         	         //--submitFormat: CONSTANTS.DATE_FORMAT,
	         	            endDateField : 'fromDate',
	         	            vtype : 'daterange',
	        				listeners: {
	        					render: function(field) {
	        						return dateFormatRender(field);
	        					}
	        				}
	         	            
	                    }]
	        },{
	            xtype: 'fieldcontainer',
	            width: '100%',
	            
	            items: [{
	                xtype: 'button',
	                text: getCourseTxCommonTranslation('SEARCH'),
	                itemId: 'searchBtn',
	                buttonAlign: 'left',
	                ui: 'CustomBtnSubmit',
	                scale: CONSTANTS.BUTTONSIZE
	                },{
	            	 xtype: 'button',
	                 text: getCourseTxCommonTranslation('RESET'),
	                 itemId: 'resetBtn',
	                 ui: 'CustomBtnCancel',
	                 scale: CONSTANTS.BUTTONSIZE
	            }]
	         }]
});