/**
 * @author Dharmendra.P
 * 
 */
Ext.define('Academia.view.coursetransaction.studymaterialdistributionnew.StudyMaterialdistSearch',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.studymaterialdistsearch',
	plugins : "formlabelrequired",
	method : 'POST',
	standardSubmit : false,
	cls:'customSearchPanel',
	layout : {
		type : 'vbox'
	},
	defaults : {
		labelAlign : 'top',
		width : 226
	},
	items : [{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
		xtype: 'multiselectcombofield',
		width: 460,
		//height: 'auto',
		name: 'multiselectAcademyLocation',
		itemId: 'multiselectAcademyLocationId',
		cls: 'multiselectAcademyLocation',
		allowBlank : false,
		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
//		translationKey: 'ACADEMY_LOCATION',
		store:'common.AccesibleAcademyLocationNameSeparated',
		displayField:'value',
		valueField:'id',
		matchFieldWidth:true,
		queryMode:'local',
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.width = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{code}' +
				'</div>';
			}
		}
	}]},{
			xtype : 'fieldcontainer',
			width: 'auto',
			layout : {
				type : 'hbox'
			},
			defaults : {
				width : 226,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey: 'PROGRAM',
				name : 'programId',
				itemId : 'programId',
				store:'common.ProgramByAcademyLocationStore',
				displayField:'valueCode',
				valueField:'id',
				width:450,
				allowBlank : false,
				typeAhead:false,
            	forceSelection:true,
            	queryParam:'programName',
            	minChars:3,
            	triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
            	enableKeyEvents  : 'true',
            	hideTrigger:false,
            	forceSelection:true,
            	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	listConfig: {
            		listeners: {
            			beforeshow: function(picker) {
            				picker.minWidth = picker.up('combobox').getSize().width;
            			}
            		},
            		loadingText: getCommonTranslation('SEARCHING'),
            		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            		getInnerTpl: function() {
            			return '<div class="search-item">' +
            			'{code} / {value}' +
            			'</div>';
            		}
            	}
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),
				disabled:true,
				store: 'enquiry.AcademicBatchStore',
				valueField: 'id',
				allowBlank : false,
				displayField: 'value',
				typeAhead:true,
				forceSelection:true
			}
			]},{
				xtype : 'fieldcontainer',
				width: 'auto',
				layout: 'hbox',
				defaults : {
					width : 226,
					labelAlign : 'top'
				},
				items : [{
					xtype: 'customcombobox',
					name: 'periodId',
					itemId:'periodId',
					fieldLabel: getExaminationTranslation('PERIOD'),
					store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
					displayField:'value',
					valueField:'id',
					allowBlank : false,
					forceSelection:true,
					typeAhead:true,
					disabled:true
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					width: 226,
					labelAlign: 'top',
					name : 'sectionId',
					itemId : 'sectionId',
					allowBlank : false,
					store:'attendance.SectionAndFacultyByPeriodID',
					displayField : 'sectionCode',
					valueField : 'sectionId',
					typeAhead : true,
					disabled:true,
					forceSelection : true
				}
				]},{
					xtype : 'fieldcontainer',
					width: 'auto',
					layout: 'vbox',
					defaults : {
						width : 226,
						labelAlign : 'top'
					},
					items : [{/*
						xtype : 'customcombobox',
						width:460,
						fieldLabel : getCourseTxCommonTranslation('COURSE'),
						name : 'courseId',
						itemId : 'courseId',
						store:'attendance.StudentCourses',
						displayField : 'courseCodeName',
						valueField : 'courseId',
						typeAhead : true,
						disable:true,
						forceSelection : true
//						allowBlank:false,
					*/
						xtype: 'customcombobox',
						name: 'variant',
						itemId: 'variantId',
						fieldLabel:  getProgramandcourseTranslation('COURSE_VARIANT'),
//						translationKey: 'COURSE_VARIANT',
						store:'coursetransaction.sectioncoursecoverageplan.mastertimetable.VariantBySection',
						displayField:'code',
						valueField:'id',
						allowBlank:true,
						typeAhead:true,
						forceSelection:true
					 },{
						xtype: 'customcombobox',
						name:'studentName',
						itemId:'studentId',
//						store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
//						store: 'examinationcenters.evaluation.evaluationPlanHeirarchy.createGroup.StudentListForAcademic',
						store: 'feeandpayment.managebill.Student',
						fieldLabel:getCourseTxCommonTranslation('STUDENT_NAME'),
						valueField: 'id',
						displayField: 'valueCode',
						queryParam:'studentNameOrCode',
						minChars:3,
						typeAhead:false,
						triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
						enableKeyEvents  : 'true',
						hideTrigger:false,
						emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
						triggerAction: '',
						forceSelection:true,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.minWidth = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
							getInnerTpl: function() {
								return '<div class="search-item">' +
								'{studentCode} / {studentName}' +
								'</div>';
							}
						}
					}
					]},{
						xtype : 'fieldcontainer',
						width: 'auto',
						layout : {
							type : 'hbox'
						},
						defaults : {
							width : 226,
							labelAlign : 'top'
						},
						items : [{
							xtype : 'customcombobox',
							fieldLabel : getCourseTxCommonTranslation('DISTRIBUTION_LIST'),
							name : 'distributionId',
							itemId : 'distributionId',
							store:'coursetransaction.studymaterialdistributionnew.DistributionListStr',
							displayField:'value',
							valueField:'id',
							typeAhead:true,
							forceSelection:true
						},{
							xtype: 'textfield',
							name: 'pacletNo',
							itemId:'pacletNoId',
							fieldLabel : getCourseTxCommonTranslation('PACKET_NO')
						},{
							xtype: 'textfield',
							name: 'consignmentRefNo',
							itemId:'consignmentRefNoId',
							fieldLabel : getCourseTxCommonTranslation('CONSIGNMENT_REFERENCE_NO')
						}
						]},{

							xtype : 'fieldcontainer',
							width: 'auto',
							layout : {
								type : 'hbox'
							},
							defaults : {
								width : 226,
								labelAlign : 'top'
							},
							items : [{
								xtype : 'customcombobox',
								fieldLabel : getCourseTxCommonTranslation('SERVICE_PROVIDER'),
								name : 'serviceProvideId',
								itemId : 'serviceProvideId',
								store:'coursetransaction.studymaterialdistributionnew.ServiceProviderSmdStr',
								displayField:'value',
								valueField:'id',
								typeAhead:true,
								forceSelection:true
							},{
								xtype : 'customcombobox',
								fieldLabel : getCourseTxCommonTranslation('PACKET_STATUS'),
								name : 'packetStatus',
								itemId : 'packetStatus',
								store:'course.readingmaterial.ReadingMaterialConditionStore',
								displayField:'value',
								valueField:'id',
								typeAhead:true,
								forceSelection:true
							}]
						},{
						xtype : 'fieldcontainer',
						width: 'auto',
						defaults : {
							width : 226,
							labelAlign : 'top'
						},
						layout : {
							type : 'hbox'
						},
						items : [{
							xtype : 'datefield',
							fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
							name : 'fromDate',
							itemId:'fromDate',	
							endDateField : 'toDate',
							//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
							vtype : 'daterange',
		    				listeners: {
		    					render: function(field) {
		    						return dateFormatRender(field);
		    					}
		    				}
						},{
							xtype : 'datefield',
							fieldLabel : getProgramandcourseTranslation('TO_DATE'),
							name : 'toDate',
							itemId:'toDate',
							startDateField : 'fromDate',
							//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
							vtype : 'daterange',
		    				listeners: {
		    					render: function(field) {
		    						return dateFormatRender(field);
		    					}
		    				}
						}]},
					{
	            xtype: 'fieldcontainer',
	            width: 'auto',
	            items: [{
	                xtype: 'button',
	                text: getCommonTranslation('SEARCH'),
	                itemId: 'searchBtn',
	                buttonAlign: 'left',
	                ui: 'CustomBtnSubmit',
	                formBind : true,
	                scale: CONSTANTS.BUTTONSIZE
	            },{
	                xtype: 'button',
	                text: getCourseTxCommonTranslation('RESET'),
	                itemId: 'resetBtn',
	                buttonAlign: 'left',
	                ui: 'CustomBtnCancel',
	                scale: CONSTANTS.BUTTONSIZE
	            }]
	        }]
//	}]
});
