/*
 * @author Akshay.Kalbhor
 */
Ext.define('Academia.view.criteriabuilder.DataSource.SearchConfigDataSource', {
	alias: 'widget.searchconfigdatasource',
	config : {
		wsSearchConfigTables : new Array(),
		wsSearchTableColumns : new Array(),

		dateOperators: new Array(),
		booleanOperators : new Array(),
		stringOperators : new Array(),
		integerOperators : new Array(),
		
		identityOperators : new Array(),
		referenceIdentifyOperators : new Array(),
		enumOperators : new Array(),
		characterOperators : new Array(),
		allColumnViewsearchSQLGroups:new Array(),
		columnMap : new Ext.util.HashMap(),
		defaultColumnMap : new Ext.util.HashMap()
	},
	
	constructor:function (config){
		if(config != null && config != undefined) {
			
			var tables = config.wsSearchConfigTables;
			
			Ext.each(tables, function(table) {
				//var res = (table.displayCode).split(".");
				//var displayCode = getCBTranslation(res[1]);
				var trnslatedTableName = getCBTranslation(table.displayCode);
				if(trnslatedTableName !== undefined && trnslatedTableName !== "")
				{
					table.displayCode=trnslatedTableName;
				}else{
					console.log("Translations not found for :"+table.displayCode);
				}
				var columns = table.wsSearchTableColumns;
				var filteredColumns = new Array();
				Ext.each(columns, function(column) {
					/*
					 * code to skip ref_identity and identity fields.
					 */
						if(column.dataType === 'REF_IDENTITY' || column.dataType === 'IDENTITY') {
							
						}  else {
							/*
							 * V2D-37101
							 */
							if((column.displayCode).indexOf('.') == -1){
								filteredColumns.push(column);
							}else{
							var res = (column.displayCode).split(".");
							var code = res[1]+"_"+res[2]; 
							var displayCode = getCBTranslation(code);
							if(displayCode!=undefined || displayCode!=null) {
								column.displayCode = displayCode;
							} else {
								column.displayCode = column.displayCode;
							}
							
							filteredColumns.push(column);
							}
						}
				});
				table.wsSearchTableColumns = filteredColumns;
			});
			
			/*
			 * Translations of Date Operators
			 */
			var dateoperators = config.dateOperators;
			Ext.each(dateoperators, function(operator) {
				var translatedDisplayCode = getCBTranslation(operator.displayCode);
				operator.displayCode = translatedDisplayCode;
			});
			/*
			 * Translations of String operators
			 */
			var stringOperands = config.stringOperators;
			Ext.each(stringOperands, function(operator) {
				var displayCode = getCBTranslation(operator.displayCode);
				operator.displayCode = displayCode;
			});
			/*
			 * Translations of Boolean operators
			 */
			var booleanOperands = config.booleanOperators;
			Ext.each(booleanOperands, function(operator) {
				var displayCode = getCBTranslation(operator.displayCode);
				operator.displayCode = displayCode;
			});
			//TODO: do translation of number array
			
			/*
			 * Translations of Integer operators
			 */
			var integerOperands = config.integerOperators;
			Ext.each(integerOperands, function(operator) {
				var displayCode = getCBTranslation(operator.displayCode);
				operator.displayCode = displayCode;
			});
			
			/*
			 * Translations of Enum operators
			 */
			var enumOperands = config.enumOperators;
			Ext.each(enumOperands, function(operator) {
				var displayCode = getCBTranslation(operator.displayCode);
				operator.displayCode = displayCode;
			});
		}
		this.initConfig(config);
	},
	
	findWsSearchConfigTableColums:function(wsSearchConfigTableId){
		/*
		 * STEPS to FOLLOW: 
		 * for each wsSearchConfigTable
		 * if identity or reference identity skip
		 * else add to searchTableColumns;
		 */
		Ext.each(this.wsSearchConfigTables, function(tableRecord) {
			if(tableRecord.id === wsSearchConfigTableId) {
				this.wsSearchTableColumns = tableRecord.wsSearchTableColumns;
			}
		});
		return this.wsSearchTableColumns;
	},
	
	createWsSearchConfigTablesStore: function() {
		var store = Ext.getStore('Academia.store.criteriabuilder.TableConfigs');
		var storeData = this.getWsSearchConfigTables();
		store = store.add(storeData);
		return store;
	},
	
	initializeOperatorStoreByOperatorName: function(OperatorName) {
    	switch(OperatorName) {
    	/*case 'tableConfigStore': 
    			var storeData = searchConfigDataSource.getWsSearchConfigTables();
    			var store = store.add(storeData);
    			return store;
    		break;
    	case 'columnConfigStore':
    			var storeData = searchConfigDataSource.getWsSearchTableColumns();
    			return store.add(storeData);
    		break;*/
    	case 'NUMBER':
    		var integerConfigStore = Ext.create('Academia.store.criteriabuilder.IntegerConfigs');
    			var storeData = this.getIntegerOperators();
    			integerConfigStore.loadData(storeData);
    			return integerConfigStore;
    		break;
    	case 'STRING':
    		var stringConfigStore = Ext.create('Academia.store.criteriabuilder.StringConfigs');
				var storeData = this.getStringOperators();
				stringConfigStore.loadData(storeData);
				return stringConfigStore;
			break;
		
    	case 'BOOLEAN':
    		var booleanConfigStore = Ext.create('Academia.store.criteriabuilder.BooleanConfigs');
    			var storeData = this.getBooleanOperators();
    			booleanConfigStore.loadData(storeData);
    			return booleanConfigStore;
    		break;
    	
    	case 'DATE':
    			var dateConfigStore = Ext.create('Academia.store.criteriabuilder.DateConfigs');
    			var storeData = this.getDateOperators();
    			dateConfigStore.loadData(storeData);
    			return dateConfigStore;
    		break;
    	case 'ENUM':
    			var enumConfigStore = Ext.create('Academia.store.criteriabuilder.EnumConfigs');
				var storeData = this.getEnumOperators();
				enumConfigStore.loadData(storeData);
				return enumConfigStore;
			break;
    	case 'CHAR':
    			var charConfigStore = Ext.create('Academia.store.criteriabuilder.CharConfigs');
				var storeData = this.getCharacterOperators();
				charConfigStore.loadData(storeData);
				return charConfigStore;
			break;
    	case 'IDENTITY':
    			var identityConfigStore = Ext.create('Academia.store.criteriabuilder.IdentityConfigs');
    			var storeData = this.getIdentityOperators();
    			identityConfigStore.loadData(storeData);
				return identityConfigStore;
    		break;
    	case 'REF_IDENTITY':
    			var refidentityConfigStore = Ext.create('Academia.store.criteriabuilder.RefIdentityConfigs');
    			var storeData = this.getReferenceIdentifyOperators();
    			refidentityConfigStore.loadData(storeData);
				return refidentityConfigStore;
    		break;
    	}
    }
});
