/*
 * @author Akshay.Kalbhor
 */
/*
 * File for adding the group item in the Advanced search criteria.
 */
Ext.define('Academia.view.criteriabuilder.simpleadvancesearch.SimpleSearchCriteriaGroup', {
	extend: 'Ext.form.Panel',
	alias: 'widget.simplesearchcriteriagroup',
	cls: 'panelNoSpace',
	config: {
		searchConfigDataSource: null,
		andOrComponentValue:'AND'
	},
	layout: {
		type: 'hbox'
	},
	initComponent: function() {
		this.callParent(arguments);
		this.getDockedItems('toolbar[dock="top"]')[0].hide();
	},
	tbar: [{
		xtype: 'text',
		hidden: true,
		text: getCommonTranslation('CREATE_SEARCH_OR')
	}, {
		xtype: 'button',
		itemId: 'andOrComponent',
		text: 'all',
		cls: 'CustomBodyBtnSettings',
		enableToggle: true,
		disabled:true,
		hidden: true,
		pressedText: 'any',
		depressedText: 'all',
		toggleHandler: function () {
			if(this.pressed) {
				this.setText(this.pressedText);
				this.up('form').andOrComponentValue = 'OR'; 
			} else {
				this.setText(this.depressedText);
				this.up('form').andOrComponentValue = 'AND';
			}
			this.up('form').changeLogicalOperand();
		}
	}, {
		xtype: 'text',
		hidden: true,
		text: getCommonTranslation('ADVANCEDSEARCHUSERMODULEGROUPDEFAULTTEXTHALF')
	},
	'->',
	{
		xtype: 'button',
		itemId: 'lineButton',
		cls: 'CustomBodyBtnSettings',
		text: getCommonTranslation('ADDBUTTONTEXT'),
		tooltip: getCommonTranslation('ADD'),
		width: 24,
		hidden:true,
		handler: function() {
			var groupContainerPanel= this.up('panel');
			/*
			 * Code to remove the error class from the panel if present
			 */
			if(groupContainerPanel.hasCls('cbCustomErrorPanel')) {
				groupContainerPanel.removeCls('cbCustomErrorPanel');
			}
			groupContainerPanel.addSearchCriteriaLineItem(groupContainerPanel);
			this.up('form').changeLogicalOperand();
			this.up('form').setSaveAndSearchButtonsVisible();
		}
	}],
	items: [{
		xtype: 'text',
		itemId: 'andOrComponent',
		minWidth: '27px',
		padding: '9 0 0 0'
	}, {
		xtype: 'form',
		autoScroll: false,
		itemId: 'verticalPanel',
		cls: 'noBorderPane',
		nextChildIndex:0,
		layout: {
			type: 'vbox',
			align: 'stretch'
		},
		items: [{
			xtype: 'fieldcontainer',
			itemId: 'tableSearchFilterContainer',
			layout: {
				type: 'hbox'
			},
			items: [{
				xtype : 'multiselectcombofield',
				width: 685,
				autoHeight: true,
				minChars: 1,
				name : 'tableSearchFilter',
				itemId:'tableSearchFilter',
				hideLabel: true,
				store: 'Academia.store.criteriabuilder.TableConfigs',
				emptyText : getCommonTranslation('SELECT_CRITERIA'),
				allowBlank : false,
				queryMode: 'local',
				valueField : 'id',
				editable: true,
				typeAhead :true,
				autoloadStore: false,
				displayField : 'displayCode',
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    						setTimeout(function(){
        						picker.el.dom.children[1].style.height = (parseInt(picker.el.dom.style.height)-35)+"px";
    						},100);
    					},
    					resize: function(picker) {
    						setTimeout(function(){
        						picker.el.dom.children[1].style.height = (parseInt(picker.el.dom.style.height)-35)+"px";
    						},100);
    					},
						itemclick: function(view, record) {
							var me = this;
							var form = this.up('simplesearchcriteriagroup');
							Ext.apply(form, {
								removedRecord: null,
								setRecordsName: function(record) {
									form.removedRecord = record;
								},
								getRecordsName: function() {
									return form.removedRecord;
								}
							});
							form.setRecordsName(record);
						}
					}
				},
				listeners: {
					select : function(combo, records, eOpts){
						var me = this;
						var form = this.up('simplesearchcriteriagroup');
						var rec = form.getRecordsName();
						var recordValue = combo.getValue();
						var myJson=[];
						for(var i in recordValue){
							myJson.push(recordValue[i].get('id'));
						}
						var isAdd =Ext.Array.contains(myJson,rec.get('id'));
						var simplesearchcriteriagroup = combo.up('simplesearchcriteriagroup');

						if(isAdd){
							/*
							 * Code to remove the error class from the panel if present
							 */
							if(simplesearchcriteriagroup.hasCls('cbCustomErrorPanel')) {
								simplesearchcriteriagroup.removeCls('cbCustomErrorPanel');
							}
							var nestIndexValue=simplesearchcriteriagroup.addSearchCriteriaLineItem(simplesearchcriteriagroup, records[records.length-1]);
							records[records.length-1].set('index', nestIndexValue);
							simplesearchcriteriagroup.changeLogicalOperand();
							simplesearchcriteriagroup.setSaveAndSearchButtonsVisible();
						}else{
							var childPanelIndexes= simplesearchcriteriagroup.onDeselectRemoveSearchCriteriasRecords(simplesearchcriteriagroup,rec);
						}
					}
				}

			}, {
				xtype: 'customcombobox',
				valueField: 'id',
				minWidth:226,
				displayField: 'searchName',
				emptyText: getCommonTranslation('ADVANCEDSEARCHLOADSAVEDSEARCHTEXT'),
				hideLabel: true,
				itemId: 'loadSavedSearchComboId',
				listeners:{
					'render':function(comboReference){
						var store = Ext.create('Academia.store.criteriabuilder.SavedCriterias');
						comboReference.bindStore(store);
						this.up('simpleadvancedsearchquerybuilder').updateComboURL(comboReference);
					},
					'select': function(comboReference, records, eOpts) {
						this.up('simpleadvancedsearchquerybuilder').loadSavedSearchCriteria(this.up('simpleadvancedsearchquerybuilder'), records[0].getId());
					}
				}
			}, {
				xtype: 'button',
				cls: 'dashbordTbarBtn',
				height: 30,
				text: 	getCommonTranslation('CUSTOM_VIEW'),
				menuAlign: 'tr-br',
				menu: {
					cls: 'customSearchNoPadding',
					width: 450,
					padding: 0,
					style :{
						marginLeft: '810px',
						//marginTop: '5px'
					},
					plain:true,
					items: [{
						xtype: 'itemselector',
						name: 'allSearchResultViewColumns',
						itemId: 'searchResultViewColumnSelector',
						valueField: 'resultKey',
						displayField: 'displayCode',
						store: Ext.create('Academia.store.criteriabuilder.AllColumnSearchResultViewStore'),
						width: 450,
						height: 380,        
						buttons: ['add', 'remove'],
						fromTitle: getCommonTranslation('AVALIABLE_COLUMNS'),
						toTitle: getCommonTranslation('SELECTED_COLUMNS'),
						hidden :false
					}]
				}
			}]
		}]
	}],

	addSearchCriteriaGroupItem: function(groupContainerPanel) {
		var verticalPanel = groupContainerPanel.down('panel#verticalPanel');
		var groupRef = Ext.create('Academia.view.criteriabuilder.simpleadvancesearch.SimpleSearchCriteriaGroup', {"searchConfigDataSource":groupContainerPanel.searchConfigDataSource});
		/*
		 * Adding group reference in the vertical panel
		 */
		verticalPanel.add(groupRef);
		return groupRef;
	},

	/*
	 * add search criteria
	 * STEPS TO BE FOLLOWED: 
	 * Up SearchConfig Data Source
	 * Create Table Store
	 * Add Search Criteria Line Item
	 */
	addSearchCriteriaLineItem: function(lineContainerPanel, record,index) {
		var verticalPanel = lineContainerPanel.down('panel#verticalPanel');
		var nextIndex=verticalPanel.nextChildIndex;
		if(index!=undefined && index!=null){
			nextIndex=index;
		}else{
			verticalPanel.nextChildIndex=nextIndex+1;
		}
		var lineRef = Ext.create('Academia.view.criteriabuilder.simpleadvancesearch.SimpleSearchCriteriaLineItem', {
			"searchConfigDataSource":lineContainerPanel.searchConfigDataSource,
			"index":nextIndex,
			style:{marginLeft:'-10px !important'}
			});
		lineRef.initializeComponent(record);
		verticalPanel.add(lineRef);

		return nextIndex;
	},

	/*
	 * function called from the Advanced Search Query Builder view.
	 * called up on click of the search button.
	 */
	getSearchCriteriaValue:function(){
		var searchCriteriaItemContainer = this.down('panel#verticalPanel');
		var andOrComponent = this.down('button#andOrComponent');
		var searchCriteriaItems = searchCriteriaItemContainer.items.items;
		var cbSearchCriteria = new Object();
		var searchCriterias = new Array();
		var criteriaError=false;
		if(searchCriteriaItems.length > 0) { 
			var status = Ext.each(searchCriteriaItems, function(item) {
				/*
				 * item.getSearchCriteriaValue() is a function of the line
				 */
				if(item.itemId!='tableSearchFilterContainer')
				{
					var advancedSearchCriteria = item.getSearchCriteriaValue();
					if(advancedSearchCriteria!=false)
						searchCriterias.push(advancedSearchCriteria);
					else{
						criteriaError=true;
						return false;
					}
				}
			});
			if(criteriaError==false)
			{
				if(andOrComponent.text === 'all') {
					cbSearchCriteria.logicalOperator = 'AND';	
				} else if (andOrComponent.text === 'any'){
					cbSearchCriteria.logicalOperator = 'OR';
				} else {
					cbSearchCriteria.logicalOperator = 'AND';
				}
				cbSearchCriteria.type = 'LOGICAL';
				cbSearchCriteria.searchCriterias = searchCriterias;
			}else
			{
				cbSearchCriteria=false;
			}
		} else {
			//Code to assign red border to the container
			panel = searchCriteriaItemContainer.up('panel');
			panel.addCls('cbCustomErrorPanel');
			Ext.Error.raise(getErrorTranslation('CRITERIABUILDERGENERICERROR'));
			showErrorMessage(getCommonTranslation('ERROR'), getErrorTranslation('CANNOTPERFORMSEARCHONEMPTYGROUP'));
			return false;
		}

		return cbSearchCriteria;
	},

	/*
	 * function to delete/close the passed group.
	 */
	deleteGroupItem: function(groupContainerPanel) {
		var containerPanel = groupContainerPanel.up('panel');
		if(containerPanel.xtype === 'advancedsearchquerybuilder') {
			showErrorMessage(getCommonTranslation('ERROR'), getErrorTranslation('CANNOTDELETETHEFIRSTGROUP'));
		} else {
			groupContainerPanel.close();
		} 

	},

	/*
	 * function to change the logical operand.
	 */
	changeLogicalOperand: function() {
		var buttonText = this.dockedItems.items[0].items.items[1].text;
		//buttonText.setVisible(true);
		/*var andOrComponentText = null;
    	if(buttonText == 'all') {
    		andOrComponentText = 'AND';
    	} else if(buttonText == 'any') {
    		andOrComponentText = 'OR';
    	}
    	var searchCriteriaItemContainer = this.down('panel#verticalPanel');
    	var searchCriteriaItems = searchCriteriaItemContainer.items.items;

    	Ext.each(searchCriteriaItems, function(childItem) {
    		//childItem.changeLogicalComponentText(groupReference.andOrComponentValue)
    		childItem.changeLogicalComponentText(andOrComponentText);
    	});*/
	},

	changeLogicalComponentText: function(logicalOperandText) {
		/*this.andOrComponentValue=logicalOperandText;
    	this.dockedItems.getAt(0).items.getAt(0).setText(logicalOperandText);*/
	},

	initializeByModel: function(searchCriteriaLogicalModel) {

		var groupReference = this;
		var verticalPanelReference =  groupReference.down('panel#verticalPanel');
		var tableSearchFilterCombo=verticalPanelReference.down('#tableSearchFilter');
		tableSearchFilterCombo.reset();
		var searchCriteriaItems  = null;
		var andOrComponent = this.down('button#andOrComponent');
		if(searchCriteriaLogicalModel.data!= undefined) {
			searchCriteriaItems = searchCriteriaLogicalModel.data.searchCriterias;
		} else {
			searchCriteriaItems = searchCriteriaLogicalModel.searchCriterias;
		}

		var tableSearchFilterIdIndexes=[];
		var tableSearchFilterIds=[];
		Ext.each(searchCriteriaItems, function(searchCriteriaItem) {
			if(searchCriteriaItem.type=== 'SQL') {
				var lineItem = Ext.create('Academia.view.criteriabuilder.simpleadvancesearch.SimpleSearchCriteriaLineItem', {
					"searchConfigDataSource":groupReference.searchConfigDataSource,
					"index":verticalPanelReference.nextChildIndex,
					style:{marginLeft:'-10px !important'}
					});
				verticalPanelReference.nextChildIndex=verticalPanelReference.nextChildIndex+1;
				lineItem.createSearchLineItemByModel(searchCriteriaItem);
				verticalPanelReference.add(lineItem);
				tableSearchFilterIdIndexes.push({'id':searchCriteriaItem.advancedSearchCriteria.searchConfigEntityId,'index':lineItem.index});
				tableSearchFilterIds.push(searchCriteriaItem.advancedSearchCriteria.searchConfigEntityId);
			} else if (searchCriteriaItem.type=== 'LOGICAL') {
				groupReference.createSearchGroupItemByModel(searchCriteriaItem, groupReference);
			} else {
				Ext.error.raise(getErrorTranslation('CRITERIABUILDERGENERICERROR'));
			}

		});
		Ext.each(tableSearchFilterIdIndexes,function(record){
			var rec = tableSearchFilterCombo.store.findRecord('id', record.id);
			if(rec!=undefined){
				rec.set('index',record.index);
				tableSearchFilterCombo.store.commitChanges();
			}
		});
		tableSearchFilterCombo.setValue(tableSearchFilterIds);



		var logicalOperator='AND';

		if(searchCriteriaLogicalModel.data!= undefined) {
			logicalOperator = searchCriteriaLogicalModel.data.logicalOperator;
		}else{
			logicalOperator = searchCriteriaLogicalModel.logicalOperator;
		}
		if(logicalOperator=="OR") {
			andOrComponent.setText(andOrComponent.pressedText);
			andOrComponent.up('form').andOrComponentValue = 'OR'; 
		} else {
			andOrComponent.setText(andOrComponent.depressedText);
			andOrComponent.up('form').andOrComponentValue = 'AND';
		}
		andOrComponent.up('form').changeLogicalOperand();
	},

	createSearchGroupItemByModel: function(searchCriteriaGroupItem, groupReference) {
		var group = this.addSearchCriteriaGroupItem(groupReference);
		group.initializeByModel(searchCriteriaGroupItem);
	},

	/**
	 * Method to make the Save and Search buttons visible on click of any button of the group and line.
	 * @author Akshay.Kalbhor
	 */
	setSaveAndSearchButtonsVisible: function() {
		var advancedSearchQueryBuilderView = this.up('panel[xtype=simpleadvancedsearchquerybuilder]');
		var saveSearchButton = advancedSearchQueryBuilderView.down('button#SaveSearchButton');
		var searchButton = advancedSearchQueryBuilderView.down('button#searchButton');
		saveSearchButton.setVisible(true);
		searchButton.setVisible(true);
	},


	onDeselectRemoveSearchCriterias:function(searchCriteriaGroup,record){

		var currentPanelIndex=record.get('index');
		var childPanels=searchCriteriaGroup.down('#verticalPanel').items.items;
		var childPanelsToRemove=new Array();
		Ext.each(childPanels, function(childPanel) {
			if(childPanel.index>=currentPanelIndex)
			{
				//comboReference.up('panel').up('panel').remove(childPanel);
				childPanelsToRemove.push(childPanel);
			}
		});
		var childPanelIndexes=new Array();
		Ext.each(childPanelsToRemove, function(childPanel) {
			childPanelIndexes.push(childPanel.index);
			searchCriteriaGroup.down('#verticalPanel').remove(childPanel);
		});

		return childPanelIndexes;

	},
	onDeselectRemoveSearchCriteriasRecords:function(searchCriteriaGroup,record){

		var currentPanelIndex=record.get('index');
		var childPanels=searchCriteriaGroup.down('#verticalPanel').items.items;
		var childPanelsToRemove=new Array();
		Ext.each(childPanels, function(childPanel) {
			if(childPanel.index==currentPanelIndex)
			{
				childPanelsToRemove.push(childPanel);
			}
		});
		var childPanelIndexes=new Array();
		Ext.each(childPanelsToRemove, function(childPanel) {
			childPanelIndexes.push(childPanel.index);
			searchCriteriaGroup.down('#verticalPanel').remove(childPanel);
		});

		return childPanelIndexes;

	},

});
