/**
 * @author sachin.bangar
 * 
 * This component is used for to show standard master Custom Categories in grid 
 */
Ext.define('Academia.view.customcategories.CustomCategoryStandardMasterGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.customcategorystandardmastergrid',
    title: getCommonTranslation('STD_MASTER_CUSTOM_CATEGORY'),
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        /*plugins: {
			ptype: 'gridviewdragdrop',
		    dragText: getCommonTranslation('CHANGE_DISPLAY_SEQUENCE') //change display sequence		      
		}*/
    },
    tbar: [{
       /* xtype: 'customcombobox',
        labelWidth: 80,
        width: 300,
        fieldLabel: getCommonTranslation('ENTITY_NAME'),
        name: 'customTableConfigId',
        itemId: 'customTableConfigField',
        editable: false,
        displayField: 'value',
        valueField: 'id',
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.customcategories.TableConfigCategoryStore');
                combo.bindStore(store);
            }
        }*/
    
	    xtype: 'customcombobox',
		name: 'customTableConfigId',
		fieldLabel:getCommonTranslation('ENTITY_NAME'),
		itemId: 'customTableConfigField',
		labelWidth: 80,
	    width: 300,
		valueField: 'id',
		displayField: 'value',
		queryParam:'displayName',
		minChars:3,
		typeAhead:false,
		forceSelection:true,
	    allowBlank: false,
	    triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	    enableKeyEvents  : 'true',
	    hideTrigger:false,
	    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	    triggerAction: '',
	    listConfig: {
	    	listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
	        loadingText: getCommonTranslation('SEARCHING'),
	        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        getInnerTpl: function() {
	            return '<div class="search-item">' +
	                '{value}' +
	            '</div>';
	        }
	    },
	    listeners: {
	        render: function(combo) {
	            var store = Ext.create('Academia.store.customcategories.TableConfigCategoryMasterSearchStore');
	            combo.bindStore(store);
	        }
	    }
    }, {
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getCommonTranslation('TABLE_NAME'),
        dataIndex: 'customTableConfigValue',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('COLUMN_NAME'),
        dataIndex: 'columnMappingValue',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('CATEGORY_NAME'),
        dataIndex: 'displayName',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('DISPLAY_ORDER'),
        dataIndex: 'displayOrder',
        sortable: true,
        flex: .3
    }, {
        header: getCommonTranslation('CUSTOM_CATEGORY_MANDATORY'),
        dataIndex: 'whetherMandatory',
        sortable: true,
        flex: .3,
        renderer: function(value){
        	var msg;
        	if(value){
        		msg = getCommonTranslation('TRUE');
        	}else{
        		msg = getCommonTranslation('FALSE');
        	}
        	return msg;
        }
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });

        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.customcategories.CustomCategoryStore');
    }
});