/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show custom field form details in Dialog box
 */
Ext.define('Academia.view.customfields.CustomFieldFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.customfieldformwindow',
    modal: true,
    resizable: false,
    title: getCommonTranslation('CUSTOM_FIELD'),
    items: [{
        xtype: 'form',
        itemId: 'customFieldForm',
        bodyPadding: '10 10 10 10',
        method: 'POST',
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top'
        },
        standardSubmit: false,
        items: [{
            xtype: 'hidden',
            itemId: 'id_hidden_field',
            name: 'id'
        }, {
            xtype: 'hidden',
            name: 'whetherCustomField',
            value: true
        }, {
            xtype: 'hidden',
            name: 'whetherStandardMaster',
            value: false
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [/*{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('ENTITY_NAME'),
                editable: false,
                allowBlank: false,
                name: 'customTableConfig',
                itemId: 'customTableConfigField',
                valueField: 'id',
                displayField: 'value',
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.customcategories.TableConfigCategoryStore');
                        combo.bindStore(store);
                    }
                }
            }*/
            	{  xtype: 'customcombobox',
            		name: 'customTableConfig',
            		fieldLabel:getCommonTranslation('ENTITY_NAME'),
            		itemId: 'customTableConfigField',
            		labelWidth: 80,
                    width: 226,
            		valueField: 'id',
            		displayField: 'value',
            		queryParam:'displayName',
            		minChars:3,
            		typeAhead:false,
            		forceSelection:true,
            	    allowBlank: false,
            	    triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
            	    enableKeyEvents  : 'true',
            	    hideTrigger:false,
            	    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            	    triggerAction: '',
            	    listConfig: {
            	    	listeners: {
            				beforeshow: function(picker) {
            					picker.minWidth = picker.up('combobox').getSize().width;
            				}
            			},
            	        loadingText: getCommonTranslation('SEARCHING'),
            	        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            	        getInnerTpl: function() {
            	            return '<div class="search-item">' +
            	                '{value}' +
            	            '</div>';
            	        }
            	    },
                    listeners: {
                        render: function(combo) {
                            var store = Ext.create('Academia.store.customcategories.TableConfigCategoryMasterSearchStore');
                            combo.bindStore(store);
                        }
                    }
                }, {
                xtype: 'customcombobox',
                itemId: 'cmbFieldType',
                name: 'customFieldDataType',
                fieldLabel: getCommonTranslation('FIELD_TYPE'),
                valueField: 'id',
                displayField: 'value',
                editable: false,
                triggerAcation: 'all',
                fourceSelection: true,
                allowBlank: false,
                listeners: {
                	render: function(combo) {
                        var store = Ext.create('Academia.store.customfields.FieldTypeStore');
                        combo.bindStore(store);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'nestedJsonCombo',
                fieldLabel: getCommonTranslation('COLUMN_NAME'),
                editable: false,
                allowBlank: false,
                name: 'columnMapping',
                itemId: 'columnNameField',
                valueField: 'id',
                displayField: 'value',
                forceSelection: true,
                listeners: {
                	render: function(combo) {
                        var store = Ext.create('Academia.store.customcategories.TableColumnConfigStore');
                        combo.bindStore(store);
                    }
                }
            }, {
                fieldLabel: getCommonTranslation('FIELD_NAME'),
                xtype: 'textfield',
                itemId: 'displayName',
                name: 'displayName',
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                fieldLabel: getCommonTranslation('DROOL_NAME'),
                xtype: 'textfield',
                itemId: 'droolName',
                name: 'droolName'
            }, {
                xtype: 'numberfield',
                fieldLabel: getCommonTranslation('DISPLAY_ORDER'),
                itemId: 'dispalyOrderField',
                name: 'displayOrder',
                minValue: 0,
                allowBlank: false
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'checkboxfield',
                itemId: 'whetherMandatoryField',
                labelAlign: 'right',
                boxLabel: getCommonTranslation('CUSTOM_CATEGORY_MANDATORY'),
                name: 'whetherMandatory',
                inputValue: true,
                uncheckedValue: false
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                itemId: 'submitButtonId',
                text: getCommonTranslation('SAVE'),
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                itemId: 'cancelButtonId',
                text: getCommonTranslation('CANCEL'),
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});