
Ext.define('Academia.view.dashboard.DashboardDashlet', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.dashboarddashlet',
	params:{},
	frame : true,
	resizable : true,
	resizeHandles :'s',
	autoScroll:true,
	draggable: {
		moveOnDrag: true
	},
	//   style:{
	// 	'float' : 'left'
	//  },
	cls:'dashlet',

	graphView:false,
	//flex:1,
	width:'95.1%',
	height: 300,

	loadDashlet :function(){
		console.log('No loadDashlet method');
	},

	getParams :function(){
		var extraParam=this.params,responceObject={};
		for(var propt in extraParam){
			if (extraParam.hasOwnProperty(propt) && extraParam[propt]) {
				responceObject[propt]=extraParam[propt];
			}
		}
		var toolbar = this.up('dashboardhomepage').down('toolbar');

		var dates=toolbar.down('#dateRangePicker').getValues();
		for(var propt in dates){
			if (dates.hasOwnProperty(propt) && dates[propt]) {
				if(propt=="startDate"){
					var startDate=Ext.Date.format(toolbar.down('#dateRangePicker').startDate, CONSTANTS.SUBMIT_DATE_FORMAT);
					responceObject[propt]=startDate;
				}
				if(propt=="endDate"){
					var endDate=Ext.Date.format(toolbar.down('#dateRangePicker').endDate, CONSTANTS.SUBMIT_DATE_FORMAT);
					responceObject[propt]=endDate;
				}
			}
		}
		var intakeYearId=toolbar.down('#intakeYear').getValue();
		var programSelector=toolbar.down('#programSelector').down('acadlocprogbatchseattypecomponent');
		var programDetails=programSelector.getValues();

		// rename ALPBS objects
		responceObject.academyId=programDetails.academy;
		responceObject.locationId=programDetails.location;
		responceObject.programId=programDetails.program;
		responceObject.batchId=programDetails.batch;
		responceObject.seatTypeId=programDetails.seatType;
		if(!isNullOrEmpty(intakeYearId)){
			responceObject.intakeYearId=intakeYearId;	
		}
		return responceObject;	
	},

	tools:[{
		xtype: 'tool',
		type: 'maximize',
		itemId: 'maximizeBtns',
		cls:'dashletMaximize',
		tooltip :getCommonTranslation('CLICK_TO_MAXIMIZE'),
		renderTpl: [ '<img   src="resources/images/icon-Full-screen.svg"/>' ],
		handler: function(e, target, header, tool){
			var portlet = header.ownerCt;
			portlet.maximizeWindow(e, target, header, tool);
		},
		listeners:{
			afterrender:function(btn){
				if(btn.up('grayquestapplicationstudentdashlet')){
					btn.hide();
				}
			}
		},
	        listeners:{
	            afterrender:function(btn){
	                if(btn.up('quicklinksdashlet')){
	                    btn.hide();
	                }
	            }
	        }
	},{
		xtype: 'tool',
		itemId: 'empty',
		width:5,
		renderTpl: [ '<img src=""/>' ],
		cls:'commonwidth'
	},{
		xtype: 'tool',
		type: 'refresh',
		itemId : 'refreshButtonId',
		cls:'dashletRefresh',
		tooltip :getCommonTranslation('CLICK_TO_REFRESH'),
		renderTpl: [ '<img   src="resources/images/icon-refresh.svg"/>' ],
		handler: function(e, target, header, tool){
			var portlet = header.ownerCt;
			portlet.loadDashlet();
			/*portlet.setLoading('Loading...');
			Ext.defer(function() {
				portlet.setLoading(false);
			}, 1000);*/
		},
		listeners:{
			afterrender:function(btn){
				if(btn.up('grayquestapplicationstudentdashlet')){
					btn.hide();
				}
			}
		},listeners:{
			            afterrender:function(btn){
				                if(btn.up('quicklinksdashlet')){
					                    btn.hide();
					                }
				            }
		        }

	},{
		xtype: 'tool',
		itemId: 'empty1',
		width:8,
		renderTpl: [ '<img src=""/>' ],
		cls:'commonwidth'
	},{
		xtype: 'button',
		itemId: 'extraBtns',
		hidden:true,
		cls:'btnWithOnlyMenuDashlet',
		menu: []
	},{
		xtype: 'tool',
		itemId:'separateLineToolItemId',
		///cls:'separateLineCls',
		width:15,
		style:{
			marginLeft:'7px'
		},
		renderTpl: [ '<img   src="resources/images/line-sep.svg"/>' ],
		listeners:{
			afterrender:function(btn){
				if(btn.up('grayquestapplicationstudentdashlet')){
					btn.hide();
				}
			}
		},
		listeners:{
			            afterrender:function(btn){
				                if(btn.up('quicklinksdashlet')){
					                    btn.hide();
					                }
				            }
		        }
	},{ 
		type: 'collapse', 
		cls: 'x-tool-collapse-top', 
		renderTpl: [ '<img   src=""/>' ],
		callback: function() { 
			if(this.up('panel').collapsed == "top"){
				this.addCls('x-tool-collapse-top');
				this.removeCls('x-tool-collapse-bottom');
			}else{
				this.addCls('x-tool-collapse-bottom');
				this.removeCls('x-tool-collapse-top');
			}
			this.up('panel').toggleCollapse();
		} 
	}/*,{
		type: 'expand',
		cls: 'className',
		callback: function() { 
			this.up('panel').expand();
		}
	}*/],

	listeners:{
		move:function( panel, x, y, eOpts ){
			panel.el.dom.style.left = '';
			panel.el.dom.style.top = '';
		},
		afterrender:function(this$){
			if(this$.graphView){
				//var menuBtn = this$.header.down('#graphViewBtn');
				//	menuBtn.setVisible(true);	 
			}
			this$.loadDashlet();
		}
	},

	addExportToPdf:function(panel,grid){
		var exportToPDF={
				text: getCommonTranslation('EXPORT_TO_PDF'),
				itemId: 'exportToPdf',
				handler: function(btn, target, header, tool){
					//grid.exportAllGridData(grid,true,false);  
					if(grid.xtype!='image'){
						grid.exportCurrentPdfData(grid);	
					}
				}
		};
		this.addMenu(exportToPDF,panel);
	},
	addExportToPdfSearchResultGrid:function(panel,grid){
		var exportToPDF={
				text: getCommonTranslation('EXPORT_TO_PDF'),
				itemId: 'exportToPdf',
				handler: function(btn, target, header, tool){
					var dashboardController =  Academia.app.getController('Academia.controller.dashboard.DashboardController');
					dashboardController.exportUserList(SERVERURL.PDFEXPORT,'pdf',false);
				}
		};
		this.addMenu(exportToPDF,panel);
	},

	removeExportToPdf:function(panel){	
		this.removeMenu('exportToPdf',panel);
	},

	addExportToExcel:function(panel,grid){
		var exportToExcel={
				text: getCommonTranslation('EXPORT_TO_EXCEL'),
				itemId: 'exportToExcel',
				handler: function(btn, target, header, tool){
					//grid.exportAllGridData(grid,false,true);  
					if(grid.xtype!='image'){
						grid.exportCurrentExcelData(grid);
					}
				}
		};
		this.addMenu(exportToExcel,panel);
	},

	addExportToExcelSearchResultGrid:function(panel,grid){
		var exportToExcel={
				text: getCommonTranslation('EXPORT_TO_EXCEL'),
				itemId: 'exportToExcel',
				handler: function(btn, target, header, tool){
					var dashboardController =  Academia.app.getController('Academia.controller.dashboard.DashboardController');
					dashboardController.exportUserList(SERVERURL.EXCELEXPORT,'vnd.ms-excel',false);
				}
		};
		this.addMenu(exportToExcel,panel);
	},
	removeExportToExcel:function(panel){	
		this.removeMenu('exportToExcel',panel);
	},

	addExportToPng:function(panel,chart){
		var exportToExcel={
				text: getCommonTranslation('EXPORT_TO_PNG'),
				itemId :'exportToPng',
				handler: function(btn, target, header, tool){
				/*	chart.save({  //V2D-247413
						type: 'image/png'
					});
				 */
					var customWidth = 30;
					var title = 'Statistics By '+chart.axes.items[1].title;
					var surface = chart.surface;
					var svg = Ext.draw.engine.SvgExporter.generate(surface);
					var canvas = document.createElement('canvas');
					var context = canvas.getContext("2d");
					canvas.height = surface.height + 100;
					canvas.width = surface.width+200;
					var x = canvas.width / 10;

					context.font = "18px Georgia";
					context.textAlign = 'bottom';
					context.fillText(title, x, 20);
					context.fillStyle = "#FFFFFF";
					context.fillRect(0,30,surface.width+100,surface.height + 100);
					context.drawSvg(svg,customWidth,30);
					var dataURL = canvas.toDataURL('image/png',1.0);
					downloadImage(dataURL,'chart.png');
				}
		};
		this.addMenu(exportToExcel,panel);
	},

	removeExportToPng:function(panel){	
		this.removeMenu('exportToPng',panel);
	},

	addMenu:function(menu,panel){
		if(!panel)
			panel=this;
		var menuBtn = panel.header.down('#extraBtns'),menuPanel = menuBtn.menu;
		var separateLineTool = panel.header.down('#separateLineToolItemId')
		
		menuBtn.setVisible(true);
		 separateLineTool.removeCls('separateLineClsForMargin')
		 separateLineTool.addCls('separateLineCls')
		menuPanel.add(menu);
	},

	removeMenu:function(itemId,panel){
		if(!panel)
			panel=this;
		var menuBtn = panel.header.down('#extraBtns'),menuPanel = menuBtn.menu,menu=menuPanel.down('#'+itemId);
		var separateLineTool = panel.header.down('#separateLineToolItemId')
		menuPanel.remove(menu);
		if(menuPanel.items.length==0)
			menuBtn.setVisible(false);
		    separateLineTool.removeCls('separateLineCls')
		    separateLineTool.addCls('separateLineClsForMargin')
		},
		/**
		 * add graph view button (image) 
		 */
		addGraphViewButton:function(panel){
			var graphButton = {
					tooltipFlag : 0,
					itemId: 'graphViewBtn',
					tooltip :getCommonTranslation('SHOW_CHART_VIEW'),
					cls:'dashletGraph',
					renderTpl: [ '<img   src="resources/images/icon-graph.svg"/>' ],
					handler: function(btn, target, header, tool){
						var this$ = header.ownerCt;
						header.ownerCt.getLayout().setActiveItem(this$.activeTab);
						this$.params={};
						this$.loadDashlet();
				 }
			};
			var emptyButton = {
					xtype: 'tool',
					itemId: 'empty2',
					width:5,
					renderTpl: [ '<img src=""/>' ],
					cls:'commonwidth'
			};
			
			panel.header.insert(3,graphButton);
			panel.header.insert(4,emptyButton);
		},
		/**
		 * add grid view button (Image)
		 */
		addGridViewButton:function(panel){
			var gridButton = {
					itemId: 'gridViewBtn',
					tooltip :getCommonTranslation('SHOW_GRID_VIEW'),
					cls:'dashletGraph',
					renderTpl: [ '<img   src="resources/images/icon-list.svg"/>' ],
					handler: function(btn, target, header, tool){
						var this$ = header.ownerCt;
						header.ownerCt.getLayout().setActiveItem(this$.activeTab);
						this$.params={};
						this$.loadDashlet();
					}
			};
			
			panel.header.insert(3,gridButton);
			var emptyButton = {
					xtype: 'tool',
					itemId: 'empty2',
					width:5,
					renderTpl: [ '<img src=""/>' ],
					cls:'commonwidth'
			};
			panel.header.insert(4,emptyButton);
		},
		/**
		 * add print button (image) 
		 * 
		 */
		
	addPrintButton:function(panel){
		  var this$ =this;
		  var printButton = {
				tooltipFlag : 0,
				itemId: 'printBtn',
				cls:'dashletPrintBtnCls',
				tooltip :getCommonTranslation('PRINT'),
				renderTpl: [ '<img   src="resources/images/icon-print.svg"/>' ],
				handler: function(btn, target, header, tool){
									/*this$.printButtonAction();
								    this$.params={};
									this$.loadDashlet();*/
							 }
		};
		  var emptyButton = {
					xtype: 'tool',
					itemId: 'empty2',
					width:5,
					renderTpl: [ '<img src=""/>' ],
					cls:'commonwidth'
			};
		  
		  panel.header.insert(1,emptyButton)
		  panel.header.insert(2,printButton);
	 },
	 
		/**
		 * remove grid/graph view button
		 */
		 removeMenuButtons:function(itemId,panel){
			 var btn = panel.header.down('#'+itemId);
			 panel.header.remove(btn);
		  },
		  
		  removeGridViewButton:function(panel){	
			  this.removeMenuButtons('gridViewBtn',panel);
		  },
		  removeGraphViewButton:function(panel){
			  this.removeMenuButtons('graphViewBtn',panel);
		  },
		  
			/**
			 * add options for fee dashlet.
			 */
			addForReceipt:function(panel,chart){
		    	var receipts={
		    			  text: 'Receipt',
				          itemId :'receiptId',
				          handler: function(btn, target, header, tool){
				        	  var feeandpaymentdashlet = btn.up('feeandpaymentdashlet');
					        	 feeandpaymentdashlet.getLayout().setActiveItem(3);
					        	 feeandpaymentdashlet.params={};
					        	 feeandpaymentdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(receipts,panel);
			},
			addForBill:function(panel,chart){
		    	var bills={
		    			  text: 'Bill',
				          itemId :'billId',
				          handler: function(btn, target, header, tool){
				        	  var feeandpaymentdashlet = btn.up('feeandpaymentdashlet');
					        	 feeandpaymentdashlet.getLayout().setActiveItem(1);
					        	 feeandpaymentdashlet.params={};
					        	 feeandpaymentdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(bills,panel);
			},
			addForPayment:function(panel,chart){
		    	var payments={
		    			  text: 'Payment',
				          itemId :'paymentId',
				          handler: function(btn, target, header, tool){
				        	 var feeandpaymentdashlet = btn.up('feeandpaymentdashlet');
				        	 feeandpaymentdashlet.getLayout().setActiveItem(5);
				        	 feeandpaymentdashlet.params={};
				        	 feeandpaymentdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(payments,panel);
			},
			
			  printButtonAction:function(){
				   var $this = this;
				   user=$this.getCurrentlyLoggedInDashletUser();
				   var code ="StudentSummaryReport";
				   var studentId=user.id;
				   var studentPersonId=user.personId;
				   var reportParams =new Object();
				   var title=user.code +"-"+ new Date().getTime();
				   var admissionId = contentPanel.getActiveTab().admissionId;
				   reportParams.reportTitle=title;
				   reportParams.userId=user.id;
				   reportParams.studentId= studentId;
				   reportParams.studentPersonId = studentPersonId;
				   reportParams.academyLocationId = $this.getUserCurrentAcademyLocation();
				   reportParams.code = code;
				   reportParams.admissionId = admissionId;
				   
				   var returnJson = new Object();
				   			   
				   $$this = Academia.app.getController('Academia.controller.personinfo.student.StudentPersonalController');
				   returnJson = $$this.getAllPermissions();

				   reportParams.isIdentity=returnJson.map.isIdentity;
				   reportParams.isParentAndGuardian=returnJson.map.isParentAndGuardian;
				   reportParams.isSiblings = returnJson.map.isSiblings;
				   reportParams.isPersonalDetails = returnJson.map.isPersonalDetails;
				   reportParams.isAddress = returnJson.map.isAddress;
				   reportParams.isEducation = returnJson.map.isEducation;
				   reportParams.isWorkExp = returnJson.map.isWorkExp;
				   reportParams.isMedical = returnJson.map.isMedical;
				   reportParams.isVaccination = returnJson.map.isVaccination;
				   reportParams.isExtraCurricular = returnJson.map.isExtraCurricular;
				   reportParams.isResearch = returnJson.map.isResearch;
				   reportParams.isSeminar = returnJson.map.isSeminar;
				   reportParams.isTraining = returnJson.map.isTraining;
				   reportParams.isPatent = returnJson.map.isPatent;
				   reportParams.isCompetitive = returnJson.map.isCompetitive;
				   reportParams.isPhysicalChar = returnJson.map.isPhysicalChar;
				   reportParams.isScholarShip = returnJson.map.isScholarShip;
				   reportParams.isBilling = returnJson.map.isBilling;
				   reportParams.isReceipt = returnJson.map.isReceipt;
				   reportParams.isPNC = returnJson.map.isPNC;
				   reportParams.isRefund = returnJson.map.isRefund;
				   reportParams.idDocument = returnJson.map.idDocument;
				   reportParams.isService = returnJson.map.isService;
				   reportParams.isDisciplinaryAction = returnJson.map.isDisciplinaryAction;
				   reportParams.isPositiveIncident = returnJson.map.isPositiveIncident;
				   reportParams.isHostal = returnJson.map.isHostal;
				   reportParams.isAcademicHistory = returnJson.map.isAcademicHistory;
				   reportParams.isFeePayerDetail = returnJson.map.isFeePayerDetail;
				   reportParams.isCommunityOptIn = returnJson.map.isCommunityOptIn;
				   reportParams.isNegativeIncident = returnJson.map.isNegativeIncident;
				   reportParams.isStudentOtherInformation = returnJson.map.isStudentOtherInformation;
				   reportParams.isStudentAcademicTopics = returnJson.map.isStudentAcademicTopics;
				   
				   var exportUrl = SERVERURL.PATH_DASHBOARD_PRINT_STUDENT;
				   $this.exportJRXMLReport(code,reportParams,title,'.pdf',exportUrl);
		    },
		    
		    exportJRXMLReport:function(code,reportParams,reportTitle,filetype,exportUrl){
		     	
		 		filetype="application/"+filetype;
		     	  // This code is for GET request that open new tab to download file
		     	 
		     	//baseController = Academia.app.getController('Academia.controller.base.BaseController');
		     	user=this.getCurrentlyLoggedInDashletUser();
		     	
		     	var exportDocumentData =new Object();
		     	exportDocumentData.code=code;
		     	exportDocumentData.userId=user.code;
		 		exportDocumentData.reportParams=reportParams;
		     	exportDocumentData.academyLocationId=this.getUserCurrentAcademyLocation();
		     	exportDocumentData.reportTitle=reportTitle;
		     	if(!isNullOrEmpty(reportParams)){
			     	if(!isNullOrEmpty(reportParams.evaluationGroupId)){
			         	exportDocumentData.evaluationGroupId=reportParams.evaluationGroupId;
			     	}
			     	if(!isNullOrEmpty(reportParams.admissionId)){
			         	exportDocumentData.admissionId = reportParams.admissionId;
			     	}
			     	if(!isNullOrEmpty(reportParams.reportEnum)){
			         	exportDocumentData.reportEnum = reportParams.reportEnum;
			     	}
		     	}
		     	
		     	
		     	var csvForm = Ext.create('Ext.form.Panel',{
		     		items:[{
		     			xtype : 'textfield',
		     			maxLength:1000000,
		     			itemId : 'exportDocumentData',
		     			name : 'exportDocumentData'
		     		}]
		     	}); 
		     	csvForm.down('#exportDocumentData').setValue(Ext.encode(exportDocumentData));
		     	csvForm.getForm().submit({
		 			target: '_blank',
		 		    method:'POST',
		 		    params :{access_token : Ext.Ajax.defaultHeaders.access_token},
		 		    headers :{'Accept':filetype,'Content-Type': 'application/json', 'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		 		    url : exportUrl,
		 		    standardSubmit :true
		     	});
		 	},

			addForTotalAmount:function(panel,chart){
		    	var totalAmount={
		    			  text: 'Total Amount',
				          itemId :'totalAmountId',
				          handler: function(btn, target, header, tool){
				        	 var feeandpaymentdashlet = btn.up('feeandpaymentdashlet');
				        	 feeandpaymentdashlet.getLayout().setActiveItem(0);
				        	 feeandpaymentdashlet.params={};
				        	 feeandpaymentdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(totalAmount,panel);
			},
			removeTotalAmount:function(panel){	
				this.removeMenu('totalAmountId',panel);
			},
			removeReceipt:function(panel){	
				this.removeMenu('receiptId',panel);
			},
			removeBill:function(panel){	
				this.removeMenu('billId',panel);
			},
			removePayment:function(panel){	
				this.removeMenu('paymentId',panel);
			},
			/**
			 * This method is use to get the logged in user.
			 */
			 getCurrentlyLoggedInDashletUser:function() {
			 	var userInfo = Academia.model.authentication.UserInfoModel;
			 	var academyLocIds = [];
			 	var academyLocations = Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getStore().data.items;
			 	for(var i = 0;i < academyLocations.length; i++){
			 		academyLocIds.push(academyLocations[i].data.id);
			 	}
				academyLocationIds = academyLocIds.join();
			 	var user = { 
			 			id: userInfo.get('userId'),
			 			value:userInfo.get('userName'),
			 			code:userInfo.get('code'),
			 			//TODO:Please confirm with other while changing generic methods other functionality might break due to this.
			 			portalId:userInfo.get('portalId'),
			 			personId: userInfo.get('personId'),
			 			academyLocationIds : academyLocationIds
			 	};
			 	return user;
			 },
			 getUserCurrentAcademyLocation:function(){
				return Ext.ComponentQuery.query('combo#cmbGlobalAcademyLocation')[0].getValue();
			},
			
			maximizeWindow :function(e, target, header, tool){
				var portlet = header.ownerCt;
				
				var paramsValue = portlet.getParams();
				var portletCopy = portlet.cloneConfig({collapsible : false,getParams : function(){ return paramsValue;}});
				
				var hbox1= {
				    	xtype:'panel',
				    	itemId:'wrapperPanel',
			    	    layout: 'fit',
				    	cls: portlet.id,
				    	//id:portlet.id,
				    	flex:1,
			    		items:[ portletCopy ]
				    };
				    
				var win = new Ext.Window({
					cls: 'panelNoSpace',
					title : getCommonTranslation('ACADEMIA_DASHBORD'),
				    layout: 'fit',
				    maximized:true,
				    autoScroll: true,
//				    maximized:true,
				    width: '80%',
//				    height:'80%',
				    modal: true,
				    listeners:{
				    	'close':function(win){
				    		var pnlDetail = Ext.ComponentQuery.query('#eventDetailPnlMoreLink')[0];
				    		if(!isNullOrEmpty(pnlDetail)){
				    			pnlDetail.destroy();
				    			Ext.getBody().unmask();
				    		}
				    		if(Ext.ComponentQuery.query('holidayCalendarDashlet').length){
					    		var dashboardController =  Academia.app.getController('Academia.controller.dashboard.DashboardController');
					    		Ext.defer(function(){
					    			dashboardController.applyFilterOnHolidayDashlet(true);
					    		},50);
								
				    		}
				    	}
				    },
				    items: [hbox1]
				});
				var coreErpNavigationController= Academia.app.getController('menu.CoreERPNavigationController');
				coreErpNavigationController.collapseMenu();
				win.isDashlet = true;
				win.show();
				portletCopy.removeMenuButtons('maximizeBtns',portletCopy);
				if(portletCopy.xtype == "completedaycoursedashlet"){
					portletCopy.removeMarkAttendanceLink();
					portletCopy.removeSendMessageLink();
				}
			},
			
			addDetailedTimeTable:function(panel){
		    	var detailedTimeTable={
		    			  text: getProgramandcourseTranslation('DETAIL_TIME_TABLE'),
				          itemId :'detailedTimeTableId',
				          handler: function(btn, target, header, tool){
				        	 var facultycalendardashlet = btn.up('facultycalendardashlet');
				        	 facultycalendardashlet.getLayout().setActiveItem(0);
				        	 facultycalendardashlet.params={};
				        	 facultycalendardashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(detailedTimeTable,panel);
			},
			
			addMasterTimeTable:function(panel,chart){
		    	var masterTimeTable={
		    			  text: getProgramandcourseTranslation('MASTER_TIME_TABLE'),
				          itemId :'masterTimeTableId',
				          handler: function(btn, target, header, tool){
				        	 var facultycalendardashlet = btn.up('facultycalendardashlet');
				        	 facultycalendardashlet.getLayout().setActiveItem(1);
				        	 facultycalendardashlet.params={};
				        	 facultycalendardashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(masterTimeTable,panel);
			},
			
			addEventTimeTable:function(panel,chart){
		    	var eventTimeTable={
		    			  text: 'Events',
				          itemId :'eventTimeTableId',
				          handler: function(btn, target, header, tool){
				        	 var facultycalendardashlet = btn.up('facultycalendardashlet');
				        	 facultycalendardashlet.getLayout().setActiveItem(2);
				        	 facultycalendardashlet.params={};
				        	 facultycalendardashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(eventTimeTable,panel);
			},
			removeMasterTimeTable:function(panel){	
				this.removeMenu('masterTimeTableId',panel);
			},
			removeDetailedTimeTable:function(panel){	
				this.removeMenu('detailedTimeTableId',panel);
			},
			removeEventTimeTable:function(panel){	
				this.removeMenu('eventTimeTableId',panel);
			},

			/**
			 * add options for Application tally dashlet.
			 */
			addForProgramCategory:function(panel,chart){
		    	var programCategorys={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_CATEGORY'),
				          itemId :'programCategoryItemId',
				          handler: function(btn, target, header, tool){
				  			var applicationcountdashlet=btn.up('applicationcountdashlet');
				  			applicationcountdashlet.getLayout().setActiveItem(0);
				  			applicationcountdashlet.params={};
				  			applicationcountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programCategorys,panel);
			},
			addForProgramGroup:function(panel,chart){
		    	var programGroups={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_GROUP'),
				          itemId :'programGroupItemId',
				          handler: function(btn, target, header, tool){
				  			var applicationcountdashlet=btn.up('applicationcountdashlet');
				  			applicationcountdashlet.getLayout().setActiveItem(2);
				  			applicationcountdashlet.params={};
				  			applicationcountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programGroups,panel);
			},
			addForProgramBatch:function(panel,chart){
		    	var programBatchs={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_BATCH'),
				          itemId :'programBatchItemId',
				          handler: function(btn, target, header, tool){
				  			var applicationcountdashlet=btn.up('applicationcountdashlet');
				  			applicationcountdashlet.getLayout().setActiveItem(4);
				  			applicationcountdashlet.params={};
				  			applicationcountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programBatchs,panel);
			},
			addForProgramCategoryGenderWise:function(panel,chart){
		    	var programCategorysGender={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_CATEGORY_GENDER'),
				          itemId :'programCategoryGenderItemId',
				          handler: function(btn, target, header, tool){
				  			var applicationcountdashlet=btn.up('applicationcountdashlet');
				  			applicationcountdashlet.getLayout().setActiveItem(6);
				  			applicationcountdashlet.params={};
				  			applicationcountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programCategorysGender,panel);
			},
			addForProgramGroupGenderWise:function(panel,chart){
		    	var programGroupsGender={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_GROUP_GENDER'),
				          itemId :'programGroupGenderItemId',
				          handler: function(btn, target, header, tool){
				  			var applicationcountdashlet=btn.up('applicationcountdashlet');
				  			applicationcountdashlet.getLayout().setActiveItem(8);
				  			applicationcountdashlet.params={};
				  			applicationcountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programGroupsGender,panel);
			},
			addForProgramBatchGenderWise:function(panel,chart){
		    	var programBatchsGender={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_BATCH_GENDER'),
				          itemId :'programBatchGenderItemId',
				          handler: function(btn, target, header, tool){
				  			var applicationcountdashlet=btn.up('applicationcountdashlet');
				  			applicationcountdashlet.getLayout().setActiveItem(10);
				  			applicationcountdashlet.params={};
				  			applicationcountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programBatchsGender,panel);
			},
			/**
			 * Remove options for Application tally dashlet.
			 */
			removeProgramCategory:function(panel){	
				this.removeMenu('programCategoryItemId',panel);
			},
			removeProgramGroup:function(panel){	
				this.removeMenu('programGroupItemId',panel);
			},
			removeProgramBatch:function(panel){	
				this.removeMenu('programBatchItemId',panel);
			},
			removeProgramCategoryGenderWise:function(panel){	
				this.removeMenu('programCategoryGenderItemId',panel);
			},
			removeProgramGroupGenderWise:function(panel){	
				this.removeMenu('programGroupGenderItemId',panel);
			},
			removeProgramBatchGenderWise:function(panel){	
				this.removeMenu('programBatchGenderItemId',panel);
			},
			/**
			 * add options for Admission tally dashlet.
			 */
			addForProgramCategory_ADM:function(panel,chart){
		    	var programCategorys={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_CATEGORY'),
				          itemId :'programCategoryItemId_ADM',
				          handler: function(btn, target, header, tool){
				  			var admissioncountdashlet=btn.up('admissioncountdashlet');
				  			admissioncountdashlet.getLayout().setActiveItem(1);
				  			admissioncountdashlet.params={};
				  			admissioncountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programCategorys,panel);
			},
			addForProgramGroup_ADM:function(panel,chart){
		    	var programGroups={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_GROUP'),
				          itemId :'programGroupItemId_ADM',
				          handler: function(btn, target, header, tool){
				  			var admissioncountdashlet=btn.up('admissioncountdashlet');
				  			admissioncountdashlet.getLayout().setActiveItem(2);
				  			admissioncountdashlet.params={};
				  			admissioncountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programGroups,panel);
			},
			addForProgramBatch_ADM:function(panel,chart){
		    	var programBatchs={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_BATCH'),
				          itemId :'programBatchItemId_ADM',
				          handler: function(btn, target, header, tool){
				  			var admissioncountdashlet=btn.up('admissioncountdashlet');
				  			admissioncountdashlet.getLayout().setActiveItem(3);
				  			admissioncountdashlet.params={};
				  			admissioncountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programBatchs,panel);
			},
			addForProgramCategoryGenderWise_ADM:function(panel,chart){
		    	var programCategorysGender={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_CATEGORY_GENDER'),
				          itemId :'programCategoryGenderItemId_ADM',
				          handler: function(btn, target, header, tool){
				  			var admissioncountdashlet=btn.up('admissioncountdashlet');
				  			admissioncountdashlet.getLayout().setActiveItem(4);
				  			admissioncountdashlet.params={};
				  			admissioncountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programCategorysGender,panel);
			},
			addForProgramGroupGenderWise_ADM:function(panel,chart){
		    	var programGroupsGender={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_GROUP_GENDER'),
				          itemId :'programGroupGenderItemId_ADM',
				          handler: function(btn, target, header, tool){
				  			var admissioncountdashlet=btn.up('admissioncountdashlet');
				  			admissioncountdashlet.getLayout().setActiveItem(5);
				  			admissioncountdashlet.params={};
				  			admissioncountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programGroupsGender,panel);
			},
			addForProgramBatchGenderWise_ADM:function(panel,chart){
		    	var programBatchsGender={
		    			  text: getCommonTranslation('GROUP_BY_PROGRAM_BATCH_GENDER'),
				          itemId :'programBatchGenderItemId_ADM',
				          handler: function(btn, target, header, tool){
				  			var admissioncountdashlet=btn.up('admissioncountdashlet');
				  			admissioncountdashlet.getLayout().setActiveItem(6);
				  			admissioncountdashlet.params={};
				  			admissioncountdashlet.loadDashlet();
				         }
			     };
		    	this.addMenu(programBatchsGender,panel);
			},
			/**
			 * Remove options for Admission tally dashlet.
			 */
			removeProgramCategory_ADM:function(panel){	
				this.removeMenu('programCategoryItemId_ADM',panel);
			},
			removeProgramGroup_ADM:function(panel){	
				this.removeMenu('programGroupItemId_ADM',panel);
			},
			removeProgramBatch_ADM:function(panel){	
				this.removeMenu('programBatchItemId_ADM',panel);
			},
			removeProgramCategoryGenderWise_ADM:function(panel){	
				this.removeMenu('programCategoryGenderItemId_ADM',panel);
			},
			removeProgramGroupGenderWise_ADM:function(panel){	
				this.removeMenu('programGroupGenderItemId_ADM',panel);
			},
			removeProgramBatchGenderWise_ADM:function(panel){	
				this.removeMenu('programBatchGenderItemId_ADM',panel);
			},
			/**
		 	 * resetPageSetting used for reseting 
		 	 *  page and start params for pagination
		 	 */
		 	resetPageSetting:function(store){
		 		if(store){
		 			store.currentPage = 1;
		 			store.getProxy().setExtraParam('sort', null);
		 		}
		 	},
			  /**
				 * add options for Enquiry tally dashlet.
				 */
				addSourceOfEnquiry:function(panel,chart){
			    	var sourceEnquiry={
			    			  text: getCommonTranslation('GROUP_BY_SOURCE_OF_ENQUIRY'),
					          itemId :'sourceOfEnquiry',
					          handler: function(btn, target, header, tool){
					  			var enquirycountdashlet=btn.up('enquirycountdashlet');
					  			enquirycountdashlet.getLayout().setActiveItem(0);
					  			enquirycountdashlet.params={};
					  			enquirycountdashlet.loadDashlet();
					         }
				     };
			    	this.addMenu(sourceEnquiry,panel);
				},
				addProgramGroupEnquiry:function(panel,chart){
			    	var programGroupEnquiry={
			    			  text: getCommonTranslation('GROUP_BY_PROGRAM_GROUP'),
					          itemId :'programGroupEnquiry',
					          handler: function(btn, target, header, tool){
					  			var enquirycountdashlet=btn.up('enquirycountdashlet');
					  			enquirycountdashlet.getLayout().setActiveItem(2);
					  			enquirycountdashlet.params={};
					  			enquirycountdashlet.loadDashlet();
					         }
				     };
			    	this.addMenu(programGroupEnquiry,panel);
				},
				addProgramCategoryEnquiry:function(panel,chart){
			    	var programCategoryEnquiry={
			    			  text: getCommonTranslation('GROUP_BY_PROGRAM_CATEGORY'),
					          itemId :'programCategoryEnquiry',
					          handler: function(btn, target, header, tool){
					  			var enquirycountdashlet=btn.up('enquirycountdashlet');
					  			enquirycountdashlet.getLayout().setActiveItem(4);
					  			enquirycountdashlet.params={};
					  			enquirycountdashlet.loadDashlet();
					         }
				     };
			    	this.addMenu(programCategoryEnquiry,panel);
				},
				addUserGroupEnquiry:function(panel,chart){
			    	var usersEnquiry={
			    			  text: getCommonTranslation('GROUP_BY_USER'),
					          itemId :'groupUserItemId',
					          handler: function(btn, target, header, tool){
					  			var enquirycountdashlet=btn.up('enquirycountdashlet');
					  			enquirycountdashlet.getLayout().setActiveItem(6);
					  			enquirycountdashlet.params={};
					  			enquirycountdashlet.loadDashlet();
					         }
				     };
			    	this.addMenu(usersEnquiry,panel);
				},
				/**
				 * Remove options for Enquiry tally dashlet.
				 */
				removeProgramCategoryEnquiry:function(panel){	
					this.removeMenu('programCategoryEnquiry',panel);
				},
				removeProgramGroupEnquiry:function(panel){	
					this.removeMenu('programGroupEnquiry',panel);
				},
				removeSourceEnquiry:function(panel){	
					this.removeMenu('sourceOfEnquiry',panel);
				},
				removeUsersEnquiry:function(panel){	
					this.removeMenu('groupUserItemId',panel);
				},
				addMarkAttendanceLink:function(panel){
			    	var markAttendance={
			    			  text: getCommonTranslation('MARK_ATTENDANCE'),
					          itemId :'markAttendanceItemId',
					          handler: function(btn, target, header, tool){
					        	 var completedaycoursedashlet = btn.up('completedaycoursedashlet');
					        	 var programIds = new Array();
								 var programField = completedaycoursedashlet.down('customcombobox');
								 var sectionId = programField.getValue();
					        	 var tabTitle = getMegaMenuTranslation('FP_MARK_ATTENDANCE');
			        				var attendanceController = Academia.app.getController('Academia.controller.facultyportal.attendance.FacultyCaptureAttendanceController');
			        				var personController=  Academia.app.getController('Academia.controller.personinfo.common.PersonCommonController');
			        				var newTab = personController.getTabReferenceByTabTitle(tabTitle);
 		        			        if(newTab){
 		        			            newTab.close();
 		        			        }
			        				personController.addContentPanelTab(tabTitle, 'facultycaptureattendancemasterstructure', null, null, null, null, null);
			        				personController.loadCompleteDayMarkAttendance(attendanceController, sectionId);
					         }
				     };
			    	this.addMenu(markAttendance,panel);
				},
				addStudentList:function(panel,chart){
			    	var studentList={
			    			  text: getCommonTranslation('STUDENT_LIST'),
					          itemId :'studentListItemId',
					          handler: function(btn, target, header, tool){
					        	 var completedaycoursedashlet = btn.up('completedaycoursedashlet');
					        	 completedaycoursedashlet.down('customcombobox').up().setVisible(false);
					        	 completedaycoursedashlet.getLayout().setActiveItem(1);
					        	 completedaycoursedashlet.params={};
					        	 completedaycoursedashlet.loadDashlet();
					         }
				     };
			    	this.addMenu(studentList,panel);
				},
				addSendMessageLink:function(panel,chart){
			    	var sendMessage={
			    			  text: getCommonTranslation('SEND_MESSAGE'),
					          itemId :'sendMessageItemId',
					          handler: function(btn, target, header, tool){
					        	 var completedaycoursedashlet = btn.up('completedaycoursedashlet');
					        	 var personController =  Academia.app.getController('Academia.controller.attendance.PendingAttendanceController');
					        	 var sectionId =  completedaycoursedashlet.down('#programComboFieldItemId').getValue();
			        			 personController.openSendMessageDashletWindow(null, null,sectionId);
					         }
				     };
			    	this.addMenu(sendMessage,panel);
				},
				removeMarkAttendanceLink:function(panel){	
					this.removeMenu('markAttendanceItemId',panel);
				},
				removeStudentList:function(panel){	
					this.removeMenu('studentListItemId',panel);
				},
				removeSendMessageLink:function(panel){	
					this.removeMenu('sendMessageItemId',panel);
				},
				addSessionWiseCDList:function(panel){
			    	var sessionWiseCDSummary={
							text: getCommonTranslation('SESSION_WISE'),
							itemId :'sessionWiseCDSummaryItemId',
							handler: function(btn, target, header, tool){
								var completedaycoursedashlet = btn.up('completedaycoursedashlet');
								completedaycoursedashlet.getLayout().setActiveItem(2);
								completedaycoursedashlet.params={};
								completedaycoursedashlet.loadDashlet();
							}
					};
					this.addMenu(sessionWiseCDSummary,panel);
				},
				removeSessionWiseCDList:function(panel){	
					this.removeMenu('sessionWiseCDSummaryItemId',panel);
				},
				addProgramWiseCDList:function(panel){
			    	var programWiseCDSummary={
							text: getCommonTranslation('PROGRAM_WISE'),
							itemId :'programWiseCDSummaryItemId',
							handler: function(btn, target, header, tool){
								var completedaycoursedashlet = btn.up('completedaycoursedashlet');
								completedaycoursedashlet.getLayout().setActiveItem(0);
								completedaycoursedashlet.params={};
								completedaycoursedashlet.loadDashlet();
							}
					};
					this.addMenu(programWiseCDSummary,panel);
				},
				removeProgramWiseCDList:function(panel){	
					this.removeMenu('programWiseCDSummaryItemId',panel);
				},
				addAttendanceSummaryList1:function(panel,chart){
					var attendanceSummary={
							text: getProgramandcourseTranslation('ATTENDANCE_SUMMERY'),
							itemId :'attendanceSummaryItemId1',
							handler: function(btn, target, header, tool){
								var studentattendancedashlet = btn.up('studentattendancedashlet');
								studentattendancedashlet.getLayout().setActiveItem(1);
								studentattendancedashlet.params={};
								studentattendancedashlet.loadDashlet();
							}
					};
					this.addMenu(attendanceSummary,panel);
				},
				removeAttendanceSummaryList1:function(panel){	
					this.removeMenu('attendanceSummaryItemId1',panel);
				},
				addProgramWiseList:function(panel,chart){
					var programWiseSummary={
							text: getCommonTranslation('PROGRAM_WISE'),
							itemId :'programWiseSummaryItemId',
							handler: function(btn, target, header, tool){
								var studentattendancedashlet = btn.up('studentattendancedashlet');
								studentattendancedashlet.getLayout().setActiveItem(0);
								studentattendancedashlet.params={};
								studentattendancedashlet.loadDashlet();
							}
					};
					this.addMenu(programWiseSummary,panel);
				},
				removeProgramWiseList:function(panel){	
					this.removeMenu('programWiseSummaryItemId',panel);
				},
				addAttendanceSummaryList2:function(panel,chart){
					var attendanceSummary={
							text: getProgramandcourseTranslation('ATTENDANCE_SUMMERY'),
							itemId :'attendanceSummaryItemId2',
							handler: function(btn, target, header, tool){
								var studentattendancedashlet = btn.up('studentattendancedashlet');
								studentattendancedashlet.getLayout().setActiveItem(3);
								studentattendancedashlet.params={};
								studentattendancedashlet.loadDashlet();
							}
					};
					this.addMenu(attendanceSummary,panel);
				},
				removeAttendanceSummaryList2:function(panel){	
					this.removeMenu('attendanceSummaryItemId2',panel);
				},
				addCourseWiseList:function(panel,chart){
					var courseWiseSummary={
							text: getCommonTranslation('COURSE_WISE'),
							itemId :'courseWiseSummaryItemId',
							handler: function(btn, target, header, tool){
								var studentattendancedashlet = btn.up('studentattendancedashlet');
								studentattendancedashlet.getLayout().setActiveItem(2);
								studentattendancedashlet.params={};
								studentattendancedashlet.loadDashlet();
							}
					};
					this.addMenu(courseWiseSummary,panel);
				},
				removeCourseWiseList:function(panel){	
					this.removeMenu('courseWiseSummaryItemId',panel);
				},
				addAttendanceSummaryList3:function(panel,chart){
					var attendanceSummary={
							text: getProgramandcourseTranslation('ATTENDANCE_SUMMERY'),
							itemId :'attendanceSummaryItemId3',
							handler: function(btn, target, header, tool){
								var studentattendancedashlet = btn.up('studentattendancedashlet');
								studentattendancedashlet.getLayout().setActiveItem(5);
								studentattendancedashlet.params={};
								studentattendancedashlet.loadDashlet();
							}
					};
					this.addMenu(attendanceSummary,panel);
				},
				removeAttendanceSummaryList3:function(panel){	
					this.removeMenu('attendanceSummaryItemId3',panel);
				},
				addSessionWiseList:function(panel,chart){
					var sessionWiseSummary={
							text: getCommonTranslation('SESSION_WISE'),
							itemId :'sessionWiseSummaryItemId',
							handler: function(btn, target, header, tool){
								var studentattendancedashlet = btn.up('studentattendancedashlet');
								studentattendancedashlet.getLayout().setActiveItem(4);
								studentattendancedashlet.params={};
								studentattendancedashlet.loadDashlet();
							}
					};
					this.addMenu(sessionWiseSummary,panel);
				},
				removeSessionWiseList:function(panel){	
					this.removeMenu('sessionWiseSummaryItemId',panel);
				},
				getCurrentlyLoggedInUserInfoForPortalDashlet:function(){
					var portalInfo =Academia.model.authentication.PortalInfoModel;
					var userPortalInfo= { 
							admissionDetails: portalInfo.get('admissionDetails'),
							student:portalInfo.get('student'),
							userAacademyLocations:portalInfo.get('userAacademyLocations'),
							programBatchDetails:portalInfo.get('programBatchDetails')
					};
					return userPortalInfo;
				},
				
				
				/**
				 * add options for Hostel dashlet.
				 */
					addForHostelAcademyLocation:function(panel,chart){
			    	var academyLocation={
			    			  text: getCommonTranslation('GROUP_BY_ACADEMY_LOCATION'),
					          itemId :'hostelAcademyLocationId',
					          handler: function(btn, target, header, tool){
					        	  var hosteldashlet = btn.up('hosteldashlet');
					        	  hosteldashlet.getLayout().setActiveItem(1);
					        	  hosteldashlet.params={};
					        	  hosteldashlet.loadDashlet();
					         }
				     };
			    	this.addMenu(academyLocation,panel);
				},
				
				addForHostelProgramBatch:function(panel,chart){
			    	var progBatch={
			    			  text: getCommonTranslation('GROUP_BY_PROGRAM_BATCH'),
					          itemId :'hostelProgramBatchId',
					          handler: function(btn, target, header, tool){
					        	  var hosteldashlet = btn.up('hosteldashlet');
					        	  hosteldashlet.getLayout().setActiveItem(2);
					        	  hosteldashlet.params={};
					        	  hosteldashlet.loadDashlet();
					         }
				     };
			    	this.addMenu(progBatch,panel);
				},
				
				removeHostelProgramBatch:function(panel){	
					this.removeMenu('hostelProgramBatchId',panel);
				},
				removeHostelAcademyLocation:function(panel){	
					this.removeMenu('hostelAcademyLocationId',panel);
				},
				
				addForBuilding:function(panel,chart){
			    	var hostelBuildingArray={
			    			  text: getCommonTranslation('HOSTEL_BUILDING'),
					          itemId :'hostelBuildingId',
					          handler: function(btn, target, header, tool){
					        	  var hosteldashlet = btn.up('hosteldashlet');
					        	  hosteldashlet.getLayout().setActiveItem(0);
					        	  hosteldashlet.params={};
					        	  hosteldashlet.loadDashlet();
					         }
				     };
			    	this.addMenu(hostelBuildingArray,panel);
				},
				
				removeBuilding:function(panel){	
					this.removeMenu('hostelBuildingId',panel);
				},
				
				
				
				/**
				 * add options for Brand Campus Enrolment dashlet.
				 */
				
				addForCampusEnrolmentSummary:function(panel,chart){
			    	var campusEnrolmentSummary={
			    			  text: getCommonTranslation('GROUP_BY_ACADEMY_LOCATION'),
					          itemId :'brandCampusSummaryId',
					          handler: function(btn, target, header, tool){
					        	  var brandCampusSummaryGrid = btn.up('brandcampusenrolmentsummary');
					        	  brandCampusSummaryGrid.getLayout().setActiveItem(0);
					        	  brandCampusSummaryGrid.params={};
					        	  brandCampusSummaryGrid.loadDashlet();
					         }
				     };
			    	this.addMenu(campusEnrolmentSummary,panel);
				},
				
				removeCampusEnrolmentSummary:function(panel){	
					this.removeMenu('brandCampusSummaryId',panel);
				},
				
				
				addForGroupByAcademyEnrolmentSummary:function(panel,chart){
			    	var groupByALEnrolmentSummary={
			    			  text: getCommonTranslation('GROUP_BY_PROGRAM_GROUP'),
					          itemId :'groupByAcademySummaryId',
					          handler: function(btn, target, header, tool){
					        	  var brandCampusSummaryGrid = btn.up('brandcampusenrolmentsummary');
					        	  brandCampusSummaryGrid.getLayout().setActiveItem(1);
					        	  brandCampusSummaryGrid.params={};
					        	  brandCampusSummaryGrid.loadDashlet();
					         }
				     };
			    	this.addMenu(groupByALEnrolmentSummary,panel);
				},
				
				removeGroupByAcademyEnrolmentSummary:function(panel){	
					this.removeMenu('groupByAcademySummaryId',panel);
				},
				
				addEmployeeAttendanceSummaryList:function(panel,chart){
					var attendanceSummary={
							text: getProgramandcourseTranslation('ATTENDANCE_SUMMERY'),
							itemId :'employeeAttendanceSummaryItemId',
							handler: function(btn, target, header, tool){
								var employeeattendancedashlet = btn.up('employeeattendancedashlet');
								employeeattendancedashlet.getLayout().setActiveItem(1);
								employeeattendancedashlet.params={};
								employeeattendancedashlet.loadDashlet();
							}
					};
					//this.addMenu(attendanceSummary,panel); //hide attendance pie chart summary arrow from toolbar 
				},
				removeEmployeeAttendanceSummaryList:function(panel){	
					this.removeMenu('employeeAttendanceSummaryItemId',panel);
				},
				
				/**
				 * add grid data configuration view button (image) 
				 */
				addDataGridConfigureButtonDashlet:function(panel,gridClass,resultGridStoreData,responseData,respUserData){
					var dataGridConfigureButton = {
							tooltipFlag : 0,
							itemId: 'dataGridConfigureBtn',
							hidden: true,
							tooltip :getCommonTranslation('MANAGE_COLUMNS'),
							gridClass: gridClass,
        					defaultColumns: resultGridStoreData,
    			            userDefinedColumns: responseData,
    			            recordId: respUserData.id,
    			            dataGridId: respUserData.dataGridId,
							renderTpl: [ '<img  style="width:17px; height:18px;" src="resources/images/hide_show_view.png"/>' ],
							handler: function(btn, target, header, tool){
								createColumnWindow(gridClass, tool.recordId, tool.dataGridId, tool.defaultColumns, tool.userDefinedColumns);
							}
					};
					panel.header.insert(7,dataGridConfigureButton);
				},
				removeDataGridConfigureButtonDashlet:function(panel){
					 var btn = panel.header.down('#dataGridConfigureBtn');
					 btn.setVisible(false);
				},/**
			 	 * method to get the academy locations display name which will be displayed in the header.
			 	 * @author akshay.kalbhor
			 	 */
			 	getAcademyLocationDisplayName: function(academyLocationId) {
			 		var allAcademyLocations = Academia.utilities.accessControl.AccessControlManager.allocatedAcademyLocations;
			 		var name = null;
			 		try{
			 			Ext.each(allAcademyLocations, function(currentAcademyLocation){
			 				if(currentAcademyLocation.id==academyLocationId){
			 					name = currentAcademyLocation.displayName;
			 				}
			 			});
			 		}
			 		catch(e){
			 			name = null;
			 		}
			 		
			 		if(academyLocationId > 0 && name == null) {
			 	 		var url = SERVERURL.ACADEMY_LOCATION_DISPLAY_NAME;
			 			Ext.Ajax.request({
			 	 			type:'rest',
			 	 			method: 'GET',
			 	 			async: false,
			 	 			url:url,
			 	 			params: {
			 	 				'id': academyLocationId
			 	 			},
			 	 			success : function(response){
			 	            	if(response){
			 	            		name = response.responseText;
			 	            	}
			 	           }
			 	 		});
			 		} else if(name == null) {
			 			name = getCommonTranslation('ACADEMIA_ERP_DEFAULT_TEXT');
			 		}
			 		return name;
			 	},
			 	/**
				 * add requested documents
				 */
				addRequestedDocuments:function(panel,chart){
					var requestedDocuments={
			    			  text: getCommonTranslation('REQUESTED_DOCUMENTS'),
					          itemId :'requestedDocumentsItemId',
					          handler: function(btn, target, header, tool){
					  			var requesteddocumentsdashlet=btn.up('requesteddocumentsdashlet');
					  			requesteddocumentsdashlet.getLayout().setActiveItem(0);
					  			requesteddocumentsdashlet.params={};
					  			requesteddocumentsdashlet.loadDashlet();
					         }
				     };
			    	this.addMenu(requestedDocuments,panel);
				},
				removeRequestedDocuments:function(panel){	
					this.removeMenu('requestedDocumentsItemId',panel);
				},
				getParentPersonId:function(userId) {
				 	  var $this = this;
				 	  var personId = null;
				 	  Ext.Ajax.request({
							type: 'rest',
							url:SERVERURL.FIND_PARENT_PERSON_ID+'?userId='+userId,
							method: 'GET',
							async: false,
							success: function(res, action) {
								personId = Ext.decode(res.responseText);
						   }
					   });
				 	  return personId;
				   }
				

});
