Ext.define('Academia.view.dashboard.OveriddenUserDashlets', {
	extend: 'Ext.form.Panel',
	alias: 'widget.overiddenuserdashlets',

	frame: true,
	autoScroll: true,
	cls: 'panelNoSpace',
	plugins: "formlabelrequired",
	defaults: {
		style : {
			margin: '10px'
		}
	},
	items: [{
		xtype: 'form',
		border: true,
		cls: 'customSearchPanel',
		layout: {
			type: 'hbox'
		},
		defaults: {
			style: {
				margin: '10px'
			},
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'livesearchcombo',
			name: 'userId',
			allowBlank: false,
			forceSelection: true,
			fieldLabel: getPersonModuleTranslation('USER'),
			emptyText: getCommonTranslation('TYPE_3_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			},
			itemId: 'user'
		}, {
			xtype: 'nestedJsonCombo',
			fieldLabel: getCommonTranslation('PORTAL'),
			displayField: 'portalName',
			valueField: 'id',
			editable: false,
			itemId: 'portalCombo',
			queryMode: 'local'
		}]
	}, {
		xtype: 'tabpanel',
		itemId: 'gridTabPanel',
		minWidth: 800,
		cls: 'panelNoSpace',
		plain: true,
		activeTab: 0,
		disabled: true,
		items: [{
			xtype: 'useraccessiblegrid',
			title: getCommonTranslation('USER_ACCESSIBLE_DASHLETS')
		}, {
			xtype: 'overiddenuseraccessiblegrid',
			title: getCommonTranslation('OVERIDDEN_USER_ACCESSIBLE_GRID')
		}]
	}]
});
