Ext.define('Academia.view.dashboard.dashlets.AcadmiaDriveForStudentDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.acadmiadriveforstudentdashlet',
    graphView:true,
    layout:'card',
    activeItem: 0, 
    cls:'AcadmiaDriveForStudentDashletCLS dashlet',
	loadDashlet : function() {
		 var this$=this;
		 var view= this.layout.getActiveItem();
		 if(view.xtype=='dataview'){
			 var store= view.getStore();
			 //var params=this$.getParams();
			 var portalInfo = Academia.model.authentication.PortalInfoModel;
			 var academyLocationId = portalInfo.data.userAacademyLocations[0].academyLocationId;
			 store.getProxy().extraParams = {
				 academyLocationId:academyLocationId
			 };
			 store.removeAll();
			 store.load();
		 }
	},
	defaults: {
		cls:'panelNoSpace'
    },
    items:[{
		xtype:'dataview',
		itemId:'academiaDriveDataview',
		store :Ext.create('Academia.store.facilitiesresources.managegallery.ManageGalleryDashletStore'),
		tpl: new Ext.XTemplate(
						'<tpl for=".">',
						 '<tpl if="fileType == &quot;png&quot; || imageName == &quot;link&quot; || fileType == &quot;jpg&quot; || fileType == &quot;jpeg&quot; || fileType == &quot;gif&quot;">',
						 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap" data-qtip="{labelOfHyperlink}">',
						 '<tpl else>',
						 '<div style="margin-bottom: 10px;" class="gallery-thumb-wrap data-qtip="{labelOfHyperlink}">',
						 '</tpl>',
						 '<tpl if="imageName == &quot;link&quot;">',
						 '<a href="{addHyperlink}" target="_blank"><img src="resources/images/driveToolImages/pin_url.png" /></a>',
						 '<br/><a href="{addHyperlink}" target="_blank"><span>{labelOfHyperlink}</span></a>',
						 '<tpl else>',
						 '<img src="{iconImage}" />',
						 '<br/><span>{imageName}</span>',
						 '</tpl>',
						 '</div>',
						 '</tpl>'
		),
		
        listeners: {
    itemclick: function (view, record, item, index, e) {
        
        var fileType = record.get('fileType');
        var imageName = record.get('imageName');
        var documentId = record.get('id');

        if (!isNullOrEmpty(documentId)) {
            Ext.Ajax.request({
                url: SERVERURL.PATH_CHECK_WHETHER_FILE_EXISIS + documentId,
                method: 'GET',
                callback: function (opt, success, response) {
                    if (response.responseText === 'true') {
                        var csvForm = Ext.create('Ext.form.Panel');
                        csvForm.getForm().submit({
                            target: '_blank',
                            method: 'GET',
                            params: {
                                documentId: documentId,
                                access_token: Ext.Ajax.defaultHeaders ? Ext.Ajax.defaultHeaders.access_token : ''
                            },
                            headers: {
                                'Authorization': Ext.Ajax.defaultHeaders ? Ext.Ajax.defaultHeaders.Authorization : ''
                            },
                            url: SERVERURL.PATH_DOWNLOAD_DRIVE_FILES + '?documentId=' + documentId,
                            standardSubmit: true
                        });
                    } else {
                        showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('DOCUMENT_NOT_EXIST'));
                    }
                }
            });
        }
    }
},
		itemSelector: 'div.gallery-thumb-wrap',
		autoHeight:true,
		//emptyText: getCommonTranslation('NO_FILES_ADDED_YET_MSG'),
		deferEmptyText:false,
	}]
});
