/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.dashboard.dashlets.EMMEmployeeTaskAssignedDashlet', {
    extend: 'Academia.view.dashboard.DashboardDashlet',
    alias: 'widget.emmemployeetaskassigneddashlet',
    graphView: false,
    layout: 'card',
    activeItem: 0,
    cls:'EMMEmployeeTaskAssignedDashletCLS dashlet dahsletColumnCLS',
    loadDashlet: function() {
        var this$ = this;
        var view = this.layout.getActiveItem();
        if (view.xtype == 'griddashlet') {
            var store = view.getStore();
            var extraparams = this$.getParams();
            var userId = this$.getCurrentlyLoggedInDashletUser().id;
            store.getProxy().extraParams = {
                userId: userId
            };
            store.load({
                params: extraparams,
                callback: function(rec, operation, success) {
                    if (rec != null && rec.length == 0) {
                        this$.layout.setActiveItem(0);
                    }
                }
            });
        }
    },
    defaults: {
        cls: 'panelNoSpace',
        xtype: 'griddashlet'
    },
    items: [{
        fields: ['id', 'assignDate', 'topic', 'type', 'description', 'status', 'dueDate', 'completionDate',
            'noOfDaysOverdue', 'ownerPrintName', 'eventName', 'taskRemarks'
        ],
        url: SERVERURL.EMM_EMPLOYEE_TASK_ASSIGNED_DASHLET,
        addPagingToolbar: true,
        columns: [{
            header: getServiceRequestTranslation('TITLE'),
            dataIndex: 'eventName',
            flex: 1,
            sortable: true,
        }, {
            header: getServiceRequestTranslation('EMM_ASSIGNED_DATE'),
            dataIndex: 'assignDate',
            flex: 1,
            renderer: function(date) {
                return dateRender(date);
            },
        }, {
            header: getServiceRequestTranslation('EMM_TOPIC'),
            dataIndex: 'topic',
            flex: 1,
            sortable: true,
            renderer: function(val) {
                if (!isNullOrEmpty(val)) {
                    return getCommonTranslation(val);
                } else {
                	return getCommonTranslation('NA');
                }
                return '';
            }
        }, {
            header: getServiceRequestTranslation('EMM_TYPE'),
            dataIndex: 'type',
            flex: 1,
            sortable: true,
            renderer: function(value) {
                var colorValue = '';
                if (value == 'AGENDA') {
                    colorValue = "<span style = 'color:#2b78e4;'>" + getCommonTranslation(value) + "</span>";
                } else if (value == 'IDEA') {
                    colorValue = "<span style = 'color:#ff9900;'>" + getCommonTranslation(value) + "</span>";
                } else if (value == 'DECISION') {
                    colorValue = "<span style = 'color:#cc0000;'>" + getCommonTranslation(value) + "</span>";
                } else if (value == 'INFO') {
                    colorValue = "<span style = 'color:#009e0f;'>" + getCommonTranslation(value) + "</span>";
                } else if (value == 'TASK') {
                    colorValue = "<span style = 'color:#9900ff;'>" + getCommonTranslation(value) + "</span>";
                } else {
                	return getCommonTranslation('NA');
                }
                return colorValue;
            }
        }, {
            header: getServiceRequestTranslation('DESCRIPTION'),
            dataIndex: 'description',
            flex: 1,
            sortable: true
        }, {
            header: getServiceRequestTranslation('DUE_DATE'),
            dataIndex: 'dueDate',
            flex: 1,
            sortable: true,
            renderer: function(date) {
                return dateRender(date);
            },
        }, {
            header: getServiceRequestTranslation('STATUS'),
            dataIndex: 'status',
            flex: 1,
            sortable: true,
            renderer: function(val) {
                if (!isNullOrEmpty(val)) {
                    if (val == 'PENDING') {
                        return "<a href='#' style = 'color:#cc0000;'>" + getCommonTranslation(val) + "</a>";
                    } else {
                        return getCommonTranslation(val);
                    }
                }
                return '';
            }
        }, {
            header: getServiceRequestTranslation('EMM_COMPLETION_DATE'),
            dataIndex: 'completionDate',
            flex: 1,
            sortable: true,
            renderer: function(date) {
                return dateRender(date);
            }
        }, {
            header: getServiceRequestTranslation('EMM_NO_OF_DAYS_OVERDUE'),
            dataIndex: 'noOfDaysOverdue',
            flex: 1,
            sortable: true,
        }, {
            header: getServiceRequestTranslation('EMM_REMARK_HISTORY'),
            dataIndex: 'taskRemarks',
            flex: 1,
            sortable: true,
            renderer: function(value, meta, record) {
                return "<a href='#'>View</a>";
            }
        }],
        listeners: {
            activate: function(portlet) {
                var emmemployeetaskassigneddashlet = portlet.up('emmemployeetaskassigneddashlet');
                var grid = emmemployeetaskassigneddashlet.getLayout().getActiveItem();
                emmemployeetaskassigneddashlet.addExportToPdf(emmemployeetaskassigneddashlet);
                emmemployeetaskassigneddashlet.activeTab = 1;
                emmemployeetaskassigneddashlet.addExportToPdf(emmemployeetaskassigneddashlet, portlet);
                emmemployeetaskassigneddashlet.addExportToExcel(emmemployeetaskassigneddashlet, portlet);
                portlet.doLayout();
            },
            deactivate: function(portlet) {
                var emmemployeetaskassigneddashlet = portlet.up('emmemployeetaskassigneddashlet');
                emmemployeetaskassigneddashlet.removeExportToPdf();
                emmemployeetaskassigneddashlet.removeExportToExcel();
            },
            cellclick: function(View, CellEl, ColIdx, record, RowEl, RowIdx, e, eopts) {
                var grid = View.up('grid');
                var columnName = grid.columnManager.columns[ColIdx].dataIndex;
                if (e.target.tagName == 'A') {
                    if (columnName == 'status') {
                        var emmController = Academia.app.getController('Academia.controller.eventmeetingminutes.EventMeetingMinutesController');
                        emmController.openEMMEUpdateTaskStatusWin(grid);
                    }
                    if (columnName == 'taskRemarks') {
                        var emmController = Academia.app.getController('Academia.controller.eventmeetingminutes.EventMeetingMinutesController');
                        emmController.openEMMETaskReramkWin(grid);
                    }
                }
            }
        }
    }]
});