/**
 * @author Swapnil.patil
 */
Ext.define('Academia.view.dashboard.dashlets.EnquiryCountDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.enquirycountdashlet',

	graphView:true,
	layout:'card',
	activeItem: 0, 
	autoScroll:false,
	cls:'EnquiryTellyDashletCLS dashlet horizontalScrollingFixed',
	loadDashlet :function(paramObj){
		var this$=this;
		var view= this.layout.getActiveItem();
		var toolbar;
		var dates;
		if(this.up('dashboardhomepage') == undefined){
			dates={
					startDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].startDate,
					endDate:Ext.ComponentQuery.query('extendeddatefilter[itemId=dateRangePicker]')[0].endDate
			};
			if(!isNullOrEmpty(dates.startDate) && !isNullOrEmpty(dates.endDate)){
				dates.startDate = Ext.Date.format(dates.startDate,CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
				dates.endDate=Ext.Date.format(dates.endDate,CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
			}
			
		}else{
			toolbar = this$.up('dashboardhomepage').down('toolbar');
			//dates=toolbar.down('#dateRangePicker').getValues();
			dates={
					startDate:toolbar.down('#dateRangePicker').startDate,
					endDate:toolbar.down('#dateRangePicker').endDate
			};
			dates.startDate = Ext.Date.format(dates.startDate,CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
			dates.endDate=Ext.Date.format(dates.endDate,CONSTANTS.NEW_SUBMIT_DATE_FORMAT);
			//var tempStartDate=new Date(dates.startDate);
			//var tempEndDate=new Date(dates.endDate);
			//dates.startDate=tempStartDate.getFullYear()+'-'+(tempStartDate.getMonth()+1)+'-'+tempStartDate.getDate();
			//dates.endDate=tempEndDate.getFullYear()+'-'+(tempEndDate.getMonth()+1)+'-'+tempEndDate.getDate();
		}
		if(view.xtype=='griddashlet' || view.xtype=='stackbarchartdashlet'){
			var store= view.getStore();
			var extraparams;
			if(paramObj !=undefined){
				extraparams=paramObj;
			}else{
				extraparams=this$.getParams();	
			}
			
			if(this$.getParams()!=undefined){
				extraparams['intakeYearId']=this$.getParams().intakeYearId;
				extraparams['locationId']=this$.getParams().locationId;
				extraparams['academyId']=this$.getParams().academyId;
				extraparams['programId']=this$.getParams().programId;
				extraparams['batchId']=this$.getParams().batchId;
				extraparams['seatTypeId']=this$.getParams().seatTypeId;
			}
			switch (view.itemId) {
			case 'sourceOfEnquiryItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate
			};
				break;
			case 'bySourceEnquiry':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					acadmyLocationId:extraparams.acadmyLocationId,
					sourceEnqId:extraparams.sourceEnqId
			};
				break;
			case 'viasourceEnquiryItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					allCurrentStatus:extraparams.allCurrentStatus,
					acadmyLocationId:extraparams.acadmyLocationId,
					sourceEnqId:extraparams.sourceEnqId
			};
				break;
			case 'bySourceEnquiryList':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					status:extraparams.status,
					acadmyLocationId:extraparams.acadmyLocationId,
					sourceEnqId:extraparams.sourceEnqId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
			};
				break;
			case 'programGroupEnquiryItemId':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
			};
				break;
			case 'byProgramGroupEnquiry':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					programGroupId:extraparams.programGroupId,
					acadmyLocationId:extraparams.acadmyLocationId,
					status:extraparams.status
			};
				break;
			case  'viaProgramGroupEnquiryItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					programGroupId:extraparams.programGroupId,
					acadmyLocationId:extraparams.acadmyLocationId,
					allCurrentStatus:extraparams.allCurrentStatus
			};
				break;
			case  'byProgramGroupEnquiryList':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					programGroupId:extraparams.programGroupId,
					acadmyLocationId:extraparams.acadmyLocationId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
					status:extraparams.status
			};
				break;
			case 'programCategoryEnquiryItemId':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
			};
				break;
			case 'byProgramCategoryEnquiry':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					programCategoryId:extraparams.programCategoryId,
					status:extraparams.status
			};
				break;
			case 'viaProgramCategoryEnquiryItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					programCategoryId:extraparams.programCategoryId,
					allCurrentStatus:extraparams.allCurrentStatus
			};
				break;
			case 'byProgramCategoryEnquiryList':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					programCategoryId:extraparams.programCategoryId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
					acadmyLocationId:extraparams.acadmyLocationId,
					status:extraparams.status
			};
				break;
			case 'userEnquiryItemId':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
			};
				break;
			case 'byUserEnquiry':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					createdUserId:extraparams.createdUserId,
					acadmyLocationId:extraparams.acadmyLocationId,
					status:extraparams.status
			};
				break;
			case 'viaUsersEnquiryItem':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					createdUserId:extraparams.createdUserId,
					acadmyLocationId:extraparams.acadmyLocationId,
					allCurrentStatus:extraparams.allCurrentStatus
			};
				break;
			case 'byUserEnquiryList':
				store.getProxy().extraParams = {
					startDate:dates.startDate,
					endDate:dates.endDate,
					createdUserId:extraparams.createdUserId,
					program1Id:extraparams.program1Id,
					batch1Id:extraparams.batch1Id,
					acadmyLocationId:extraparams.acadmyLocationId,
					status:extraparams.status
			};
				break;
			}
			this$.resetPageSetting(store);
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(rec.length==0){
						this$.layout.setActiveItem(24);
					}
				}
			});
		}else{
			if(view.xtype=='image'){
				this.layout.setActiveItem(0);
				var view1=this.layout.getActiveItem();
				var store= view1.getStore();
				var extraparams=this$.getParams();
				store.load({params:extraparams,
					callback: function(rec, operation, success) {
						if(rec.length==0){
							this$.layout.setActiveItem(24);
						}
					}
				});
			}
		}

	},
	defaults: {
		cls:'panelNoSpace'
	},
	items:[{
		xtype:'griddashlet',
		itemId:'sourceOfEnquiryItem',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false, 
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_SOURCE_OF_ENQUIRY,
		addPagingToolbar : true,
		columns : [{
			text : getEnquiryTranslation('ACADEMYLOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('SOURCE'),
			dataIndex : 'sourceEnqName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value) && value!='-'){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('OPEN_ENQUIRY'),
			dataIndex : 'openEnquiry',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('SUCCESSFULLY_CLOSED'),
			dataIndex : 'successfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED'),
			dataIndex : 'unsuccessfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('TOTAL_ENQUIRY'),
			dataIndex : 'totalEnquiry',
			sortable : true,			
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 1;
				enquirycountdashlet.addGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.addProgramCategoryEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addProgramGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addUserGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var enquirycountdashlet=enquiryCountGrid.up('enquirycountdashlet');
					if(columnName == 'sourceEnqName'){
						enquirycountdashlet.getLayout().setActiveItem(12);
						var paramsObj={
								sourceEnqId:selectedRecord.data.sourceEnqId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								allCurrentStatus:true
						};
						enquirycountdashlet.params={
								sourceEnqId:selectedRecord.data.sourceEnqId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								allCurrentStatus:true
						};
						enquirycountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'openEnquiry') {
							enquirycountdashlet.getLayout().setActiveItem(8);
							enquirycountdashlet.params={
									sourceEnqId:selectedRecord.data.sourceEnqId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'OPEN'
							};
							var paramsObj={
									sourceEnqId:selectedRecord.data.sourceEnqId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'OPEN'
							};
							enquirycountdashlet.down('#applicantCodeItemId').setVisible(false);
							enquirycountdashlet.down('#enquiryStageItemId').setVisible(true);
							enquirycountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'successfullyClosed'){
								enquirycountdashlet.getLayout().setActiveItem(8);
								enquirycountdashlet.params={
										sourceEnqId:selectedRecord.data.sourceEnqId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'SUCCESSCLOSE'
								};
								var paramsObj={
										sourceEnqId:selectedRecord.data.sourceEnqId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'SUCCESSCLOSE'
								};
								enquirycountdashlet.down('#applicantCodeItemId').setVisible(true);
								enquirycountdashlet.down('#enquiryStageItemId').setVisible(false);
								enquirycountdashlet.loadDashlet(paramsObj);
							}else{
								if(columnName == 'unsuccessfullyClosed'){
									enquirycountdashlet.getLayout().setActiveItem(8);
									enquirycountdashlet.params={
											sourceEnqId:selectedRecord.data.sourceEnqId,
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											status:'UNSUCCESSCLOSE'
									};
									var paramsObj={
											sourceEnqId:selectedRecord.data.sourceEnqId,
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											status:'UNSUCCESSCLOSE'
									};
									enquirycountdashlet.down('#applicantCodeItemId').setVisible(false);
									enquirycountdashlet.down('#enquiryStageItemId').setVisible(false);
									enquirycountdashlet.loadDashlet(paramsObj);
								}
							}
						}
					}
					enquiryCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		itemId:'sourceOfEnquiryItemGraph',
		xAxesNumericField :['openEnquiry','successfullyClosed','unsuccessfullyClosed'],
		yAxesCategoryField : ['acadmySourceKey'],
		titleLegend:[getEnquiryTranslation('OPEN_ENQUIRY'),getEnquiryTranslation('SUCCESSFULLY_CLOSED'),getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED')],
		xAxesNumericTitle :getEnquiryTranslation('TOTAL_NUMBER_OF_ENQUIRY'),
		yAxesCategoryTitle :getEnquiryTranslation('ENQUIRY_SOURCE'),
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_SOURCE_OF_ENQUIRY,
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 0;
				enquirycountdashlet.addGridViewButton(enquirycountdashlet);
				enquirycountdashlet.addProgramCategoryEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addProgramGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addUserGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToPng(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGridViewButton(enquirycountdashlet);
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'programGroupEnquiryItemId',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_GROUP,
		addPagingToolbar : true,
		columns : [{
			text : getEnquiryTranslation('ACADEMYLOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('PROGRAM_GROUP'),
			dataIndex : 'programGroupName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value) && value!='-'){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('OPEN_ENQUIRY'),
			dataIndex : 'openEnquiry',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('SUCCESSFULLY_CLOSED'),
			dataIndex : 'successfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED'),
			dataIndex : 'unsuccessfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('TOTAL_ENQUIRY'),
			dataIndex : 'totalEnquiry',
			sortable : true,			
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 3;
				enquirycountdashlet.addGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.addSourceOfEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addProgramCategoryEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addUserGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var enquirycountdashlet=enquiryCountGrid.up('enquirycountdashlet');
					if(columnName == 'programGroupName'){
						enquirycountdashlet.getLayout().setActiveItem(14);
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								allCurrentStatus:true
						};
						enquirycountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								allCurrentStatus:true
						};
						enquirycountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'openEnquiry') {
							enquirycountdashlet.getLayout().setActiveItem(9);
							enquirycountdashlet.params={
									programGroupId:selectedRecord.data.programGroupId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'OPEN'
							};
							var paramsObj={
									programGroupId:selectedRecord.data.programGroupId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'OPEN'
							};
							enquirycountdashlet.down('#applicantCodeItemId2').setVisible(false);
							enquirycountdashlet.down('#enquiryStageItemId2').setVisible(true);
							enquirycountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'successfullyClosed'){
								enquirycountdashlet.getLayout().setActiveItem(9);
								enquirycountdashlet.params={
										programGroupId:selectedRecord.data.programGroupId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'SUCCESSCLOSE'
								};
								var paramsObj={
										programGroupId:selectedRecord.data.programGroupId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'SUCCESSCLOSE'
								};
								enquirycountdashlet.down('#applicantCodeItemId2').setVisible(true);
								enquirycountdashlet.down('#enquiryStageItemId2').setVisible(false);
								enquirycountdashlet.loadDashlet(paramsObj);
							}else{
								if(columnName == 'unsuccessfullyClosed'){
									enquirycountdashlet.getLayout().setActiveItem(9);
									enquirycountdashlet.params={
											programGroupId:selectedRecord.data.programGroupId,
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											status:'UNSUCCESSCLOSE'
									};
									var paramsObj={
											programGroupId:selectedRecord.data.programGroupId,
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											status:'UNSUCCESSCLOSE'
									};
									enquirycountdashlet.down('#applicantCodeItemId2').setVisible(false);
									enquirycountdashlet.down('#enquiryStageItemId2').setVisible(false);
									enquirycountdashlet.loadDashlet(paramsObj);
								}
							}
						}
					}
					enquiryCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['openEnquiry','successfullyClosed','unsuccessfullyClosed'],
		yAxesCategoryField : ['acadmyProgramGroupkey'],
		titleLegend:[getEnquiryTranslation('OPEN_ENQUIRY'),getEnquiryTranslation('SUCCESSFULLY_CLOSED'),getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED')],
		xAxesNumericTitle :getEnquiryTranslation('TOTAL_NUMBER_OF_ENQUIRY'),
		yAxesCategoryTitle :getEnquiryTranslation('ENQUIRY_SOURCE'),
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_GROUP,
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 2;
				enquirycountdashlet.addGridViewButton(enquirycountdashlet);
				enquirycountdashlet.addSourceOfEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addProgramCategoryEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addUserGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToPng(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGridViewButton(enquirycountdashlet);
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'programCategoryEnquiryItemId',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_CATEOGRY,
		addPagingToolbar : true,
		columns : [{
			text : getEnquiryTranslation('PROGRAM_CATEGORY'),
			dataIndex : 'programCategoryName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value) && value!='-'){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('OPEN_ENQUIRY'),
			dataIndex : 'openEnquiry',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('SUCCESSFULLY_CLOSED'),
			dataIndex : 'successfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED'),
			dataIndex : 'unsuccessfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('TOTAL_ENQUIRY'),
			dataIndex : 'totalEnquiry',
			sortable : true,			
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 5;
				enquirycountdashlet.addGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.addProgramGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addSourceOfEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addUserGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var enquirycountdashlet=enquiryCountGrid.up('enquirycountdashlet');
					if(columnName == 'programCategoryName'){
						enquirycountdashlet.getLayout().setActiveItem(16);
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								allCurrentStatus:true
						};
						enquirycountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								allCurrentStatus:true
						};
						enquirycountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'openEnquiry') {
							enquirycountdashlet.getLayout().setActiveItem(10);
							enquirycountdashlet.params={
									programCategoryId:selectedRecord.data.programCategoryId,
									status:'OPEN'
							};
							var paramsObj={
									programCategoryId:selectedRecord.data.programCategoryId,
									status:'OPEN'
							};
							enquirycountdashlet.down('#applicantCodeItemId3').setVisible(false);
							enquirycountdashlet.down('#enquiryStageItemId3').setVisible(true);
							enquirycountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'successfullyClosed'){
								enquirycountdashlet.getLayout().setActiveItem(10);
								enquirycountdashlet.params={
										programCategoryId:selectedRecord.data.programCategoryId,
										status:'SUCCESSCLOSE'
								};
								var paramsObj={
										programCategoryId:selectedRecord.data.programCategoryId,
										status:'SUCCESSCLOSE'
								};
								enquirycountdashlet.down('#applicantCodeItemId3').setVisible(true);
								enquirycountdashlet.down('#enquiryStageItemId3').setVisible(false);
								enquirycountdashlet.loadDashlet(paramsObj);
							}else{
								if(columnName == 'unsuccessfullyClosed'){
									enquirycountdashlet.getLayout().setActiveItem(10);
									enquirycountdashlet.params={
											programCategoryId:selectedRecord.data.programCategoryId,
											status:'UNSUCCESSCLOSE'
									};
									var paramsObj={
											programCategoryId:selectedRecord.data.programCategoryId,
											status:'UNSUCCESSCLOSE'
									};
									enquirycountdashlet.down('#applicantCodeItemId3').setVisible(false);
									enquirycountdashlet.down('#enquiryStageItemId3').setVisible(false);
									enquirycountdashlet.loadDashlet(paramsObj);
								}
							}
						}
					}
					enquiryCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['openEnquiry','successfullyClosed','unsuccessfullyClosed'],
		yAxesCategoryField : ['programCategoryName'],
		titleLegend:[getEnquiryTranslation('OPEN_ENQUIRY'),getEnquiryTranslation('SUCCESSFULLY_CLOSED'),getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED')],
		xAxesNumericTitle :getEnquiryTranslation('TOTAL_NUMBER_OF_ENQUIRY'),
		yAxesCategoryTitle :getEnquiryTranslation('ENQUIRY_SOURCE'),
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_CATEOGRY,
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 4;
				enquirycountdashlet.addGridViewButton(enquirycountdashlet);
				enquirycountdashlet.addProgramGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addSourceOfEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addUserGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToPng(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGridViewButton(enquirycountdashlet);
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'userEnquiryItemId',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_USERS,
		addPagingToolbar : true,
		columns : [{
			text : getEnquiryTranslation('ACADEMYLOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('USERS_OWNERS'),
			dataIndex : 'createdUserName',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value) && value!='-'){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('OPEN_ENQUIRY'),
			dataIndex : 'openEnquiry',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('SUCCESSFULLY_CLOSED'),
			dataIndex : 'successfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED'),
			dataIndex : 'unsuccessfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('TOTAL_ENQUIRY'),
			dataIndex : 'totalEnquiry',
			sortable : true,			
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 7;
				enquirycountdashlet.addGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.addProgramGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addSourceOfEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addProgramCategoryEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var enquirycountdashlet=enquiryCountGrid.up('enquirycountdashlet');
					if(columnName == 'createdUserName'){
						enquirycountdashlet.getLayout().setActiveItem(18);
						var paramsObj={
								createdUserId:selectedRecord.data.createdUserId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								allCurrentStatus:true
						};
						enquirycountdashlet.params={
								createdUserId:selectedRecord.data.createdUserId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								allCurrentStatus:true
						};
						enquirycountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'openEnquiry') {
							enquirycountdashlet.getLayout().setActiveItem(11);
							enquirycountdashlet.params={
									createdUserId:selectedRecord.data.createdUserId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'OPEN'
							};
							var paramsObj={
									createdUserId:selectedRecord.data.createdUserId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'OPEN'
							};
							enquirycountdashlet.down('#applicantCodeItemId4').setVisible(false);
							enquirycountdashlet.down('#enquiryStageItemId4').setVisible(true);
							enquirycountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'successfullyClosed'){
								enquirycountdashlet.getLayout().setActiveItem(11);
								enquirycountdashlet.params={
										createdUserId:selectedRecord.data.createdUserId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'SUCCESSCLOSE'
								};
								var paramsObj={
										createdUserId:selectedRecord.data.createdUserId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'SUCCESSCLOSE'
								};
								enquirycountdashlet.down('#applicantCodeItemId4').setVisible(true);
								enquirycountdashlet.down('#enquiryStageItemId4').setVisible(false);
								enquirycountdashlet.loadDashlet(paramsObj);
							}else{
								if(columnName == 'unsuccessfullyClosed'){
									enquirycountdashlet.getLayout().setActiveItem(11);
									enquirycountdashlet.params={
											createdUserId:selectedRecord.data.createdUserId,
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											status:'UNSUCCESSCLOSE'
									};
									var paramsObj={
											createdUserId:selectedRecord.data.createdUserId,
											acadmyLocationId:selectedRecord.data.acadmyLocationId,
											status:'UNSUCCESSCLOSE'
									};
									enquirycountdashlet.down('#applicantCodeItemId4').setVisible(false);
									enquirycountdashlet.down('#enquiryStageItemId4').setVisible(false);
									enquirycountdashlet.loadDashlet(paramsObj);
								}
							}
						}
					}
					enquiryCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['openEnquiry','successfullyClosed','unsuccessfullyClosed'],
		yAxesCategoryField : ['acadmyUserKey'],
		titleLegend:[getEnquiryTranslation('OPEN_ENQUIRY'),getEnquiryTranslation('SUCCESSFULLY_CLOSED'),getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED')],
		xAxesNumericTitle :getEnquiryTranslation('TOTAL_NUMBER_OF_ENQUIRY'),
		yAxesCategoryTitle :getEnquiryTranslation('ENQUIRY_SOURCE'),
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_USERS,
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 6;
				enquirycountdashlet.addGridViewButton(enquirycountdashlet);
				enquirycountdashlet.addProgramGroupEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addSourceOfEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addProgramCategoryEnquiry(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToPng(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGridViewButton(enquirycountdashlet);
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'bySourceEnquiry',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_LIST,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'enqId'
		}, */{
			text : getEnquiryTranslation('ENQUIRY_ID'),
			dataIndex : 'enqCode',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_DATE'),
			dataIndex : 'enquiryDate',
			sortable : true,
			flex:0.1,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			text : getEnquiryTranslation('ENQUIRER_NAME'),
			dataIndex : 'enquirerName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			flex:0.1,
			renderer: function(value) {
				return value=getEnquiryTranslation(value);
			}
		},{
			text : getEnquiryTranslation('ADDRESS_MOBILE_NO'),
			dataIndex : 'mobileCountryCodeContactNo',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_OWNER'),
			dataIndex : 'enqOwner',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('SOURCE'),
			dataIndex : 'sourceEnqName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_STAGE'),
			dataIndex : 'enquiryStage',
			itemId:'enquiryStageItemId',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('APPLICANT_ID'),
			dataIndex : 'applicantCode',
			itemId:'applicantCodeItemId',
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			sortable : true,
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 8;
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
				enquirycountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(0);
						header.remove(tool);
						enquirycountdashlet.params={};
						// reset the page param after going previous page
						var itemStore = enquirycountdashlet.items.get(2).getStore();
						itemStore.currentPage = 1;
						enquirycountdashlet.loadDashlet();
					}
				}));
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				var $this=this;
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
					if(columnName=='enqCode'){
						var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
						trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryCountGrid,'Edit');
					}else{
						if(columnName=='applicantCode'){
							var applicantId = record.get('applicantId'); 
							enquiryController.openApplicantProfileFromDashlet(applicantId, true,enquiryCountGrid,record);

						}
					}
					if(this.up('dashboardhomepage') == undefined){
						enquiryCountGrid.up().up().up().close();
					}
				}
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'byProgramGroupEnquiry',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_LIST,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'enqId'
		}, */{
			text : getEnquiryTranslation('ENQUIRY_ID'),
			dataIndex : 'enqCode',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_DATE'),
			dataIndex : 'enquiryDate',
			sortable : true,
			flex:0.1,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			text : getEnquiryTranslation('ENQUIRER_NAME'),
			dataIndex : 'enquirerName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			flex:0.1,
			renderer: function(value) {
				return value=getEnquiryTranslation(value);
			}
		},{
			text : getEnquiryTranslation('ADDRESS_MOBILE_NO'),
			dataIndex : 'mobileCountryCodeContactNo',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_OWNER'),
			dataIndex : 'enqOwner',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('SOURCE'),
			dataIndex : 'sourceEnqName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_STAGE'),
			dataIndex : 'enquiryStage',
			itemId:'enquiryStageItemId2',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('APPLICANT_ID'),
			dataIndex : 'applicantCode',
			itemId:'applicantCodeItemId2',
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			sortable : true,
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 9;
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
				enquirycountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(2);
						header.remove(tool);
						enquirycountdashlet.params={};
						// reset the page param after going previous page
						var itemStore = enquirycountdashlet.items.get(2).getStore();
						itemStore.currentPage = 1;
						enquirycountdashlet.loadDashlet();
					}
				}));
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				var $this=this;
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
					if(columnName=='enqCode'){
						var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
						trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryCountGrid,'Edit');
					}else{
						if(columnName=='applicantCode'){
							var applicantId = record.get('applicantId'); 
							enquiryController.openApplicantProfileFromDashlet(applicantId, true,enquiryCountGrid,record);

						}
					}
					if(this.up('dashboardhomepage') == undefined){
						enquiryCountGrid.up().up().up().close();
					}
				}
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'byProgramCategoryEnquiry',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_LIST,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'enqId'
		}, */{
			text : getEnquiryTranslation('ENQUIRY_ID'),
			dataIndex : 'enqCode',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_DATE'),
			dataIndex : 'enquiryDate',
			sortable : true,
			flex:0.1,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			text : getEnquiryTranslation('ENQUIRER_NAME'),
			dataIndex : 'enquirerName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			flex:0.1,
			renderer: function(value) {
				return value=getEnquiryTranslation(value);
			}
		},{
			text : getEnquiryTranslation('ADDRESS_MOBILE_NO'),
			dataIndex : 'mobileCountryCodeContactNo',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_OWNER'),
			dataIndex : 'enqOwner',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('SOURCE'),
			dataIndex : 'sourceEnqName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_STAGE'),
			dataIndex : 'enquiryStage',
			itemId:'enquiryStageItemId3',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('APPLICANT_ID'),
			dataIndex : 'applicantCode',
			itemId:'applicantCodeItemId3',
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			sortable : true,
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 10;
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
				enquirycountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(4);
						header.remove(tool);
						enquirycountdashlet.params={};
						// reset the page param after going previous page
						var itemStore = enquirycountdashlet.items.get(2).getStore();
						itemStore.currentPage = 1;
						enquirycountdashlet.loadDashlet();
					}
				}));
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				var $this=this;
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
					if(columnName=='enqCode'){
						var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
						trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryCountGrid,'Edit');
					}else{
						if(columnName=='applicantCode'){
							var applicantId = record.get('applicantId'); 
							enquiryController.openApplicantProfileFromDashlet(applicantId, true,enquiryCountGrid,record);

						}
					}
					if(this.up('dashboardhomepage') == undefined){
						enquiryCountGrid.up().up().up().close();
					}
				}
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'byUserEnquiry',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_LIST,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'enqId'
		}, */{
			text : getEnquiryTranslation('ENQUIRY_ID'),
			dataIndex : 'enqCode',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_DATE'),
			dataIndex : 'enquiryDate',
			sortable : true,
			flex:0.1,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			text : getEnquiryTranslation('ENQUIRER_NAME'),
			dataIndex : 'enquirerName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			flex:0.1,
			renderer: function(value) {
				return value=getEnquiryTranslation(value);
			}
		},{
			text : getEnquiryTranslation('ADDRESS_MOBILE_NO'),
			dataIndex : 'mobileCountryCodeContactNo',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_OWNER'),
			dataIndex : 'enqOwner',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('SOURCE'),
			dataIndex : 'sourceEnqName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_STAGE'),
			dataIndex : 'enquiryStage',
			itemId:'enquiryStageItemId4',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('APPLICANT_ID'),
			dataIndex : 'applicantCode',
			itemId:'applicantCodeItemId4',
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			sortable : true,
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 11;
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
				enquirycountdashlet.addTool(Ext.create('Ext.panel.Tool',{
					type: 'prev',
					handler: function(btn, target, header, tool){
						header.ownerCt.getLayout().setActiveItem(6);
						header.remove(tool);
						enquirycountdashlet.params={};
						// reset the page param after going previous page
						var itemStore = enquirycountdashlet.items.get(2).getStore();
						itemStore.currentPage = 1;
						enquirycountdashlet.loadDashlet();
					}
				}));
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				var $this=this;
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
					if(columnName=='enqCode'){
						var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
						trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryCountGrid,'Edit');
					}else{
						if(columnName=='applicantCode'){
							var applicantId = record.get('applicantId'); 
							enquiryController.openApplicantProfileFromDashlet(applicantId, true,enquiryCountGrid,record);

						}
					}
					if(this.up('dashboardhomepage') == undefined){
						enquiryCountGrid.up().up().up().close();
					}
				}
			}
		}

	},{
		xtype:'griddashlet',
		itemId:'viasourceEnquiryItem',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_BATCH,
		addPagingToolbar : true,
		columns : [{
			text : getEnquiryTranslation('ACADEMYLOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('OPEN_ENQUIRY'),
			dataIndex : 'openEnquiry',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('SUCCESSFULLY_CLOSED'),
			dataIndex : 'successfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED'),
			dataIndex : 'unsuccessfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('TOTAL_ENQUIRY'),
			dataIndex : 'totalEnquiry',
			sortable : true,			
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				var tabCheck=enquirycountdashlet.activeTab;
				enquirycountdashlet.activeTab = 13;
				enquirycountdashlet.addGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
				if(tabCheck != 12){
					enquirycountdashlet.addTool(Ext.create('Ext.panel.Tool',{
						type: 'prev',
						itemId:'sourceLevel',
						handler: function(btn, target, header, tool){
							header.remove(tool);
							if(enquirycountdashlet.activeTab==20){
								var sourceId=enquirycountdashlet.params.sourceEnqId;
								var acadmyId=enquirycountdashlet.params.acadmyLocationId;
								header.ownerCt.getLayout().setActiveItem(12);
								enquirycountdashlet.params={
										sourceEnqId:sourceId,
										acadmyLocationId:acadmyId,
										allCurrentStatus:true
								};
							}else{
								header.ownerCt.getLayout().setActiveItem(0);
								header.remove(tool);
								//enquirycountdashlet.doLayout();
							}
							// reset the page param after going previous page
							var itemStore = enquirycountdashlet.items.get(2).getStore();
							itemStore.currentPage = 1;
							enquirycountdashlet.loadDashlet();
						}
					}));}
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();

			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var enquirycountdashlet=enquiryCountGrid.up('enquirycountdashlet');
					if(columnName == 'openEnquiry') {
						enquirycountdashlet.getLayout().setActiveItem(20);
						enquirycountdashlet.params={
								sourceEnqId:selectedRecord.data.sourceEnqId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'OPEN'
						};
						var paramsObj={
								sourceEnqId:selectedRecord.data.sourceEnqId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'OPEN'
						};
						enquirycountdashlet.down('#applicantCodeItemId5').setVisible(false);
						enquirycountdashlet.down('#enquiryStageItemId5').setVisible(true);
						enquirycountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'successfullyClosed'){
							enquirycountdashlet.getLayout().setActiveItem(20);
							enquirycountdashlet.params={
									sourceEnqId:selectedRecord.data.sourceEnqId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'SUCCESSCLOSE'
							};
							var paramsObj={
									sourceEnqId:selectedRecord.data.sourceEnqId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'SUCCESSCLOSE'
							};
							enquirycountdashlet.down('#applicantCodeItemId5').setVisible(true);
							enquirycountdashlet.down('#enquiryStageItemId5').setVisible(false);
							enquirycountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'unsuccessfullyClosed'){
								enquirycountdashlet.getLayout().setActiveItem(20);
								enquirycountdashlet.params={
										sourceEnqId:selectedRecord.data.sourceEnqId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'UNSUCCESSCLOSE'
								};
								var paramsObj={
										sourceEnqId:selectedRecord.data.sourceEnqId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'UNSUCCESSCLOSE'
								};
								enquirycountdashlet.down('#applicantCodeItemId5').setVisible(false);
								enquirycountdashlet.down('#enquiryStageItemId5').setVisible(false);
								enquirycountdashlet.loadDashlet(paramsObj);
							}
						}
					}
					enquiryCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		itemId:'viasourceEnquiryItemGraph',
		xAxesNumericField :['openEnquiry','successfullyClosed','unsuccessfullyClosed'],
		yAxesCategoryField : ['acadmyProgramBatchKey'],
		titleLegend:[getEnquiryTranslation('OPEN_ENQUIRY'),getEnquiryTranslation('SUCCESSFULLY_CLOSED'),getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED')],
		xAxesNumericTitle :getEnquiryTranslation('TOTAL_NUMBER_OF_ENQUIRY'),
		yAxesCategoryTitle :getEnquiryTranslation('ENQUIRY_SOURCE'),
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_BATCH,
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				var sourceEnqId=enquirycountdashlet.params.sourceEnqId;
				var acdmyId=enquirycountdashlet.params.acadmyLocationId;
				enquirycountdashlet.activeTab = 12;
				enquirycountdashlet.addGridViewButton(enquirycountdashlet);
				var store=enquirycountdashlet.getLayout().getActiveItem().getStore();
				store.getProxy().extraParams = {
					sourceEnqId:sourceEnqId,
					acadmyLocationId:acdmyId,
					allCurrentStatus:true
				};
				enquirycountdashlet.addExportToPng(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGridViewButton(enquirycountdashlet);
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'viaProgramGroupEnquiryItem',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_BATCH,
		addPagingToolbar : true,
		columns : [{
			text : getEnquiryTranslation('ACADEMYLOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('OPEN_ENQUIRY'),
			dataIndex : 'openEnquiry',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('SUCCESSFULLY_CLOSED'),
			dataIndex : 'successfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED'),
			dataIndex : 'unsuccessfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('TOTAL_ENQUIRY'),
			dataIndex : 'totalEnquiry',
			sortable : true,			
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				var tabCheck=enquirycountdashlet.activeTab;
				enquirycountdashlet.activeTab = 15;
				enquirycountdashlet.addGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
				if(tabCheck != 14){
					enquirycountdashlet.addTool(Ext.create('Ext.panel.Tool',{
						type: 'prev',
						itemId:'programGroupLevel',
						handler: function(btn, target, header, tool){
							header.remove(tool);
							if(enquirycountdashlet.activeTab==21){
								var pgId=enquirycountdashlet.params.programGroupId;
								var acadmyId=enquirycountdashlet.params.acadmyLocationId;
								header.ownerCt.getLayout().setActiveItem(14);
								enquirycountdashlet.params={
										programGroupId:pgId,
										acadmyLocationId:acadmyId,
										allCurrentStatus:true
								};
							}else{
								header.ownerCt.getLayout().setActiveItem(2);
								header.remove(tool);
								enquirycountdashlet.doLayout();
							}
							//enquirycountdashlet.params={};
							// reset the page param after going previous page
							var itemStore = enquirycountdashlet.items.get(2).getStore();
							itemStore.currentPage = 1;
							enquirycountdashlet.loadDashlet();
						}
					}));}
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var enquirycountdashlet=enquiryCountGrid.up('enquirycountdashlet');
					if(columnName == 'openEnquiry') {
						enquirycountdashlet.getLayout().setActiveItem(21);
						enquirycountdashlet.params={
								programGroupId:selectedRecord.data.programGroupId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'OPEN'
						};
						var paramsObj={
								programGroupId:selectedRecord.data.programGroupId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'OPEN'
						};
						enquirycountdashlet.down('#applicantCodeItemId6').setVisible(false);
						enquirycountdashlet.down('#enquiryStageItemId6').setVisible(true);
						enquirycountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'successfullyClosed'){
							enquirycountdashlet.getLayout().setActiveItem(21);
							enquirycountdashlet.params={
									programGroupId:selectedRecord.data.programGroupId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'SUCCESSCLOSE'
							};
							var paramsObj={
									programGroupId:selectedRecord.data.programGroupId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'SUCCESSCLOSE'
							};
							enquirycountdashlet.down('#applicantCodeItemId6').setVisible(true);
							enquirycountdashlet.down('#enquiryStageItemId6').setVisible(false);
							enquirycountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'unsuccessfullyClosed'){
								enquirycountdashlet.getLayout().setActiveItem(21);
								enquirycountdashlet.params={
										programGroupId:selectedRecord.data.programGroupId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'UNSUCCESSCLOSE'
								};
								var paramsObj={
										programGroupId:selectedRecord.data.programGroupId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'UNSUCCESSCLOSE'
								};
								enquirycountdashlet.down('#applicantCodeItemId6').setVisible(false);
								enquirycountdashlet.down('#enquiryStageItemId6').setVisible(false);
								enquirycountdashlet.loadDashlet(paramsObj);
							}
						}
					}
					enquiryCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['openEnquiry','successfullyClosed','unsuccessfullyClosed'],
		yAxesCategoryField : ['acadmyProgramBatchKey'],
		titleLegend:[getEnquiryTranslation('OPEN_ENQUIRY'),getEnquiryTranslation('SUCCESSFULLY_CLOSED'),getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED')],
		xAxesNumericTitle :getEnquiryTranslation('TOTAL_NUMBER_OF_ENQUIRY'),
		yAxesCategoryTitle :getEnquiryTranslation('ENQUIRY_SOURCE'),
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_BATCH,
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				var programGroupId=enquirycountdashlet.params.programGroupId;
				var acdmyId=enquirycountdashlet.params.acadmyLocationId;
				enquirycountdashlet.activeTab = 14;
				var store=enquirycountdashlet.getLayout().getActiveItem().getStore();
				store.getProxy().extraParams = {
					programGroupId:programGroupId,
					acadmyLocationId:acdmyId,
					allCurrentStatus:true
				};
				enquirycountdashlet.addGridViewButton(enquirycountdashlet);
				enquirycountdashlet.addExportToPng(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGridViewButton(enquirycountdashlet);
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'viaProgramCategoryEnquiryItem',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_BATCH,
		addPagingToolbar : true,
		columns : [{
			text : getEnquiryTranslation('ACADEMYLOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('OPEN_ENQUIRY'),
			dataIndex : 'openEnquiry',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('SUCCESSFULLY_CLOSED'),
			dataIndex : 'successfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED'),
			dataIndex : 'unsuccessfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('TOTAL_ENQUIRY'),
			dataIndex : 'totalEnquiry',
			sortable : true,			
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				var tabCheck=enquirycountdashlet.activeTab;
				enquirycountdashlet.activeTab = 17;
				enquirycountdashlet.addGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
				if(tabCheck !=16){
					enquirycountdashlet.addTool(Ext.create('Ext.panel.Tool',{
						type: 'prev',
						itemId:'categoryLevel',
						handler: function(btn, target, header, tool){
							header.remove(tool);
							if(enquirycountdashlet.activeTab==22){
								var cgId=enquirycountdashlet.params.programCategoryId;
								header.ownerCt.getLayout().setActiveItem(16);
								enquirycountdashlet.params={
										programCategoryId:cgId,
										allCurrentStatus:true
								};
							}else{
								header.ownerCt.getLayout().setActiveItem(4);
								header.remove(tool);
								enquirycountdashlet.doLayout();
							}
							// reset the page param after going previous page
							var itemStore = enquirycountdashlet.items.get(2).getStore();
							itemStore.currentPage = 1;
							enquirycountdashlet.loadDashlet();
						}
					}));}
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var enquirycountdashlet=enquiryCountGrid.up('enquirycountdashlet');
					if(columnName == 'openEnquiry') {
						enquirycountdashlet.getLayout().setActiveItem(22);
						enquirycountdashlet.params={
								programCategoryId:selectedRecord.data.programCategoryId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'OPEN'
						};
						var paramsObj={
								programCategoryId:selectedRecord.data.programCategoryId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'OPEN'
						};
						enquirycountdashlet.down('#applicantCodeItemId7').setVisible(false);
						enquirycountdashlet.down('#enquiryStageItemId7').setVisible(true);
						enquirycountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'successfullyClosed'){
							enquirycountdashlet.getLayout().setActiveItem(22);
							enquirycountdashlet.params={
									programCategoryId:selectedRecord.data.programCategoryId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'SUCCESSCLOSE'
							};
							var paramsObj={
									programCategoryId:selectedRecord.data.programCategoryId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'SUCCESSCLOSE'
							};
							enquirycountdashlet.down('#applicantCodeItemId7').setVisible(true);
							enquirycountdashlet.down('#enquiryStageItemId7').setVisible(false);
							enquirycountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'unsuccessfullyClosed'){
								enquirycountdashlet.getLayout().setActiveItem(22);
								enquirycountdashlet.params={
										programCategoryId:selectedRecord.data.programCategoryId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'UNSUCCESSCLOSE'
								};
								var paramsObj={
										programCategoryId:selectedRecord.data.programCategoryId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'UNSUCCESSCLOSE'
								};
								enquirycountdashlet.down('#applicantCodeItemId7').setVisible(false);
								enquirycountdashlet.down('#enquiryStageItemId7').setVisible(false);
								enquirycountdashlet.loadDashlet(paramsObj);
							}
						}
					}
					enquiryCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['openEnquiry','successfullyClosed','unsuccessfullyClosed'],
		yAxesCategoryField : ['acadmyProgramBatchKey'],
		titleLegend:[getEnquiryTranslation('OPEN_ENQUIRY'),getEnquiryTranslation('SUCCESSFULLY_CLOSED'),getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED')],
		xAxesNumericTitle :getEnquiryTranslation('TOTAL_NUMBER_OF_ENQUIRY'),
		yAxesCategoryTitle :getEnquiryTranslation('ENQUIRY_SOURCE'),
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_BATCH,
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				var programCategoryId=enquirycountdashlet.params.programCategoryId;
				var acdmyId=enquirycountdashlet.params.acadmyLocationId;
				enquirycountdashlet.activeTab = 16;
				var store=enquirycountdashlet.getLayout().getActiveItem().getStore();
				store.getProxy().extraParams = {
					programCategoryId:programCategoryId,
					acadmyLocationId:acdmyId,
					allCurrentStatus:true
				};

				enquirycountdashlet.addGridViewButton(enquirycountdashlet);
				enquirycountdashlet.addExportToPng(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGridViewButton(enquirycountdashlet);
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'viaUsersEnquiryItem',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_BATCH,
		addPagingToolbar : true,
		columns : [{
			text : getEnquiryTranslation('ACADEMYLOCATION'),
			dataIndex : 'academyLocationName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('PROGRAM'),
			dataIndex : 'programName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('BATCH'),
			dataIndex : 'batchName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('OPEN_ENQUIRY'),
			dataIndex : 'openEnquiry',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('SUCCESSFULLY_CLOSED'),
			dataIndex : 'successfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED'),
			dataIndex : 'unsuccessfullyClosed',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('TOTAL_ENQUIRY'),
			dataIndex : 'totalEnquiry',
			sortable : true,			
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				var tabCheck=enquirycountdashlet.activeTab;
				enquirycountdashlet.activeTab = 19;
				enquirycountdashlet.addGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
				if(tabCheck !=18){
					enquirycountdashlet.addTool(Ext.create('Ext.panel.Tool',{
						type: 'prev',
						itemId:'userLevel',
						handler: function(btn, target, header, tool){
							header.remove(tool);
							if(enquirycountdashlet.activeTab==23){
								var creatuserId=enquirycountdashlet.params.createdUserId;
								var acadmyId=enquirycountdashlet.params.acadmyLocationId;
								header.ownerCt.getLayout().setActiveItem(18);
								enquirycountdashlet.params={
										createdUserId:creatuserId,
										acadmyLocationId:acadmyId,
										allCurrentStatus:true
								};
							}else{
								header.ownerCt.getLayout().setActiveItem(6);
								header.remove(tool);
								enquirycountdashlet.doLayout();
							}
							// reset the page param after going previous page
							var itemStore = enquirycountdashlet.items.get(2).getStore();
							itemStore.currentPage = 1;
							enquirycountdashlet.loadDashlet();
						}
					}));}
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var enquirycountdashlet=enquiryCountGrid.up('enquirycountdashlet');
					if(columnName == 'openEnquiry') {
						enquirycountdashlet.getLayout().setActiveItem(23);
						enquirycountdashlet.params={
								createdUserId:selectedRecord.data.createdUserId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'OPEN'
						};
						var paramsObj={
								createdUserId:selectedRecord.data.createdUserId,
								program1Id:selectedRecord.data.programId,
								batch1Id:selectedRecord.data.batchId,
								acadmyLocationId:selectedRecord.data.acadmyLocationId,
								status:'OPEN'
						};
						enquirycountdashlet.down('#applicantCodeItemId8').setVisible(false);
						enquirycountdashlet.down('#enquiryStageItemId8').setVisible(true);
						enquirycountdashlet.loadDashlet(paramsObj);
					}else{
						if(columnName == 'successfullyClosed'){
							enquirycountdashlet.getLayout().setActiveItem(23);
							enquirycountdashlet.params={
									createdUserId:selectedRecord.data.createdUserId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'SUCCESSCLOSE'
							};
							var paramsObj={
									createdUserId:selectedRecord.data.createdUserId,
									program1Id:selectedRecord.data.programId,
									batch1Id:selectedRecord.data.batchId,
									acadmyLocationId:selectedRecord.data.acadmyLocationId,
									status:'SUCCESSCLOSE'
							};
							enquirycountdashlet.down('#applicantCodeItemId8').setVisible(true);
							enquirycountdashlet.down('#enquiryStageItemId8').setVisible(false);
							enquirycountdashlet.loadDashlet(paramsObj);
						}else{
							if(columnName == 'unsuccessfullyClosed'){
								enquirycountdashlet.getLayout().setActiveItem(23);
								enquirycountdashlet.params={
										createdUserId:selectedRecord.data.createdUserId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'UNSUCCESSCLOSE'
								};
								var paramsObj={
										createdUserId:selectedRecord.data.createdUserId,
										program1Id:selectedRecord.data.programId,
										batch1Id:selectedRecord.data.batchId,
										acadmyLocationId:selectedRecord.data.acadmyLocationId,
										status:'UNSUCCESSCLOSE'
								};
								enquirycountdashlet.down('#applicantCodeItemId8').setVisible(false);
								enquirycountdashlet.down('#enquiryStageItemId8').setVisible(false);
								enquirycountdashlet.loadDashlet(paramsObj);
							}
						}
					}
					enquiryCountGrid.getSelectionModel().deselectAll();
				}
			}
		}
	},{
		xtype:'stackbarchartdashlet',
		xAxesNumericField :['openEnquiry','successfullyClosed','unsuccessfullyClosed'],
		yAxesCategoryField : ['acadmyProgramBatchKey'],
		titleLegend:[getEnquiryTranslation('OPEN_ENQUIRY'),getEnquiryTranslation('SUCCESSFULLY_CLOSED'),getEnquiryTranslation('UN_SUCCESSFULLY_CLOSED')],
		xAxesNumericTitle :getEnquiryTranslation('TOTAL_NUMBER_OF_ENQUIRY'),
		yAxesCategoryTitle :getEnquiryTranslation('ENQUIRY_SOURCE'),
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_BY_PROGRAM_BATCH,
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				var createdUserId=enquirycountdashlet.params.createdUserId;
				var acdmyId=enquirycountdashlet.params.acadmyLocationId;
				enquirycountdashlet.activeTab = 18;
				var store=enquirycountdashlet.getLayout().getActiveItem().getStore();
				store.getProxy().extraParams = {
					createdUserId:createdUserId,
					acadmyLocationId:acdmyId,
					allCurrentStatus:true
				};
				enquirycountdashlet.addGridViewButton(enquirycountdashlet);
				enquirycountdashlet.addExportToPng(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGridViewButton(enquirycountdashlet);
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeProgramCategoryEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeExportToPng();
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'bySourceEnquiryList',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_LIST,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'enqId'
		},*/ {
			text : getEnquiryTranslation('ENQUIRY_ID'),
			dataIndex : 'enqCode',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_DATE'),
			dataIndex : 'enquiryDate',
			sortable : true,
			flex:0.1,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			text : getEnquiryTranslation('ENQUIRER_NAME'),
			dataIndex : 'enquirerName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			flex:0.1,
			renderer: function(value) {
				return value=getEnquiryTranslation(value);
			}
		},{
			text : getEnquiryTranslation('ADDRESS_MOBILE_NO'),
			dataIndex : 'mobileCountryCodeContactNo',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_OWNER'),
			dataIndex : 'enqOwner',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('SOURCE'),
			dataIndex : 'sourceEnqName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_STAGE'),
			dataIndex : 'enquiryStage',
			itemId:'enquiryStageItemId5',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('APPLICANT_ID'),
			dataIndex : 'applicantCode',
			itemId:'applicantCodeItemId5',
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			sortable : true,
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 20;
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				var $this=this;
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
					if(columnName=='enqCode'){
						var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
						trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryCountGrid,'Edit');
					}else{
						if(columnName=='applicantCode'){
							var applicantId = record.get('applicantId'); 
							enquiryController.openApplicantProfileFromDashlet(applicantId, true,enquiryCountGrid,record);

						}
					}
					if(this.up('dashboardhomepage') == undefined){
						enquiryCountGrid.up().up().up().close();
					}
				}
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'byProgramGroupEnquiryList',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_LIST,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'enqId'
		}, */{
			text : getEnquiryTranslation('ENQUIRY_ID'),
			dataIndex : 'enqCode',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_DATE'),
			dataIndex : 'enquiryDate',
			sortable : true,
			flex:0.1,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			text : getEnquiryTranslation('ENQUIRER_NAME'),
			dataIndex : 'enquirerName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			flex:0.1,
			renderer: function(value) {
				return value=getEnquiryTranslation(value);
			}
		},{
			text : getEnquiryTranslation('ADDRESS_MOBILE_NO'),
			dataIndex : 'mobileCountryCodeContactNo',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_OWNER'),
			dataIndex : 'enqOwner',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('SOURCE'),
			dataIndex : 'sourceEnqName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_STAGE'),
			dataIndex : 'enquiryStage',
			itemId:'enquiryStageItemId6',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('APPLICANT_ID'),
			dataIndex : 'applicantCode',
			itemId:'applicantCodeItemId6',
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			sortable : true,
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 21;
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				var $this=this;
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
					if(columnName=='enqCode'){
						var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
						trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryCountGrid,'Edit');
					}else{
						if(columnName=='applicantCode'){
							var applicantId = record.get('applicantId'); 
							enquiryController.openApplicantProfileFromDashlet(applicantId, true,enquiryCountGrid,record);

						}
					}
					if(this.up('dashboardhomepage') == undefined){
						enquiryCountGrid.up().up().up().close();
					}
				}
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'byProgramCategoryEnquiryList',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_LIST,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'enqId'
		},*/ {
			text : getEnquiryTranslation('ENQUIRY_ID'),
			dataIndex : 'enqCode',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_DATE'),
			dataIndex : 'enquiryDate',
			sortable : true,
			flex:0.1,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			text : getEnquiryTranslation('ENQUIRER_NAME'),
			dataIndex : 'enquirerName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			flex:0.1,
			renderer: function(value) {
				return value=getEnquiryTranslation(value);
			}
		},{
			text : getEnquiryTranslation('ADDRESS_MOBILE_NO'),
			dataIndex : 'mobileCountryCodeContactNo',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_OWNER'),
			dataIndex : 'enqOwner',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('SOURCE'),
			dataIndex : 'sourceEnqName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_STAGE'),
			dataIndex : 'enquiryStage',
			itemId:'enquiryStageItemId7',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('APPLICANT_ID'),
			dataIndex : 'applicantCode',
			itemId:'applicantCodeItemId7',
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			sortable : true,
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 22;
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				var $this=this;
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
					if(columnName=='enqCode'){
						var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
						trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryCountGrid,'Edit');
					}else{
						if(columnName=='applicantCode'){
							var applicantId = record.get('applicantId'); 
							enquiryController.openApplicantProfileFromDashlet(applicantId, true,enquiryCountGrid,record);

						}
					}
					if(this.up('dashboardhomepage') == undefined){
						enquiryCountGrid.up().up().up().close();
					}
				}
			}
		}
	},{
		xtype:'griddashlet',
		itemId:'byUserEnquiryList',
		title:getCommonTranslation('ENQUIRY_COUNT_DASHLET'),
		header:false,
		model:'Academia.model.enquiry.reports.EnquiryTallyDashletModel',
		url : SERVERURL.COUNT_ENQUIRY_LIST,
		addPagingToolbar : true,
		columns : [/*{
			hidden: true,
			dataIndex: 'enqId'
		},*/ {
			text : getEnquiryTranslation('ENQUIRY_ID'),
			dataIndex : 'enqCode',
			sortable : true,
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_DATE'),
			dataIndex : 'enquiryDate',
			sortable : true,
			flex:0.1,
			renderer : function(date) {
				return dateRender(date);
			}
		},{
			text : getEnquiryTranslation('ENQUIRER_NAME'),
			dataIndex : 'enquirerName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('STUDENT_NAME'),
			dataIndex : 'studentName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('GENDER'),
			dataIndex : 'genderCSM',
			sortable : true,
			flex:0.1,
			renderer: function(value) {
				return value=getEnquiryTranslation(value);
			}
		},{
			text : getEnquiryTranslation('ADDRESS_MOBILE_NO'),
			dataIndex : 'mobileCountryCodeContactNo',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_OWNER'),
			dataIndex : 'enqOwner',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('SOURCE'),
			dataIndex : 'sourceEnqName',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('ENQUIRY_STAGE'),
			dataIndex : 'enquiryStage',
			itemId:'enquiryStageItemId8',
			sortable : true,
			flex:0.1
		},{
			text : getEnquiryTranslation('APPLICANT_ID'),
			dataIndex : 'applicantCode',
			itemId:'applicantCodeItemId8',
			renderer: function(value) {
				if(!isNullOrEmpty(value)){
					return value="<a href='#'>"+value+"</a>";
				}else{
					return "-";
				}
			},
			sortable : true,
			flex:0.1
		}],
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.activeTab = 23;
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeProgramGroupEnquiry();
				enquirycountdashlet.removeSourceEnquiry();
				enquirycountdashlet.removeUsersEnquiry();
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			},
			cellclick: function( cell, td, cellIndex,record, tr, rowIndex, e, eOpts) {
				var $this=this;
				if(e.target.tagName == 'A'){
					var enquiryCountGrid = cell.up('grid');
					var selectedRecord = enquiryCountGrid.getSelectionModel().getSelection()[0];
					var columnName = enquiryCountGrid.columnManager.columns[cellIndex].dataIndex;
					var enquiryController =  Academia.app.getController('Academia.controller.enquiry.EnquiryController');
					if(columnName=='enqCode'){
						var trackEnquiryController =  Academia.app.getController('Academia.controller.enquiry.TrackEnquiryController');
						trackEnquiryController.openEnquiryFromDashlet(0,0,enquiryCountGrid,'Edit');
					}else{
						if(columnName=='applicantCode'){
							var applicantId = record.get('applicantId'); 
							enquiryController.openApplicantProfileFromDashlet(applicantId, true,enquiryCountGrid,record);

						}
					}
					if(this.up('dashboardhomepage') == undefined){
						enquiryCountGrid.up().up().up().close();
					}
				}
			}
		}
	},{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
		//src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
		listeners:{
			activate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.addExportToPdf(enquirycountdashlet);
				enquirycountdashlet.activeTab = 24;
				enquirycountdashlet.addGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.addExportToPdf(enquirycountdashlet,portlet);
				enquirycountdashlet.addExportToExcel(enquirycountdashlet,portlet);
			},
			deactivate:function(portlet){
				var enquirycountdashlet=portlet.up('enquirycountdashlet');
				enquirycountdashlet.removeGraphViewButton(enquirycountdashlet);
				enquirycountdashlet.removeExportToPdf();
				enquirycountdashlet.removeExportToExcel();
			}
		}
	}]
});