/**
 * @author Amit G
 */
Ext.define('Academia.view.dashboard.dashlets.StudentProgressWeightDashlet', {
	extend : 'Academia.view.dashboard.DashboardDashlet',
	alias : 'widget.studentprogressweightdashlet',

	/* requires : ['Academia.view.dashboard.dashlets.GridDashlet',
               'Academia.model.common.AcademyLocationProgramModel' ], */

	graphView:true,
	layout:'card',
	activeItem: 0, 
	cls:'StudentProgressWeightDashletCLS dashlet',
	loadDashlet :function(){
		var this$=this;
		var view= this.layout.getActiveItem();
		if(view.xtype=='griddashlet' || view.xtype=='studenttipchartforweight'){
			var store= view.getStore();
			var extraparams=this$.getParams();
			var userId = this$.getCurrentlyLoggedInDashletUser().id;
			store.getProxy().extraParams = {
				userId: userId,
				//messageType: 'Notifications'
			};
			store.load({params:extraparams,
				callback: function(rec, operation, success) {
					if(!isNullOrEmpty(rec) && rec.length==0){
						this$.layout.setActiveItem(2);
					}
				}
			});

			//store.load();
		}
	},
	defaults: {
		cls:'panelNoSpace',
		xtype:'griddashlet'
	},

	items:[{
		xtype : 'studenttipchartforweight',
		itemId:'studenttipchartforweightItemId',
		xAxesCategoryField :['mnthYear'],
		yAxesNumericField : 'studentWeight',
		yAxesNumericField1 : 'classAvgWeight',
		yAxesNumericField2 : 'ageAvgWeight',
		model:'Academia.model.student.studentprofile.StudentProgressReportModel',
		url : SERVERURL.STUDENT_WEIGHT_GRAPH_DASHLET,
		listeners:{
			activate:function(portlet){
				var studentprogressweightdashlet=portlet.up('studentprogressweightdashlet');
				studentprogressweightdashlet.activeTab = 1;
				studentprogressweightdashlet.addGridViewButton(studentprogressweightdashlet);
				studentprogressweightdashlet.addExportToPng(studentprogressweightdashlet,portlet);
			},
			deactivate:function(portlet){
				var studentprogressweightdashlet=portlet.up('studentprogressweightdashlet');
				studentprogressweightdashlet.removeGridViewButton(studentprogressweightdashlet);
				studentprogressweightdashlet.removeExportToPng();
			}
		}
	},{
		//model:'Academia.model.student.studentprofile.StudentProgressReportModel',
		fields :['mnthYear', 'studentWeight', 'classAvgWeight', 'ageAvgWeight'],
		url : SERVERURL.STUDENT_WEIGHT_GRAPH_DASHLET,
		addPagingToolbar : true,
		columns : [{
			text : getCommonTranslation('MONTHYEAR'),
			dataIndex: 'mnthYear',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('STUDENTWEIGHT'),
			dataIndex : 'studentWeight',
			sortable : true,
			flex:0.3
		}, {
			text : getCommonTranslation('CLASSAVG'),
			dataIndex : 'classAvgWeight',
			sortable : true,
			flex:0.2
		},  {
			text : getCommonTranslation('AGEAVG'),
			dataIndex: 'ageAvgWeight',
			sortable : true,
			flex:0.2
		}],
		listeners:{
			activate:function(portlet){
				var studentprogressweightdashlet=portlet.up('studentprogressweightdashlet');
				studentprogressweightdashlet.addExportToPdf(studentprogressweightdashlet);
				studentprogressweightdashlet.activeTab = 0;
				studentprogressweightdashlet.addGraphViewButton(studentprogressweightdashlet);
				studentprogressweightdashlet.addExportToPdf(studentprogressweightdashlet,portlet);
				studentprogressweightdashlet.addExportToExcel(studentprogressweightdashlet,portlet);
				portlet.doLayout();
			},
			deactivate:function(portlet){
				var studentprogressweightdashlet=portlet.up('studentprogressweightdashlet');
				studentprogressweightdashlet.removeGraphViewButton(studentprogressweightdashlet);
				studentprogressweightdashlet.removeExportToPdf();
				studentprogressweightdashlet.removeExportToExcel();
			}
		}
	},{
		xtype: 'panel',
		width: '100%',
		height: '100%',
		html: '<div><div class ="dashletNoRecordFoundImageCls" /><span>'+getCommonTranslation('EMPTY_MESSAGE')+'</span></div>',
	
		/*xtype: 'image',
		width: '100%',
		height: '100%',
		frame : false,
		src: CONSTANTS.NO_DATA_DISPALY_DASHBORD_IMAGE_SRC,//'resources/images/no_data_to_display.png',
*/		listeners:{
			activate:function(portlet){
				var studentprogressweightdashlet=portlet.up('studentprogressweightdashlet');
				studentprogressweightdashlet.addExportToPdf(studentprogressweightdashlet);
				studentprogressweightdashlet.activeTab = 1;
				studentprogressweightdashlet.addGraphViewButton(studentprogressweightdashlet);
				studentprogressweightdashlet.addExportToPdf(studentprogressweightdashlet,portlet);
				studentprogressweightdashlet.addExportToExcel(studentprogressweightdashlet,portlet);
			},
			deactivate:function(portlet){
				var studentprogressweightdashlet=portlet.up('studentprogressweightdashlet');
				studentprogressweightdashlet.removeGraphViewButton(studentprogressweightdashlet);
				studentprogressweightdashlet.removeExportToPdf();
				studentprogressweightdashlet.removeExportToExcel();
			}
		}
	}]
});
