/**
 * 
 * @author Vidhi Shah
 */
Ext.define('Academia.view.document.AdhocDocumentFormWindow', {
	extend: 'Ext.window.Window',
	alias : 'widget.adhocdocumentformwindow',
	title: getPersonModuleTranslation('DOCUMENTS_DETAILS'),
    plugins: "formlabelrequired",
    autoScroll: true,
    modal: true,
    height: '65%',
    items: [{
        xtype: 'form',
        itemId: 'adhocDocumentFormWindowItemId',
        items: [{
			xtype : 'hidden',
			itemId : 'document_hidden_field',
			name : 'id'
		}, {
			xtype : 'hidden',
			name : 'module'
		}, {
			xtype : 'hidden',
			name : 'entityId'
		}, {
			xtype : 'hidden',
			name : 'entityType'
		}, {
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width : 226
			},
			items : [ {
				xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('DOCUMENTS_NAME'),
                name: 'documentName',
                itemId: 'documentNameItemId',
                maxLength: 255,
                allowBlank: false
			}, {
				xtype : 'datefield',
				fieldLabel : getPersonModuleTranslation('DATE_SUBMISSION'),
				name : 'submissionDate',
				itemId : 'submissionDate',
				value: new Date(),
				allowBlank : false,
				listeners: {
					render: function(obj) {
						obj = dateFormatRender(obj);						
						obj.setValue(new Date());
					}
				}
			} ]
		}, {
			xtype : 'fieldcontainer',
			layout : 'hbox',
			itemId : 'fileFieldContainer',
			defaults : {
				labelAlign : 'top',
				width : 226
			},
			items : [ {
				xtype : 'filefield',
				itemId : 'uploadFileField',
				region: 'south',
				ui : 'CustomBtnSubmit',
				fieldLabel: getPersonModuleTranslation('SELECT_FILE'),
                buttonText: getPersonModuleTranslation('UPLOAD'),
				allowBlank : false,
				name : 'file'
			}, {
				xtype: 'textfield',
                itemId: 'remarkItemId',
                fieldLabel: getPersonModuleTranslation('REMARK'),
                name: 'remark',
                maxLength: 255,
                readOnly: false,
                allowBlank: true
			  } ]
		}, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId: 'fileInfoContainer',
            hidden: true,
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
                xtype: 'displayfield',
                itemId: 'docDetails'
            }]
		}, {
			xtype : 'fieldcontainer',
			layout : 'hbox',
			defaults : {
				labelAlign : 'top',
				width : 226
			},
			items : [ {
				xtype : 'nestedJsonCombo',
				itemId : 'documentStatus',
				fieldLabel : getPersonModuleTranslation('STATUS'),
			    store: 'common.DocumentStatusCSMStore',
			    name: 'documentStatusCSM',
	            valueField: 'id',
	            displayField: 'value',
				readOnly: true,
				editable : false,
				allowBlank : false
			}]
		}, {
			xtype : 'fieldcontainer',
			width : '100%',
			cls : 'windowBtnPos',
			style: {
				marginTop: '17px',
			    marginLeft: '-2px'
			},
			items : [ {
				xtype : 'button',
				text : getCommonTranslation('SUBMIT'),
				itemId : 'documentFormSubmitButtonId',
				buttonAlign : 'right',
				ui : 'CustomBtnSubmit',
				scale : CONSTANTS.BUTTONSIZE,
				formBind : true
			}, {
				xtype : 'button',
				buttonAlign : 'right',
				text : getCommonTranslation('CANCEL'),
				ui : 'CustomBtnCancel',
				itemId : 'documentCancelButtonId',
				scale : CONSTANTS.BUTTONSIZE
			} ]
		}]
	} ]

});