/**
 * This view is used for extended document form
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.document.ExtendedDocumentForm', {
	//extend : 'Ext.form.Panel',
	extend: 'Academia.view.common.DynamicFieldForm',
	alias : 'widget.extendeddocumentform',
	autoScroll : false,
	plugins: "formlabelrequired",
	items : [ {
		xtype : 'hidden',
		itemId : 'document_hidden_field',
		name : 'id'
	}, {
		xtype : 'hidden',
		name : 'module'
	}, {
		xtype : 'hidden',
		name : 'entityId'
	}, {
		xtype : 'hidden',
		name : 'entityType'
	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		items : [ {
			xtype : 'nestedJsonCombo',
			//V2D-395
			fieldLabel : getPersonModuleTranslation('DOCUMENTS_NAME'),
			//fieldLabel : getPersonModuleTranslation('DOCUMENTS_TYPE'),
			store:'common.DocumentTypeStore',
			name : 'documentType',
			displayField : 'value',
			valueField : 'id',
			allowBlank : false,
			itemId:'documentTypeCombo'
		},{
			xtype : 'customcombobox',
			fieldLabel : getPersonModuleTranslation('DOCUMENTS_NAME'),
			store:'examinationcenters.evaluationgrouplisting.documentsubmit.DocumentNameByEvalGroup',
			name : 'name',
			displayField : 'value',
			valueField : 'value',
			allowBlank : true,
			disabled:true,
			hidden:true,
			itemId:'name'
		}, {
			xtype : 'datefield',
			fieldLabel : getPersonModuleTranslation('DATE_SUBMISSION'),
			name : 'submissionDate',
			itemId : 'submissionDate',
			value: new Date(),
			//readOnly: true,
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			allowBlank : false,
			listeners: {
				render: function(obj) {
					obj = dateFormatRender(obj);						
					obj.setValue(new Date());
				}
			}
		} ]
	}, {
		xtype : 'fieldcontainer',
		layout : 'fit',
		itemId : 'documentTypeContainer',
		defaults : {
			labelWidth : 170
		},
		items : [ {
			xtype : 'radiogroup',
			columns : 2,
			vertical : true,
			itemId : 'documentTypeRadioGroup',
			items : [ {
				boxLabel : getPersonModuleTranslation('ELECTRONIC'),
				name : 'isElectronic',
				itemId : 'electonicField',
				inputValue : true,
				checked : true
			}, {
				boxLabel : getPersonModuleTranslation('PHYSICAL'),
				name : 'isElectronic',
				itemId : 'physicalField',
				inputValue : false
			} ]
		} ]
	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		itemId : 'fileFieldContainer',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		items : [ {
			xtype : 'livesearchcombo',
			itemId : 'responsibleUserField',
			fieldLabel : getPersonModuleTranslation('PHYSICAL_DOCUMENTS'),
			name : 'responsibleUser',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			allowBlank : false
		}, {
			xtype : 'filefield',
			itemId : 'uploadFileField',
			region: 'south',
			/*style: {
				marginTop: '17px'
			},*/
			ui : 'CustomBtnSubmit',
			fieldLabel : getPersonModuleTranslation('SELECT_FILE'),
			buttonText : getPersonModuleTranslation('UPLOAD'),
			allowBlank : false,
			name : 'file'
		} ]
	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		itemId : 'fileInfoContainer',
		hidden:true,
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		items : [{
			xtype:'displayfield',
			itemId:'docDetails'
		}]
	},
	{
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		items : [ {
			xtype : 'customcombobox',
			fieldLabel : getPersonModuleTranslation('MODE_SUBMISSION'),
			store : 'document.DocumentModeSubmissionStore',
			name : 'modeOfSubmission',
			valueField : 'name',
			displayField : 'value',
			itemId : 'modeOfSubmission',
			editable : false,
			allowBlank : false
		},{
			xtype : 'nestedJsonCombo',
			fieldLabel : getPersonModuleTranslation('DOCUMENTS_TYPE'),
			store:'common.DocTypeStore',
			name : 'docType',
			displayField : 'value',
			valueField : 'name',
			hidden: true,
			itemId:'docTypeId'
		}/*, {
			xtype : 'fieldcontainer',
			layout : 'hbox',
			itemId : 'fileInfoContainer',
			hidden:true,
			defaults : {
				labelAlign : 'top',
				width : 226
			},
			items : [{
				xtype:'displayfield',
				itemId:'docDetails'
			}]
		},*/]
	}, {

		xtype : 'fieldcontainer',
		layout : 'fit',
		itemId : 'inspectionRequiredContainer',
		defaults : {
			labelWidth : 170
		},
		items : [ {
			xtype : 'radiogroup',
			itemId : 'inspectionRequiredRadioGroupField',
			fieldLabel : getPersonModuleTranslation('INSPECTION_REQUIRED'),
			name : 'isInspectionRequired',
			columns : 2,
			vertical : true,
			items : [ {
				itemId : 'isInspectionRequiredYesField',
				boxLabel : getPersonModuleTranslation('YES'),
				name : 'isInspectionRequired',
				inputValue : true
				
			}, {
				itemId : 'isInspectionRequiredNoField',
				boxLabel : getPersonModuleTranslation('NO'),
				name : 'isInspectionRequired',
				inputValue : false,
				checked : true
			} ]
		}, {
			xtype : 'radiogroup',
			itemId : 'inspectionDoneRadioGroupField',
			fieldLabel : getPersonModuleTranslation('INSPECTION_DONE'),
			labelWidth : 105,
			columns : 2,
			vertical : true,
			disabled : true,
			name : 'isInspectionDone',
			items : [ {
				itemId : 'isInspectionDoneYesField',
				boxLabel : getPersonModuleTranslation('YES'),
				name : 'isInspectionDone',
				//style:{marginLeft:'-60px'},
				inputValue : true
			}, {
				itemId : 'isInspectionDoneNoField',
				boxLabel : getPersonModuleTranslation('NO'),
				name : 'isInspectionDone',
				inputValue : false,
				//style:{marginLeft:'-10px'},
				checked : true
			} ]
		} ]
	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		itemId : 'inspectionDateContainer',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		items : [ {
			xtype : 'datefield',
			itemId : 'inspectionDateField',
			fieldLabel : getPersonModuleTranslation('INSPECTED_DATE'),
			name : 'inspectionDate',
			allowBlank : false,
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			disabled : true,
			listeners: {
                render: function(obj) {
                    obj = dateFormatRender(obj);
                    //obj.setValue(new Date());
                }
            }
		}, {
			xtype : 'livesearchcombo',
			itemId : 'inspectionDoneByField',
			fieldLabel : getPersonModuleTranslation('INSPECTED_BY'),
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			name : 'inspectionDoneBy',
			allowBlank : false,
			disabled : true
		} ]
	}, {
		xtype : 'fieldcontainer',
		itemId : 'returnableContainer',
		layout : 'fit',
		items : [ {
			xtype : 'radiogroup',
			fieldLabel : getPersonModuleTranslation('RETURNABLE'),
			labelWidth : 95,
			columns : 2,
			vertical : true,
			itemId : 'returnableRadioGroup',
			name : 'isReturnable',
			items : [ {
				itemId : 'isReturnableYesField',
				boxLabel : getPersonModuleTranslation('YES'),
				name : 'isReturnable',
				//style:{marginLeft:'-20px'},
				inputValue : true
			}, {
				itemId : 'isReturnableNoField',
				boxLabel : getPersonModuleTranslation('NO'),
				name : 'isReturnable',
				inputValue : false,
				//style:{marginLeft:'-10px'},
				checked : true
			} ]
		} ]

	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		itemId:'returnDateContainer',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		items : [ {
			xtype : 'datefield',
			itemId : 'returnDateField',
			fieldLabel : getPersonModuleTranslation('RETURENED_DATE'),
			name : 'returnedDate',
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			allowBlank : false,
			listeners: {
                render: function(obj) {
                    obj = dateFormatRender(obj);
                    //obj.setValue(new Date());
                }
            }
		}, {
			xtype : 'livesearchcombo',
			itemId : 'returnByField',
			fieldLabel : getPersonModuleTranslation('RETURENED_BY'),
			name : 'returnedBy',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			allowBlank : false
		} ]
	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		itemId:'modeReturnContainer',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		items : [ {
			xtype : 'customcombobox',
			itemId : 'modeOfReturnField',
			fieldLabel : getPersonModuleTranslation('MODE_RETURN'),
			store : 'document.DocumentModeSubmissionStore',
			name : 'modeOfReturn',
			valueField : 'name',
			displayField : 'value',
			allowBlank : false
		}, {
			xtype : 'livesearchcombo',
			itemId : 'returnedToUserField',
			fieldLabel : getPersonModuleTranslation('RETURENED_TO'),
			name : 'returnedToUser',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			allowBlank : false
		} ]
	}, {
		xtype : 'fieldcontainer',
		layout : 'hbox',
		defaults : {
			labelAlign : 'top',
			width : 226
		},
		items : [ {
			xtype : 'datefield',
			itemId:'lastDateSubmissionId',
			fieldLabel : getPersonModuleTranslation('LAST_SUBMISSION_DATE'),
			name : 'validTillDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}, {
			xtype : 'nestedJsonCombo',
			itemId : 'documentStatus',
			fieldLabel : getPersonModuleTranslation('STATUS'),
		    store: 'common.DocumentStatusCSMStore',
//			hidden : true,
//			disabled : true,
		    name: 'documentStatusCSM',
            valueField: 'id',
            displayField: 'value',
			readOnly: true,
			editable : false,
			//value: 'SUBMITTED',
			allowBlank : false
		}]
	},{
	       xtype: 'textareafield',
	       name: 'documentNote',
	       itemId : 'documentNoteId',
	       fieldLabel: getCommonTranslation('NOTE'),
	       labelAlign: 'top',
	       width: 475,
	       height: 100,
	       maxLength: 500
	  },
	  {
  		xtype: 'checkboxfield',
  		name: 'visibleNoteOnPortal',
  		boxLabel: getCommonTranslation('VISIBLE_NOTE_ON_PORTAL'),
  		itemId:'visibleNoteOnPortal',
  		inputValue : true,
  		uncheckedValue: false
  	}, 
	{
		xtype : 'fieldcontainer',
		width : '100%',
		cls : 'windowBtnPos',
		style: {
			marginTop: '17px',
		    marginLeft: '-2px'
		},
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SUBMIT'),
			itemId : 'documentFormSubmitButtonId',
			buttonAlign : 'right',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}, {
			xtype : 'button',
			buttonAlign : 'right',
			text : getCommonTranslation('CANCEL'),
			ui : 'CustomBtnCancel',
			itemId : 'documentCancelButtonId',
			scale : CONSTANTS.BUTTONSIZE
		} ]
	} ]

});
