Ext.define('Academia.view.documentmanagement.DocumentGroupForm',{	 
	extend:'Academia.view.common.DynamicFieldForm',
	alias:'widget.documentgroupform',
	//titleCollapse: true,
	//title:getCommonTranslation('BASIC_DETAILS'),
	padding: 10,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	autoScroll:false,
	//plugins : "formlabelrequired",
	
	defaults : {
		
		tdAttrs: { style: 'padding: 5px;' },
				
	},
	items:[{
        xtype: 'form',
        method:'POST',
        plugins: "formlabelrequired",
        bodyStyle: {
            background: 'transparent'
        },
	items:[{
		xtype:'fieldcontainer',
		width:'100%',
		defaults : {
			xtype:'textfield',
			labelAlign:'top',
			enforceMaxLength : true		
		},
		items:[{
			xtype: 'hidden',
			name:'id'
		},{
			xtype: 'hidden',
			name:'isDocumentRequested'
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
				xtype:'textfield',
				fieldLabel:getCommonTranslation('NAME'),
				allowBlank:false,
				itemId:'name',
				name:'name'
			     },{
			        	xtype: 'customcombobox',
			        	name: 'status',
			        	itemId:'statusItemId',
			        	store:'common.StatusComboStore',
			        	displayField:'name',
			        	valueField:'id',
			        	//value:'ACTIVE',
			        	forceSelection:true,
			        	editable:false,
			        	typeAhead:true,
			        	allowBlank:false,
			        	fieldLabel:getCommonTranslation('STATUS')
			        },{
						xtype: 'datefield',
						name: 'dueOn',
						allowBlank:false,
						fieldLabel: getCommonTranslation('SUBMISSION_LAST_DATE'),
						itemId:'dueOnId',
						width:226,
						format: CONSTANTS.DATE_FORMAT,
						//endDateField : 'toDateId',
						//vtype: 'daterange',
						 listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							}
					}]},{
			xtype: 'text',
			text: ''
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
	        	xtype: 'customcombobox',
	        	name: 'applicableOn',
	        	fieldLabel: getCommonTranslation('APPLICABLE_TO'),
	        	itemId:'applicableOnId',
	        	store: 'documentmanagement.DocumentGroupMasterApplicableOnStore',
	        	displayField:'name',
	        	valueField:'value',
	        	allowBlank:false,
	        	editable: false,
	        	width:226
	        },{
            xtype: 'radiogroup',
            itemId: 'groupTypeRadio',
            name: 'groupTypeRadio',
            fieldLabel: getCommonTranslation('UPLOAD_MODE'),
            columns: 2,
            width:270,
            //labelWidth: 'auto',
            vertical: false,
            layout: {
            	type: 'hbox'
            },
            items: [{
                boxLabel: getCommonTranslation('SINGLE_TIMES'),
                name: 'wetherConfigured',
                itemId: 'singletimes',
                inputValue: false,
               checked: true
            }, {
                boxLabel: getCommonTranslation('MULTIPLE_TIMES'),
                name: 'wetherConfigured',
                itemId: 'multipletimes',
                inputValue: true,
                //checked: true
            }]
		},{
			xtype:'checkbox',
			itemId : 'allowafteduodateId',
			name:'allowafteduodate',
			style: 'margin-top: 25px',
			boxLabel:getCommonTranslation('ALLOW_AFTER_DUE_DATE'),
			inputValue: true,
			uncheckedValue: false
		}]},{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
			       xtype: 'textareafield',
			       name: 'description',
			       itemId : 'descriptionId',
			       fieldLabel: getCommonTranslation('DESCRIPTION'),
			      // labelAlign: 'top',
			       width: 475,
			      // height: 100,
			        }]
			}]	
		},{
			xtype: 'fieldset',
			collapsible : true,
			collapsed: true,
			title: getCommonTranslation('DOCUMENT_TO_UPLOAD'),
			titleCollapse: true,
			margin: '0 0 0 0',
			padding: '0 0 0 0',
			width: '100%',
			itemId : 'courseSelectionDetailsItemId',
			items:[{
			xtype:'fieldcontainer',
			itemId:'serviceStopPanelId',
//			itemId:'stopPanelId',
			items:[{
				xtype : 'fieldcontainer',
				width: '100%',
				layout : 'hbox',
				defaults: {
					//width:226,
					labelAlign: 'top'
				},
				items : [{
					xtype: 'hidden',
					name: 'jobMappingId',
				},{
		            xtype: 'textfield',
		            fieldLabel: getCommonTranslation('UPLOAD_NAME'),
		            name: 'uploadName',
		            itemId: 'uploadNameItemId',
		           // editable: false,
		           // allowBlank: false,
		           // store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
		            displayField: 'value',
		            width:150,
		            valueField: 'id'
		            //            queryMode:'local'		
		        },{
		            xtype: 'multiselectcombofield',
		            fieldLabel: getCommonTranslation('TYPE'),
		            name: 'typeName',
		            itemId: 'typeItemId',
		            cls:'multiBrandCampusCls',
		            width:150,
		           store: Ext.create('Academia.store.documentmanagement.DocumentGroupMasterFileTypeStore'),
		           displayField:'name',
		        	valueField:'value',
		        	typeAhead : true,
		            
		        },{
		            xtype: 'numberfield',
		            fieldLabel: getCommonTranslation('MAX_SIZE'),
		            name: 'sizeName',
		            itemId: 'sizeNameItemId',
		            width:150,
		            hideTrigger: true,
			        keyNavEnabled: false,
			        mouseWheelEnabled: false,
			        allowExponential:false,
			        maxLength:5,
			        maxValue:25600,
		           	
		        },{
		    		xtype: 'textfield',
		    		itemId:'refDocumentField',
		    		name: 'refDocumentField',
		    		fieldLabel: getCommonTranslation('REFERENCE_DOCUMENT'),
		    		 width:150,
		    	},{
		    		xtype: 'hidden',
		    		itemId:'refDocumentFieldHidden',
		    		name: 'refDocumentFieldHidden',
		    	},{
		    		xtype: 'button',
		    		itemId:'refDocument',
		    		buttonOnly : true,
		    		ui:'CustomBtnSubmit',
		    		text: getCommonTranslation('UPLOAD'),
		    		style:{
							marginTop:'30px',
							marginLeft:'-10px'
						},
						
		    	},{
					xtype:'fieldcontainer',
					items:[{
						xtype: 'button',
						itemId: 'addJobPostingBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px',
							//marginLeft:'-113px'
						}
					},{
						xtype: 'button',
						itemId: 'DGMDeleteBtn',
						cls: 'CustomBodyBtnReject',
						glyph: ICONGLYPH.DELETEGLYPH,
						tooltip: getCommonTranslation('DELETE'),
						style:{
							marginTop:'30px'
						},
						listeners:{
							click:function(obj){
								var container = obj.up('fieldcontainer').up('fieldcontainer');
								var form = $this.getDocumentgroupform();
								var panelContiner = form.down('#jobPostingContainerId');
								panelContiner.remove(container);
								form.getForm().checkValidity();
							}}
					}]
				}]
			}]
		}]
		}, {
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
		
		items:[{
			xtype: 'fieldcontainer',
			width:'100%',
			layout: {
				type: 'hbox'
			},
			defaults :{
				width: 226,
				labelAlign:'top'
			},
			items: [{
	            xtype: 'multiselectcombofield',
	            name: 'academyLocationId',
	            itemId: 'academyLocationItemId',
	            autoloadStore: false,
	            width: 460,
	            fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
	            store: 'facilitiesresources.resourcebooking.AcademyLocationListByUserStore',
	            cls:'multiBrandCampusCls',
	            valueField: 'id',
	            displayField: 'value',
	            allowBlank: false,
	            queryParam: 'qry',
	           // minChars: 3,
	            typeAhead: true,
	            triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
	            enableKeyEvents: 'true',
	            hideTrigger: false,
	            forceSelection: true,
	            listConfig: {
	                listeners: {
	                    beforeshow: function(picker) {
	                        picker.minWidth = picker.up('combobox').getSize().width;
	                    },
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code}' +
	                        '</div>';
	                }
	            }
	        }]
			
		}]
			},{
		
		items:[{
			xtype:'button',
			text:getCommonTranslation('SAVE'),
			itemId:'submitBtn',
			formBind : true,
			action:'save',
			//align:'right',
			ui:'CustomBtnSubmit',
			scale:CONSTANTS.BUTTONSIZE
		},{
			xtype: 'button',
			text: getExaminationTranslation('RESET'),
			itemId: 'resetButtonId',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			handler: function() {
				var form = this.up('form');
				form.getForm().reset();
				var panel = form.down('#serviceStopPanelId');
				for(var i=panel.items.length-1; i>0;i--){
		    		 panel.remove(panel.items.items[i]);
		    	 }
				var uploadName = form.down('#uploadNameItemId');
				 uploadName.setValue(" ");
				 var type = form.down('#typeItemId');
				 type.setValue(" ");
				 var sizeName = form.down('#sizeNameItemId');
				 sizeName.setValue(" ");
			}
		}]
	}]
	}]
});