/**
 * @author Deepak S
 * 
 */
Ext.define('Academia.view.documentmanagement.DocumentTemplateMappingApplyToCourseGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.documenttemplatemappingapplytocoursegrid',
	store : 'documentmanagement.DocumentTemplateMappingApplyToALCourseGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	//autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'documentmanagement.DocumentTemplateMappingApplyToALCourseGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header:  getProgramandcourseTranslation("ACADEMY_LOCATION"),
		dataIndex: 'academyLocationName',
		flex:1
	},{
		header:  getCommonTranslation("COURSE_CODE_NAME"),
		dataIndex: 'courseName',
		flex:1
	}]
});
