/**
 * @author Deepak S
 * 
 */
Ext.define('Academia.view.documentmanagement.DocumentTemplateMappingApplyToProgamBatchGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.documenttemplatemappingapplytoprogambatchgrid',
	store : 'documentmanagement.DocumentTemplateMappingApplyToALProgramBatchSeatTypeGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	//autoScroll: true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'documentmanagement.DocumentTemplateMappingApplyToALProgramBatchSeatTypeGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns : [{
		header:  getProgramandcourseTranslation("ACADEMY_LOCATION"),
		dataIndex: 'academyLocationName',
		flex:1
	},{
		header:  getCommonTranslation('PROGRAM_GROUP'),
		dataIndex: 'programGroupName',
		flex:1
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1
	},{
		header:  getPersonModuleTranslation('BATCH_NAME'),
		dataIndex: 'batchName',
		flex:1
	},{
		header:  getCommonTranslation('SEAT_NAME'),
		dataIndex: 'seatName',
		flex:1
	}]
});
