/**
 * @author pritam.patil
 * this form is used for Document Template Mapping Listing search form 
 */
Ext.define('Academia.view.documentmanagement.DocumentTemplateMappingSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.documenttemplatemappingsearchform',
    frame: false,
    cls: 'customSearchPanel',
    plugins: "formlabelrequired",
    padding: 10,
    items: [{
        xtype: 'radiogroup',
        itemId: 'radioButtonsPanel',
        name: 'configLevel',
        vertical: false,
        style:{
        	marginLeft: '-5px'
        },
        items: [{
            xtype: 'radiofield',
            boxLabel: getDocumentTranslation('ACADEMY_LOCATION'),
            name: 'configLevel',
            itemId: 'acadLocationRadioId',
            inputValue: 'ACADEMY_LOCATION_LEVEL',
            checked: true
        }, {
            xtype: 'radiofield',
            boxLabel: getDocumentTranslation('COURSE'), //Alpha numeric
            name: 'configLevel',
            inputValue: 'COURSE_LEVEL',
            itemId: 'courseRadioId',
            style: {
                marginLeft: '50px'
            }
        }, {
            xtype: 'radiofield',
            boxLabel: getDocumentTranslation('COMMUNITY'), //Alpha numeric
            name: 'configLevel',
            inputValue: 'COMMUNITY_LEVEL',
            itemId: 'communityRadioId',
            style: {
                marginLeft: '50px'
            }
        }, {
            xtype: 'radiofield',
            boxLabel: getDocumentTranslation('PROGRAM_BATCH_SEAT_TYPE'),
            name: 'configLevel',
            itemId: 'programBatchSeatTypeRadioId',
            inputValue: 'PROGRAM_BATCH_SEAT_TYPE_LEVEL',
            style: {
                marginLeft: '50px'
            }
        },{
        	   xtype: 'radiofield',
               boxLabel: getDocumentTranslation('FLAG_NOTIFICATION'),
               name: 'configLevel',
               itemId: 'flagNotificationId',
               inputValue: 'FLAG_NOTIFICATION',
               style: {
                   marginLeft: '50px'
               }
        }]
    }, {
        xtype: 'fieldcontainer',
        itemId: 'documentTemplateButtonContainer',
        style :{
        	marginTop : '16px',
        	marginLeft : '-2px'
        },
        width: '100%',
        items: [{
            xtype: 'button',
            text: getDocumentTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getDocumentTranslation('RESET'),
            itemId: 'resetBtnId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});