/**
 * @author Raghavendra.Soni
 * 
 */
Ext.define('Academia.view.droolmaster.ApplyDroolStructure', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.applydroolstructure',
    plain: true,
    autoScroll: true,
    items: [{
    	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
    	itemId: 'applydroolgrid',
    	xtype: 'grid',
    	border: true,
    	autoScroll: false,
    	frame:false,
        layout: 'fit',
    	columns: [{
			header : getCommonTranslation('ACADEMY_LOCATION'),
			dataIndex : 'academyLocationName',
			flex : 1,
		},{
			header : getCommonTranslation('PROGRAM'),
			dataIndex : 'programName',
			flex : 1,
		},{
			header : getCommonTranslation('BATCH'),
			dataIndex : 'batchName',
			flex : 1,
		}],
        columnLines: true,
    	store: 'setup.droolrules.ApplyDroolGridStore',
        viewConfig: {
            stripeRows: CONSTANTS.STRIPEROWS,
            deferEmptyText: false
        },
        tbar: [{
            xtype: 'button',
            itemId: 'btnAdd',
            tooltip: getCommonTranslation('ADD'),
            iconCls:'icon-addbutton',
			 cls:'addbutton',
            hasDisableForProfileViewMode:true
        },  {
            xtype: 'button',
            itemId: 'btnDelete',
            cls: 'CustomToolbarBtnReject',
            tooltip: getCommonTranslation('DELETE'),
            iconCls: 'icon-Delete',
			cls:'iconDelete',
            hasDisableForProfileViewMode:true
        }],
        dockedItems: [{
            xtype: 'toolbar',
            dock: 'bottom',
            items: [{
                xtype: 'custompagingtoolbar',
                plugins: ['pagesize'],
                store: 'setup.droolrules.ApplyDroolGridStore',
                emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                displayInfo: true
            }]
        }]
    }]
});