/**
 * @author Rajkumar.patidar
 * 
 */
Ext.define('Academia.view.enquiry.dashboard.FollowupScheduledGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.followupscheduledgrid',
    store : 'enquiry.dashboard.FollowupScheduled',
	border : true,
	autoScroll : false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [ {
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
            plugins:['pagesize'],
			store:'enquiry.dashboard.FollowupScheduled',
			emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	columns : [{
				hidden:true,
				dataIndex:'id'
			},{
				header : getCommonTranslation('ENQUIRY_ID'),
				dataIndex : 'enquiryId',
				flex : 1,
				sortable : true	
			},{
				header : getCommonTranslation('ENQUIRY_TYPE_1'),
				dataIndex : 'enquiryType',
				flex : 1,
				sortable : true	
			},{
				header : getCommonTranslation('ASSIGN_TO'),
				dataIndex : 'assignTo',
				flex : 1,
				sortable : true
			}, {
			    header : getCommonTranslation('NEXT_FOLLOW_UP_DATE'),
			    dataIndex : 'nextFollowupDate',
			    flex : 1,
			    sortable : true,
				renderer:function(date) {
					return dateRender(date);
				}
			}, {
			    header : getCommonTranslation('LAST_FOLLOWUP_DATE'),
			    dataIndex : 'lastFollowupDate',
			    flex : 1,
			    sortable : true,
				renderer:function(date) {
					return dateRender(date);
				}
			}]
});